/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.CodeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoincCodingPropertiesHandler
implements IZipContentsHandlerCsv {
    private static final Logger ourLog = LoggerFactory.getLogger(LoincCodingPropertiesHandler.class);
    public static final String ASK_AT_ORDER_ENTRY_PROP_NAME = "AskAtOrderEntry";
    public static final String ASSOCIATED_OBSERVATIONS_PROP_NAME = "AssociatedObservations";
    public static final String LOINC_NUM = "LOINC_NUM";
    private final Map<String, TermConcept> myCode2Concept;
    private final Map<String, CodeSystem.PropertyType> myPropertyNameTypeMap;

    public LoincCodingPropertiesHandler(Map<String, TermConcept> theCode2concept, Map<String, CodeSystem.PropertyType> thePropertyNameTypeMap) {
        this.myCode2Concept = theCode2concept;
        this.myPropertyNameTypeMap = thePropertyNameTypeMap;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        if (!this.anyValidProperty()) {
            return;
        }
        String code = StringUtils.trim((String)theRecord.get(LOINC_NUM));
        if (StringUtils.isBlank((CharSequence)code)) {
            return;
        }
        String askAtOrderEntryValue = StringUtils.trim((String)theRecord.get(ASK_AT_ORDER_ENTRY_PROP_NAME));
        String associatedObservationsValue = StringUtils.trim((String)theRecord.get(ASSOCIATED_OBSERVATIONS_PROP_NAME));
        if (StringUtils.isBlank((CharSequence)askAtOrderEntryValue) && StringUtils.isBlank((CharSequence)associatedObservationsValue)) {
            return;
        }
        TermConcept srcTermConcept = this.myCode2Concept.get(code);
        if (StringUtils.isNotBlank((CharSequence)askAtOrderEntryValue)) {
            this.addCodingProperties(srcTermConcept, ASK_AT_ORDER_ENTRY_PROP_NAME, askAtOrderEntryValue);
        }
        if (StringUtils.isNotBlank((CharSequence)associatedObservationsValue)) {
            this.addCodingProperties(srcTermConcept, ASSOCIATED_OBSERVATIONS_PROP_NAME, associatedObservationsValue);
        }
    }

    private boolean anyValidProperty() {
        CodeSystem.PropertyType askAtOrderEntryPropType = this.myPropertyNameTypeMap.get(ASK_AT_ORDER_ENTRY_PROP_NAME);
        CodeSystem.PropertyType associatedObservationsPropType = this.myPropertyNameTypeMap.get(ASSOCIATED_OBSERVATIONS_PROP_NAME);
        return askAtOrderEntryPropType == CodeSystem.PropertyType.CODING || associatedObservationsPropType == CodeSystem.PropertyType.CODING;
    }

    private void addCodingProperties(TermConcept theSrcTermConcept, String thePropertyName, String thePropertyValue) {
        List<String> propertyCodeValues = this.parsePropertyCodeValues(thePropertyValue);
        for (String propertyCodeValue : propertyCodeValues) {
            TermConcept targetTermConcept = this.myCode2Concept.get(propertyCodeValue);
            if (targetTermConcept == null) {
                ourLog.error("Couldn't find TermConcept for code: '{}'. Display property set to blank for property: '{}'", (Object)propertyCodeValue, (Object)thePropertyName);
                continue;
            }
            theSrcTermConcept.addPropertyCoding(thePropertyName, "http://loinc.org", propertyCodeValue, targetTermConcept.getDisplay());
            ourLog.trace("Adding coding property: {} to concept.code {}", (Object)thePropertyName, (Object)theSrcTermConcept.getCode());
        }
    }

    private List<String> parsePropertyCodeValues(String theValue) {
        return Arrays.stream(theValue.split(";")).map(String::trim).collect(Collectors.toList());
    }
}

