/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;

public class LoincConsumerNameHandler
implements IZipContentsHandlerCsv {
    private final Map<String, TermConcept> myCode2Concept;

    public LoincConsumerNameHandler(Map<String, TermConcept> theCode2concept) {
        this.myCode2Concept = theCode2concept;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String loincNumber = StringUtils.trim((String)theRecord.get("LoincNumber"));
        if (StringUtils.isBlank((CharSequence)loincNumber)) {
            return;
        }
        String consumerName = StringUtils.trim((String)theRecord.get("ConsumerName"));
        if (StringUtils.isBlank((CharSequence)consumerName)) {
            return;
        }
        TermConcept loincCode = this.myCode2Concept.get(loincNumber);
        if (loincCode == null) {
            return;
        }
        loincCode.addDesignation().setUseDisplay("ConsumerName").setValue(consumerName);
    }
}

