/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InClauseNormalizer {
    public static List<Long> normalizeIdListForInClause(List<Long> theResourceIds) {
        List<Long> retVal = theResourceIds;
        int listSize = theResourceIds.size();
        if (listSize > 1 && listSize < 10) {
            retVal = InClauseNormalizer.padIdListWithPlaceholders(theResourceIds, 10);
        } else if (listSize > 10 && listSize < 50) {
            retVal = InClauseNormalizer.padIdListWithPlaceholders(theResourceIds, 50);
        } else if (listSize > 50 && listSize < 100) {
            retVal = InClauseNormalizer.padIdListWithPlaceholders(theResourceIds, 100);
        } else if (listSize > 100 && listSize < 200) {
            retVal = InClauseNormalizer.padIdListWithPlaceholders(theResourceIds, 200);
        } else if (listSize > 200 && listSize < 500) {
            retVal = InClauseNormalizer.padIdListWithPlaceholders(theResourceIds, 500);
        } else if (listSize > 500 && listSize < 800) {
            retVal = InClauseNormalizer.padIdListWithPlaceholders(theResourceIds, 800);
        }
        return retVal;
    }

    private static List<Long> padIdListWithPlaceholders(List<Long> theIdList, int preferredListSize) {
        List<Long> retVal = theIdList;
        if (InClauseNormalizer.isUnmodifiableList(theIdList)) {
            retVal = new ArrayList<Long>(preferredListSize);
            retVal.addAll(theIdList);
        }
        while (retVal.size() < preferredListSize) {
            retVal.add(-1L);
        }
        return retVal;
    }

    private static boolean isUnmodifiableList(List<Long> theList) {
        try {
            theList.addAll(Collections.emptyList());
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private InClauseNormalizer() {
    }
}

