/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.fql.executor;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.fhirpath.FhirPathExecutionException;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.fql.executor.HfqlDataTypeEnum;
import ca.uhn.fhir.jpa.fql.executor.IHfqlExecutionResult;
import ca.uhn.fhir.jpa.fql.executor.IHfqlExecutor;
import ca.uhn.fhir.jpa.fql.executor.LocalSearchHfqlExecutionResult;
import ca.uhn.fhir.jpa.fql.executor.StaticHfqlExecutionResult;
import ca.uhn.fhir.jpa.fql.parser.HfqlFhirPathParser;
import ca.uhn.fhir.jpa.fql.parser.HfqlStatement;
import ca.uhn.fhir.jpa.fql.parser.HfqlStatementParser;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.util.JpaParamUtil;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateOrListParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.param.QualifierDetails;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.DateTimeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HfqlExecutor
implements IHfqlExecutor {
    public static final int BATCH_SIZE = 1000;
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Set<GroupByKey> NULL_GROUP_BY_KEY = Set.of(new GroupByKey(List.of()));
    private static final Logger ourLog = LoggerFactory.getLogger(HfqlExecutor.class);
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private IPagingProvider myPagingProvider;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;

    @Override
    public IHfqlExecutionResult executeInitialSearch(String theStatement, Integer theLimit, RequestDetails theRequestDetails) {
        try {
            return this.doExecuteInitialSearch(theStatement, theLimit, theRequestDetails);
        }
        catch (Exception e) {
            ourLog.warn("Failed to execute HFFQL statement", (Throwable)e);
            return StaticHfqlExecutionResult.withError((String)ObjectUtils.defaultIfNull((Object)e.getMessage(), (Object)"(no message)"));
        }
    }

    @Nonnull
    private IHfqlExecutionResult doExecuteInitialSearch(String theStatement, Integer theLimit, RequestDetails theRequestDetails) {
        HfqlStatementParser parser = new HfqlStatementParser(this.myFhirContext, theStatement);
        HfqlStatement statement = parser.parse();
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(statement.getFromResourceName());
        if (dao == null) {
            throw new DataFormatException(Msg.code((int)2406) + "Unknown or unsupported FROM type: " + statement.getFromResourceName());
        }
        this.massageSelectColumnNames(statement);
        this.populateSelectColumnDataTypes(statement);
        this.validateWhereClauses(statement);
        this.massageWhereClauses(statement);
        SearchParameterMap map = new SearchParameterMap();
        this.addHfqlWhereClausesToSearchParameterMap(statement, map);
        Integer limit = theLimit;
        if (statement.hasOrderClause()) {
            limit = null;
        } else if (statement.getLimit() != null) {
            limit = limit == null ? statement.getLimit() : Math.min(limit, statement.getLimit());
        }
        HfqlExecutionContext executionContext = new HfqlExecutionContext(this.myFhirContext.newFhirPath());
        IBundleProvider outcome = dao.search(map, theRequestDetails);
        Predicate<IBaseResource> whereClausePredicate = this.newWhereClausePredicate(executionContext, statement);
        IHfqlExecutionResult executionResult = statement.hasCountClauses() ? this.executeCountClause(statement, executionContext, outcome, whereClausePredicate) : new LocalSearchHfqlExecutionResult(statement, outcome, executionContext, limit, 0, whereClausePredicate, this.myFhirContext);
        if (statement.hasOrderClause()) {
            executionResult = this.createOrderedResult(statement, executionResult);
        }
        return executionResult;
    }

    private void validateWhereClauses(HfqlStatement theStatement) {
        for (HfqlStatement.WhereClause next : theStatement.getWhereClauses()) {
            RuntimeResourceDefinition resDef;
            if (!HfqlExecutor.isDataValueWhereClause(next) || !next.getLeft().matches("^[a-zA-Z]+$") || (resDef = this.myFhirContext.getResourceDefinition(theStatement.getFromResourceName())).getChildByName(next.getLeft()) != null) continue;
            throw new InvalidRequestException(Msg.code((int)2429) + "Resource type " + theStatement.getFromResourceName() + " does not have a root element named '" + next.getLeft() + "'");
        }
    }

    private void massageWhereClauses(HfqlStatement theStatement) {
        String fromResourceName = theStatement.getFromResourceName();
        ResourceSearchParams activeSearchParams = this.mySearchParamRegistry.getActiveSearchParams(fromResourceName);
        for (HfqlStatement.WhereClause nextWhereClause : theStatement.getWhereClauses()) {
            String joinedParamValues;
            String comparator;
            String left = null;
            List<String> rightValues = null;
            if (HfqlExecutor.isDataValueWhereClause(nextWhereClause)) {
                left = nextWhereClause.getLeft();
                comparator = "";
                rightValues = nextWhereClause.getRightAsStrings();
            } else if (nextWhereClause.getOperator() == HfqlStatement.WhereClauseOperatorEnum.UNARY_BOOLEAN && nextWhereClause.getRightAsStrings().size() > 1) {
                left = nextWhereClause.getLeft();
                rightValues = nextWhereClause.getRightAsStrings().subList(1, nextWhereClause.getRightAsStrings().size());
                switch (nextWhereClause.getRightAsStrings().get(0)) {
                    case "=": {
                        comparator = "";
                        break;
                    }
                    case "<": {
                        comparator = ParamPrefixEnum.LESSTHAN.getValue();
                        break;
                    }
                    case "<=": {
                        comparator = ParamPrefixEnum.LESSTHAN_OR_EQUALS.getValue();
                        break;
                    }
                    case ">": {
                        comparator = ParamPrefixEnum.GREATERTHAN.getValue();
                        break;
                    }
                    case ">=": {
                        comparator = ParamPrefixEnum.GREATERTHAN_OR_EQUALS.getValue();
                        break;
                    }
                    case "!=": {
                        comparator = ParamPrefixEnum.NOT_EQUAL.getValue();
                        break;
                    }
                    case "~": {
                        comparator = ParamPrefixEnum.APPROXIMATE.getValue();
                        break;
                    }
                    default: {
                        left = null;
                        comparator = null;
                        rightValues = null;
                        break;
                    }
                }
            } else {
                comparator = null;
            }
            if (left == null) continue;
            if (HfqlExecutor.isFhirPathExpressionEquivalent("id", left, fromResourceName)) {
                nextWhereClause.setLeft("id");
                nextWhereClause.setOperator(HfqlStatement.WhereClauseOperatorEnum.SEARCH_MATCH);
                joinedParamValues = rightValues.stream().map(ParameterUtil::escape).collect(Collectors.joining(","));
                nextWhereClause.setRight("_id", joinedParamValues);
                continue;
            }
            if (!HfqlExecutor.isFhirPathExpressionEquivalent("meta.lastUpdated", left, fromResourceName)) continue;
            nextWhereClause.setLeft("id");
            nextWhereClause.setOperator(HfqlStatement.WhereClauseOperatorEnum.SEARCH_MATCH);
            joinedParamValues = rightValues.stream().map(value -> comparator + ParameterUtil.escape((String)value)).collect(Collectors.joining(","));
            nextWhereClause.setRight("_lastUpdated", joinedParamValues);
        }
    }

    private void addHfqlWhereClausesToSearchParameterMap(HfqlStatement statement, SearchParameterMap map) {
        List<HfqlStatement.WhereClause> searchClauses = statement.getWhereClauses();
        for (HfqlStatement.WhereClause nextSearchClause : searchClauses) {
            if (nextSearchClause.getOperator() != HfqlStatement.WhereClauseOperatorEnum.SEARCH_MATCH) continue;
            if (!"id".equals(nextSearchClause.getLeft())) {
                throw new InvalidRequestException(Msg.code((int)2412) + "search_match function can only be applied to the id element");
            }
            if (nextSearchClause.getRight().size() != 2) {
                throw new InvalidRequestException(Msg.code((int)2413) + "search_match function requires 2 arguments");
            }
            List<String> argumentStrings = nextSearchClause.getRightAsStrings();
            String paramName = argumentStrings.get(0);
            String paramValueUnsplit = argumentStrings.get(1);
            QualifiedParamList paramValues = QualifiedParamList.splitQueryStringByCommasIgnoreEscape(null, (String)paramValueUnsplit);
            if (paramName.equals("_id")) {
                map.add("_id", (IQueryParameterOr)new TokenOrListParam(null, paramValues.toArray(EMPTY_STRING_ARRAY)));
                continue;
            }
            if (paramName.equals("_lastUpdated")) {
                DateOrListParam param = new DateOrListParam();
                for (String nextValue : paramValues) {
                    param.addOr(new DateParam(nextValue));
                }
                map.add("_lastUpdated", (IQueryParameterOr)param);
                continue;
            }
            if (paramName.startsWith("_")) {
                throw HfqlExecutor.newInvalidRequestExceptionUnknownSearchParameter(paramName);
            }
            QualifierDetails qualifiedParamName = QualifierDetails.extractQualifiersFromParameterName((String)paramName);
            RuntimeSearchParam searchParam = this.mySearchParamRegistry.getActiveSearchParam(statement.getFromResourceName(), qualifiedParamName.getParamName());
            if (searchParam == null) {
                throw HfqlExecutor.newInvalidRequestExceptionUnknownSearchParameter(paramName);
            }
            QualifiedParamList values = new QualifiedParamList();
            values.setQualifier(qualifiedParamName.getWholeQualifier());
            values.addAll((Collection)paramValues);
            IQueryParameterAnd andParam = JpaParamUtil.parseQueryParams((FhirContext)this.myFhirContext, (RestSearchParameterTypeEnum)searchParam.getParamType(), (String)paramName, List.of(values));
            map.add(qualifiedParamName.getParamName(), andParam);
        }
    }

    private IHfqlExecutionResult createOrderedResult(HfqlStatement theStatement, IHfqlExecutionResult theExecutionResult) {
        int i;
        ArrayList<IHfqlExecutionResult.Row> rows = new ArrayList<IHfqlExecutionResult.Row>();
        while (theExecutionResult.hasNext()) {
            IHfqlExecutionResult.Row nextRow = theExecutionResult.getNextRow();
            rows.add(nextRow);
            Validate.isTrue((rows.size() <= 10000 ? 1 : 0) != 0, (String)"Can not ORDER BY result sets over %d results", (long)10000L);
        }
        List orderColumnIndexes = theStatement.getOrderByClauses().stream().map(t -> {
            int index = theStatement.findSelectClauseIndex(t.getClause());
            if (index == -1) {
                throw new InvalidRequestException(Msg.code((int)2407) + "Invalid/unknown ORDER BY clause: " + t.getClause());
            }
            return index;
        }).collect(Collectors.toList());
        List orderAscending = theStatement.getOrderByClauses().stream().map(HfqlStatement.OrderByClause::isAscending).collect(Collectors.toList());
        Comparator<IHfqlExecutionResult.Row> comparator = null;
        for (i = 0; i < orderColumnIndexes.size(); ++i) {
            int columnIndex = (Integer)orderColumnIndexes.get(i);
            HfqlDataTypeEnum dataType = theExecutionResult.getStatement().getSelectClauses().get(columnIndex).getDataType();
            Comparator<IHfqlExecutionResult.Row> nextComparator = HfqlExecutor.newRowComparator(columnIndex, dataType);
            if (!((Boolean)orderAscending.get(i)).booleanValue()) {
                nextComparator = nextComparator.reversed();
            }
            comparator = comparator == null ? nextComparator : comparator.thenComparing(nextComparator);
        }
        rows.sort(comparator);
        for (i = 0; i < rows.size(); ++i) {
            rows.set(i, ((IHfqlExecutionResult.Row)rows.get(i)).toRowOffset(i));
        }
        List<List<Object>> rowData = rows.stream().map(IHfqlExecutionResult.Row::getRowValues).collect(Collectors.toList());
        return new StaticHfqlExecutionResult(null, theStatement, rowData);
    }

    @Override
    public IHfqlExecutionResult executeContinuation(HfqlStatement theStatement, String theSearchId, int theStartingOffset, Integer theLimit, RequestDetails theRequestDetails) {
        IBundleProvider resultList = this.myPagingProvider.retrieveResultList(theRequestDetails, theSearchId);
        HfqlExecutionContext executionContext = new HfqlExecutionContext(this.myFhirContext.newFhirPath());
        Predicate<IBaseResource> whereClausePredicate = this.newWhereClausePredicate(executionContext, theStatement);
        return new LocalSearchHfqlExecutionResult(theStatement, resultList, executionContext, theLimit, theStartingOffset, whereClausePredicate, this.myFhirContext);
    }

    private IHfqlExecutionResult executeCountClause(HfqlStatement theStatement, HfqlExecutionContext theExecutionContext, IBundleProvider theOutcome, Predicate<IBaseResource> theWhereClausePredicate) {
        Set selectClauses = theStatement.getSelectClauses().stream().filter(t -> t.getOperator() == HfqlStatement.SelectClauseOperator.SELECT).map(HfqlStatement.SelectClause::getClause).collect(Collectors.toSet());
        for (String next : selectClauses) {
            if (theStatement.getGroupByClauses().contains(next)) continue;
            throw HfqlExecutor.newInvalidRequestCountWithSelectOnNonGroupedClause(next);
        }
        Set countClauses = theStatement.getSelectClauses().stream().filter(t -> t.getOperator() == HfqlStatement.SelectClauseOperator.COUNT).map(HfqlStatement.SelectClause::getClause).collect(Collectors.toSet());
        HashMap<GroupByKey, Map> keyCounter = new HashMap<GroupByKey, Map>();
        int batchSize = 1000;
        for (int offset = 0; theOutcome.size() == null || theOutcome.sizeOrThrowNpe() > offset; offset += batchSize) {
            List resources = theOutcome.getResources(offset, offset + batchSize);
            for (IBaseResource iBaseResource : resources) {
                if (iBaseResource == null || !theWhereClausePredicate.test(iBaseResource)) continue;
                ArrayList<List<String>> groupByClauseValues = new ArrayList<List<String>>();
                for (String string : theStatement.getGroupByClauses()) {
                    List nextClauseValues = theExecutionContext.evaluate((IBase)iBaseResource, string, IPrimitiveType.class).stream().map(IPrimitiveType::getValueAsString).collect(Collectors.toList());
                    if (nextClauseValues.isEmpty()) {
                        nextClauseValues.add(null);
                    }
                    groupByClauseValues.add(nextClauseValues);
                }
                Set<GroupByKey> allKeys = this.createCrossProduct(groupByClauseValues);
                for (GroupByKey nextKey : allKeys) {
                    Map counts = keyCounter.computeIfAbsent(nextKey, t -> new HashMap());
                    if (keyCounter.size() >= 10000) {
                        throw new InvalidRequestException(Msg.code((int)2402) + "Can not group on > 10000 terms");
                    }
                    for (String nextCountClause : countClauses) {
                        if (!nextCountClause.equals("*") && theExecutionContext.evaluateFirst((IBase)iBaseResource, nextCountClause, IBase.class).isEmpty()) continue;
                        counts.computeIfAbsent(nextCountClause, k -> new AtomicInteger()).incrementAndGet();
                    }
                }
            }
        }
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        for (Map.Entry entry : keyCounter.entrySet()) {
            ArrayList<Object> nextRow = new ArrayList<Object>();
            for (HfqlStatement.SelectClause selectClause : theStatement.getSelectClauses()) {
                if (selectClause.getOperator() == HfqlStatement.SelectClauseOperator.SELECT) {
                    int groupByIndex = theStatement.getGroupByClauses().indexOf(selectClause.getClause());
                    nextRow.add(((GroupByKey)entry.getKey()).getNames().get(groupByIndex));
                    continue;
                }
                AtomicInteger counter = (AtomicInteger)((Map)entry.getValue()).get(selectClause.getClause());
                if (counter != null) {
                    nextRow.add(counter.intValue());
                    continue;
                }
                nextRow.add(0);
            }
            rows.add(nextRow);
        }
        return new StaticHfqlExecutionResult(null, theStatement, rows);
    }

    private Set<GroupByKey> createCrossProduct(List<List<String>> theGroupByClauseValues) {
        if (theGroupByClauseValues.isEmpty()) {
            return NULL_GROUP_BY_KEY;
        }
        HashSet<GroupByKey> retVal = new HashSet<GroupByKey>();
        ArrayList<String> valueHolder = new ArrayList<String>();
        this.createCrossProductRecurse(theGroupByClauseValues, retVal, valueHolder);
        return retVal;
    }

    private void createCrossProductRecurse(List<List<String>> theGroupByClauseValues, Set<GroupByKey> theGroupsSetToPopulate, List<String> theCurrentValueChain) {
        List<String> nextOptions = theGroupByClauseValues.get(0);
        for (String nextOption : nextOptions) {
            theCurrentValueChain.add(nextOption);
            if (theGroupByClauseValues.size() == 1) {
                theGroupsSetToPopulate.add(new GroupByKey(theCurrentValueChain));
            } else {
                this.createCrossProductRecurse(theGroupByClauseValues.subList(1, theGroupByClauseValues.size()), theGroupsSetToPopulate, theCurrentValueChain);
            }
            theCurrentValueChain.remove(theCurrentValueChain.size() - 1);
        }
    }

    private Predicate<IBaseResource> newWhereClausePredicate(HfqlExecutionContext theExecutionContext, HfqlStatement theStatement) {
        return r -> {
            for (HfqlStatement.WhereClause nextWhereClause : theStatement.getWhereClauses()) {
                boolean haveMatch;
                try {
                    switch (nextWhereClause.getOperator()) {
                        case SEARCH_MATCH: {
                            haveMatch = true;
                            break;
                        }
                        case UNARY_BOOLEAN: {
                            haveMatch = HfqlExecutor.evaluateWhereClauseUnaryBoolean(theExecutionContext, r, nextWhereClause);
                            break;
                        }
                        default: {
                            haveMatch = HfqlExecutor.evaluateWhereClauseBinaryEqualsOrIn(theExecutionContext, r, nextWhereClause);
                            break;
                        }
                    }
                }
                catch (FhirPathExecutionException e) {
                    String expression = nextWhereClause.getOperator() == HfqlStatement.WhereClauseOperatorEnum.UNARY_BOOLEAN ? nextWhereClause.asUnaryExpression() : nextWhereClause.getLeft();
                    throw new InvalidRequestException(Msg.code((int)2403) + "Unable to evaluate FHIRPath expression \"" + expression + "\". Error: " + e.getMessage());
                }
                if (haveMatch) continue;
                return false;
            }
            return true;
        };
    }

    private void populateSelectColumnDataTypes(HfqlStatement statement) {
        HfqlFhirPathParser fhirPathParser = new HfqlFhirPathParser(this.myFhirContext);
        for (HfqlStatement.SelectClause nextSelectClause : statement.getSelectClauses()) {
            HfqlDataTypeEnum nextType;
            if (nextSelectClause.getOperator() == HfqlStatement.SelectClauseOperator.COUNT) {
                nextType = HfqlDataTypeEnum.INTEGER;
            } else {
                String clause = nextSelectClause.getClause();
                if (clause.equals("meta.versionId")) {
                    nextType = HfqlDataTypeEnum.LONGINT;
                } else {
                    nextType = fhirPathParser.determineDatatypeForPath(statement.getFromResourceName(), clause);
                    nextType = (HfqlDataTypeEnum)((Object)ObjectUtils.defaultIfNull((Object)((Object)nextType), (Object)((Object)HfqlDataTypeEnum.STRING)));
                }
            }
            nextSelectClause.setDataType(nextType);
        }
    }

    private void massageSelectColumnNames(HfqlStatement theHfqlStatement) {
        List<HfqlStatement.SelectClause> selectClauses = theHfqlStatement.getSelectClauses();
        for (int i = 0; i < selectClauses.size(); ++i) {
            HfqlStatement.SelectClause selectClause = selectClauses.get(i);
            if (selectClause.getOperator() != HfqlStatement.SelectClauseOperator.SELECT || !"*".equals(selectClause.getClause())) continue;
            this.resolveAndReplaceStarInSelectClauseAtIndex(theHfqlStatement, selectClauses, i);
        }
    }

    private void resolveAndReplaceStarInSelectClauseAtIndex(HfqlStatement theHfqlStatement, List<HfqlStatement.SelectClause> theSelectClauses, int theIndex) {
        String resourceName = theHfqlStatement.getFromResourceName();
        TreeSet<String> allLeafPaths = this.findLeafPaths(resourceName);
        theSelectClauses.remove(theIndex);
        List<String> reversedLeafPaths = new ArrayList<String>(allLeafPaths);
        reversedLeafPaths = Lists.reverse(reversedLeafPaths);
        reversedLeafPaths.forEach(t -> theSelectClauses.add(theIndex, new HfqlStatement.SelectClause((String)t).setAlias((String)t)));
    }

    @Nonnull
    private TreeSet<String> findLeafPaths(String theResourceName) {
        TreeSet<String> allLeafPaths = new TreeSet<String>();
        RuntimeResourceDefinition def = this.myFhirContext.getResourceDefinition(theResourceName);
        for (BaseRuntimeChildDefinition nextChild : def.getChildren()) {
            for (String next : nextChild.getValidChildNames()) {
                if ("extension".equals(next) || "modifierExtension".equals(next)) continue;
                allLeafPaths.add(next);
            }
        }
        return allLeafPaths;
    }

    @Override
    public IHfqlExecutionResult introspectTables() {
        List<String> columns = List.of("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION");
        List<HfqlDataTypeEnum> dataTypes = List.of(HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING);
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        TreeSet resourceTypes = new TreeSet(this.myFhirContext.getResourceTypes());
        for (String next : resourceTypes) {
            rows.add(Lists.newArrayList((Object[])new Object[]{null, null, next, "TABLE", null, null, null, null, null, null}));
        }
        return new StaticHfqlExecutionResult(null, columns, dataTypes, rows);
    }

    @Override
    public IHfqlExecutionResult introspectColumns(@Nullable String theTableName, @Nullable String theColumnName) {
        List<String> columns = List.of("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN");
        List<HfqlDataTypeEnum> dataTypes = List.of(HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.INTEGER, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.INTEGER, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.INTEGER, HfqlDataTypeEnum.INTEGER, HfqlDataTypeEnum.INTEGER, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.INTEGER, HfqlDataTypeEnum.INTEGER, HfqlDataTypeEnum.INTEGER, HfqlDataTypeEnum.INTEGER, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING, HfqlDataTypeEnum.STRING);
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        for (String nextResourceType : new TreeSet(this.myFhirContext.getResourceTypes())) {
            if (!StringUtils.isBlank((CharSequence)theTableName) && !theTableName.equals(nextResourceType)) continue;
            TreeSet<String> leafPaths = this.findLeafPaths(nextResourceType);
            int position = 1;
            for (String nextLeafPath : leafPaths) {
                if (!StringUtils.isBlank((CharSequence)theColumnName) && !theColumnName.equals(nextLeafPath)) continue;
                rows.add(Lists.newArrayList((Object[])new Object[]{null, null, nextResourceType, nextLeafPath, 12, "string", -1, null, null, null, 1, null, null, null, null, null, position++, "YES", null, null, null, null, "NO", "NO"}));
            }
        }
        return new StaticHfqlExecutionResult(null, columns, dataTypes, rows);
    }

    private static boolean isFhirPathExpressionEquivalent(String wantedExpression, String actualExpression, String fromResourceName) {
        if (wantedExpression.equals(actualExpression)) {
            return true;
        }
        if (("Resource." + wantedExpression).equals(actualExpression)) {
            return true;
        }
        return (fromResourceName + "." + wantedExpression).equals(actualExpression);
    }

    private static boolean isDataValueWhereClause(HfqlStatement.WhereClause next) {
        return next.getOperator() == HfqlStatement.WhereClauseOperatorEnum.EQUALS || next.getOperator() == HfqlStatement.WhereClauseOperatorEnum.IN;
    }

    static Comparator<IHfqlExecutionResult.Row> newRowComparator(int columnIndex, HfqlDataTypeEnum dataType) {
        return Comparator.comparing(new RowValueExtractor(columnIndex, dataType));
    }

    private static boolean evaluateWhereClauseUnaryBoolean(HfqlExecutionContext theExecutionContext, IBaseResource r, HfqlStatement.WhereClause theNextWhereClause) {
        boolean haveMatch = false;
        String fullExpression = theNextWhereClause.asUnaryExpression();
        List<IPrimitiveType> values = theExecutionContext.evaluate((IBase)r, fullExpression, IPrimitiveType.class);
        for (IPrimitiveType nextValue : values) {
            if (!Boolean.TRUE.equals(nextValue.getValue())) continue;
            haveMatch = true;
            break;
        }
        return haveMatch;
    }

    private static boolean evaluateWhereClauseBinaryEqualsOrIn(HfqlExecutionContext theExecutionContext, IBaseResource r, HfqlStatement.WhereClause theNextWhereClause) {
        boolean haveMatch = false;
        List<IBase> values = theExecutionContext.evaluate((IBase)r, theNextWhereClause.getLeft(), IBase.class);
        for (IBase nextValue : values) {
            String nextRight;
            String expression;
            IPrimitiveType outcome;
            Boolean value;
            Iterator<String> iterator = theNextWhereClause.getRight().iterator();
            while (iterator.hasNext() && !(haveMatch = (value = (Boolean)(outcome = theExecutionContext.evaluateFirst(nextValue, expression = "$this = " + (nextRight = iterator.next()), IPrimitiveType.class).orElseThrow(IllegalStateException::new)).getValue()).booleanValue())) {
            }
            if (!haveMatch) continue;
            break;
        }
        return haveMatch;
    }

    @Nonnull
    private static InvalidRequestException newInvalidRequestExceptionUnknownSearchParameter(String theParamName) {
        return new InvalidRequestException("Unknown/unsupported search parameter: " + UrlUtil.sanitizeUrlPart((CharSequence)theParamName));
    }

    @Nonnull
    private static InvalidRequestException newInvalidRequestCountWithSelectOnNonGroupedClause(String theClause) {
        return new InvalidRequestException("Unable to select on non-grouped column in a count expression: " + UrlUtil.sanitizeUrlPart((CharSequence)theClause));
    }

    public static class HfqlExecutionContext {
        private final Map<String, IFhirPath.IParsedExpression> myFhirPathExpressionMap = new HashMap<String, IFhirPath.IParsedExpression>();
        private final IFhirPath myFhirPath;

        public HfqlExecutionContext(IFhirPath theFhirPath) {
            this.myFhirPath = theFhirPath;
        }

        public <T extends IBase> List<T> evaluate(IBase theInput, String thePath, Class<T> theReturnType) {
            IFhirPath.IParsedExpression parsedExpression = this.getParsedExpression(thePath);
            return this.myFhirPath.evaluate(theInput, parsedExpression, theReturnType);
        }

        <T extends IBase> Optional<T> evaluateFirst(IBase theInput, String thePath, Class<T> theReturnType) {
            IFhirPath.IParsedExpression parsedExpression = this.getParsedExpression(thePath);
            return this.myFhirPath.evaluateFirst(theInput, parsedExpression, theReturnType);
        }

        private IFhirPath.IParsedExpression getParsedExpression(String thePath) {
            IFhirPath.IParsedExpression parsedExpression = this.myFhirPathExpressionMap.get(thePath);
            if (parsedExpression == null) {
                try {
                    parsedExpression = this.myFhirPath.parse(thePath);
                }
                catch (Exception e) {
                    throw new InvalidRequestException(Msg.code((int)2404) + e.getMessage(), (Throwable)e);
                }
                this.myFhirPathExpressionMap.put(thePath, parsedExpression);
            }
            return parsedExpression;
        }
    }

    private static class GroupByKey {
        private final int myHashCode;
        private List<String> myNames;

        public GroupByKey(List<String> theNames) {
            this.myNames = new ArrayList<String>(theNames);
            HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
            this.myNames.forEach(arg_0 -> ((HashCodeBuilder)hashCodeBuilder).append(arg_0));
            this.myHashCode = hashCodeBuilder.toHashCode();
        }

        public boolean equals(Object theO) {
            boolean retVal = false;
            if (theO instanceof GroupByKey) {
                List<String> otherNames = ((GroupByKey)theO).myNames;
                retVal = ListUtils.isEqualList(this.myNames, otherNames);
            }
            return retVal;
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public List<String> getNames() {
            return this.myNames;
        }
    }

    private static class RowValueExtractor
    implements Function<IHfqlExecutionResult.Row, Comparable> {
        private final int myColumnIndex;
        private final HfqlDataTypeEnum myDataType;

        public RowValueExtractor(int theColumnIndex, HfqlDataTypeEnum theDataType) {
            this.myColumnIndex = theColumnIndex;
            this.myDataType = theDataType;
        }

        @Override
        public Comparable apply(IHfqlExecutionResult.Row theRow) {
            Comparable retVal = (Comparable)theRow.getRowValues().get(this.myColumnIndex);
            switch (this.myDataType) {
                case STRING: 
                case TIME: 
                case JSON: {
                    retVal = (Comparable)ObjectUtils.defaultIfNull((Object)retVal, (Object)"");
                    break;
                }
                case LONGINT: 
                case INTEGER: {
                    if (retVal instanceof Number) {
                        return retVal;
                    }
                    if (retVal == null) {
                        retVal = Long.valueOf(Long.MIN_VALUE);
                        break;
                    }
                    retVal = Long.valueOf(Long.parseLong((String)((Object)retVal)));
                    break;
                }
                case BOOLEAN: {
                    if (retVal == null) {
                        retVal = Boolean.FALSE;
                        break;
                    }
                    retVal = Boolean.valueOf(Boolean.parseBoolean((String)((Object)retVal)));
                    break;
                }
                case DATE: 
                case TIMESTAMP: {
                    if (retVal != null) {
                        retVal = (Comparable)new DateTimeType((String)((Object)retVal)).getValue();
                    }
                    if (retVal != null) break;
                    retVal = new Date(Long.MIN_VALUE);
                    break;
                }
                case DECIMAL: {
                    retVal = retVal == null ? BigDecimal.valueOf(Long.MIN_VALUE) : new BigDecimal((String)((Object)retVal));
                }
            }
            return retVal;
        }
    }
}

