/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.fql.executor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.fql.executor.HfqlDataTypeEnum;
import ca.uhn.fhir.jpa.fql.executor.HfqlExecutor;
import ca.uhn.fhir.jpa.fql.executor.IHfqlExecutionResult;
import ca.uhn.fhir.jpa.fql.parser.HfqlStatement;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSearchHfqlExecutionResult
implements IHfqlExecutionResult {
    private static final Logger ourLog = LoggerFactory.getLogger(LocalSearchHfqlExecutionResult.class);
    private final IBundleProvider mySearchResult;
    private final HfqlExecutor.HfqlExecutionContext myExecutionContext;
    private final Integer myLimit;
    private final HfqlStatement myStatement;
    private final Predicate<IBaseResource> myWhereClausePredicate;
    private final IParser myParser;
    private int myTotalRowsFetched = 0;
    private int myNextSearchResultRow;
    private int myNextBatchRow = 0;
    private List<IBaseResource> myNextBatch;
    private IBaseResource myNextResource;
    private boolean myExhausted = false;
    private int myNextResourceSearchRow;
    private IHfqlExecutionResult.Row myErrorRow;

    public LocalSearchHfqlExecutionResult(HfqlStatement theStatement, IBundleProvider theSearchResult, HfqlExecutor.HfqlExecutionContext theExecutionContext, Integer theLimit, int theInitialOffset, Predicate<IBaseResource> theWhereClausePredicate, FhirContext theFhirContext) {
        this.myStatement = theStatement;
        this.mySearchResult = theSearchResult;
        this.myExecutionContext = theExecutionContext;
        this.myLimit = theLimit;
        this.myNextSearchResultRow = theInitialOffset;
        this.myWhereClausePredicate = theWhereClausePredicate;
        this.myParser = theFhirContext.newJsonParser();
    }

    @Override
    public boolean hasNext() {
        this.fetchNextResource();
        return this.myNextResource != null;
    }

    private void fetchNextResource() {
        if (this.myNextResource != null) {
            return;
        }
        try {
            while (this.myNextResource == null && !this.myExhausted) {
                if (this.myNextBatch == null) {
                    int from = this.myNextSearchResultRow;
                    int to = this.myNextSearchResultRow + 1000;
                    this.myNextBatch = this.mySearchResult.getResources(from, to);
                    ourLog.info("HFQL fetching resources {}-{} - Total {} fetched, {} retained and limit {}", new Object[]{from, to, this.myNextSearchResultRow, this.myTotalRowsFetched, this.myLimit});
                    this.myNextBatchRow = 0;
                    this.myNextSearchResultRow += 1000;
                }
                if (this.myNextBatch.isEmpty()) {
                    this.myExhausted = true;
                } else if (this.myNextBatch.size() > this.myNextBatchRow) {
                    this.myNextResource = this.myNextBatch.get(this.myNextBatchRow);
                    this.myNextResourceSearchRow = this.myNextSearchResultRow - 1000 + this.myNextBatchRow;
                    ++this.myNextBatchRow;
                } else {
                    this.myNextBatch = null;
                }
                if (this.myNextResource == null || this.myWhereClausePredicate.test(this.myNextResource)) continue;
                this.myNextResource = null;
            }
            if (this.myNextResource != null) {
                ++this.myTotalRowsFetched;
                if (this.myLimit != null && this.myTotalRowsFetched >= this.myLimit) {
                    this.myExhausted = true;
                }
            }
        }
        catch (Exception e) {
            this.createAndStoreErrorRow(e.getMessage());
        }
    }

    @Override
    public IHfqlExecutionResult.Row getNextRow() {
        this.fetchNextResource();
        if (this.myErrorRow != null) {
            IHfqlExecutionResult.Row errorRow = this.myErrorRow;
            this.myErrorRow = null;
            return errorRow;
        }
        Validate.isTrue((this.myNextResource != null ? 1 : 0) != 0, (String)"No more results", (Object[])new Object[0]);
        ArrayList<Object> values = new ArrayList<Object>();
        for (int columnIndex = 0; columnIndex < this.myStatement.getSelectClauses().size(); ++columnIndex) {
            List<IBase> columnValues;
            HfqlStatement.SelectClause nextColumn = this.myStatement.getSelectClauses().get(columnIndex);
            String clause = nextColumn.getClause();
            HfqlDataTypeEnum columnDataType = nextColumn.getDataType();
            try {
                columnValues = this.myExecutionContext.evaluate((IBase)this.myNextResource, clause, IBase.class);
            }
            catch (Exception e) {
                String errorMessage = "Failed to evaluate FHIRPath expression \"" + clause + "\". Error: " + e.getMessage();
                return this.createAndStoreErrorRow(errorMessage);
            }
            String value = null;
            if (columnDataType == HfqlDataTypeEnum.JSON) {
                StringBuilder b = new StringBuilder();
                b.append("[");
                Iterator<IBase> valueIter = columnValues.iterator();
                while (valueIter.hasNext()) {
                    IBase next = valueIter.next();
                    if (next instanceof IPrimitiveType) {
                        b.append('\"');
                        String encodedValue = this.encodeValue(next);
                        encodedValue = encodedValue.replace("\\", "\\\\").replace("\"", "\\\"");
                        b.append(encodedValue);
                        b.append('\"');
                    } else {
                        b.append(this.encodeValue(next));
                    }
                    if (!valueIter.hasNext()) continue;
                    b.append(", ");
                }
                b.append("]");
                value = b.toString();
            } else if (!columnValues.isEmpty()) {
                IBase firstColumnValue = columnValues.get(0);
                value = this.encodeValue(firstColumnValue);
            }
            values.add(value);
        }
        this.myNextResource = null;
        return new IHfqlExecutionResult.Row(this.myNextResourceSearchRow, values);
    }

    private String encodeValue(IBase firstColumnValue) {
        String value = null;
        if (firstColumnValue instanceof IIdType) {
            value = ((IIdType)firstColumnValue).getIdPart();
        } else if (firstColumnValue != null) {
            value = this.myParser.encodeToString(firstColumnValue);
        }
        return value;
    }

    private IHfqlExecutionResult.Row createAndStoreErrorRow(String errorMessage) {
        this.myExhausted = true;
        this.myNextResource = null;
        this.myErrorRow = new IHfqlExecutionResult.Row(-1, List.of(errorMessage));
        return this.myErrorRow;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public String getSearchId() {
        return this.mySearchResult.getUuid();
    }

    @Override
    public int getLimit() {
        return this.myLimit != null ? this.myLimit : -1;
    }

    @Override
    public HfqlStatement getStatement() {
        return this.myStatement;
    }
}

