/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.fql.executor;

import ca.uhn.fhir.jpa.fql.executor.HfqlDataTypeEnum;
import ca.uhn.fhir.jpa.fql.executor.IHfqlExecutionResult;
import ca.uhn.fhir.jpa.fql.parser.HfqlStatement;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class StaticHfqlExecutionResult
implements IHfqlExecutionResult {
    private final String mySearchId;
    private final Iterator<List<Object>> myRowsIterator;
    private int myNextRowOffset;
    private HfqlStatement myStatement;

    public StaticHfqlExecutionResult(@Nullable String theSearchId) {
        this(theSearchId, new HfqlStatement(), Collections.emptyList());
    }

    public StaticHfqlExecutionResult(@Nullable String theSearchId, List<String> theColumnNames, List<HfqlDataTypeEnum> theDataTypes, List<List<Object>> theRows) {
        this(theSearchId, StaticHfqlExecutionResult.toStatement(theColumnNames, theDataTypes), theRows);
    }

    private static HfqlStatement toStatement(List<String> theColumnNames, List<HfqlDataTypeEnum> theDataTypes) {
        assert (theColumnNames.size() == theDataTypes.size());
        HfqlStatement retVal = new HfqlStatement();
        for (int i = 0; i < theColumnNames.size(); ++i) {
            retVal.addSelectClause(theColumnNames.get(i)).setAlias(theColumnNames.get(i)).setDataType(theDataTypes.get(i));
        }
        return retVal;
    }

    public StaticHfqlExecutionResult(@Nullable String theSearchId, HfqlStatement theStatement, List<List<Object>> theRows) {
        this.mySearchId = theSearchId;
        this.myStatement = theStatement;
        this.myRowsIterator = theRows.iterator();
        this.myNextRowOffset = 0;
    }

    @Override
    public boolean hasNext() {
        return this.myRowsIterator.hasNext();
    }

    @Override
    public IHfqlExecutionResult.Row getNextRow() {
        return new IHfqlExecutionResult.Row(this.myNextRowOffset++, this.myRowsIterator.next());
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public String getSearchId() {
        return this.mySearchId;
    }

    @Override
    public int getLimit() {
        return 0;
    }

    @Override
    public HfqlStatement getStatement() {
        return this.myStatement;
    }

    public static IHfqlExecutionResult withError(String theErrorMessage) {
        StaticHfqlExecutionResult retVal = new StaticHfqlExecutionResult(null, List.of("Error"), List.of(HfqlDataTypeEnum.STRING), List.of(List.of(theErrorMessage)));
        retVal.myNextRowOffset = -1;
        return retVal;
    }
}

