/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.fql.jdbc;

import ca.uhn.fhir.jpa.fql.executor.IHfqlExecutionResult;
import ca.uhn.fhir.jpa.fql.jdbc.RemoteHfqlExecutionResult;
import ca.uhn.fhir.rest.client.impl.HttpBasicAuthInterceptor;
import ca.uhn.fhir.util.IoUtil;
import jakarta.annotation.Nonnull;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

public class HfqlRestClient {
    public static final CSVFormat CSV_FORMAT = CSVFormat.DEFAULT.withRecordSeparator('\n');
    private final String myBaseUrl;
    private final CloseableHttpClient myClient;

    public HfqlRestClient(String theBaseUrl, String theUsername, String thePassword) {
        this.myBaseUrl = theBaseUrl;
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(5000L, TimeUnit.MILLISECONDS);
        connectionManager.setMaxTotal(99);
        connectionManager.setDefaultMaxPerRoute(99);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setMaxConnPerRoute(99);
        if (StringUtils.isNotBlank((CharSequence)theUsername) && StringUtils.isNotBlank((CharSequence)thePassword)) {
            httpClientBuilder.addInterceptorLast((HttpRequestInterceptor)new HttpBasicAuthInterceptor(theUsername, thePassword));
        }
        this.myClient = httpClientBuilder.build();
    }

    @Nonnull
    public static Parameters newQueryRequestParameters(String sql, Integer limit, int fetchSize) {
        Parameters input = new Parameters();
        input.addParameter("action", (Type)new CodeType("search"));
        input.addParameter("query", (Type)new StringType(sql));
        if (limit != null) {
            input.addParameter("limit", (Type)new IntegerType(limit.intValue()));
        }
        input.addParameter("fetchSize", (Type)new IntegerType(fetchSize));
        return input;
    }

    public IHfqlExecutionResult execute(Parameters theRequestParameters, boolean theSupportsContinuations, Integer theFetchSize) throws SQLException {
        Integer fetchSize = theFetchSize;
        Validate.isTrue(((fetchSize = (Integer)ObjectUtils.defaultIfNull((Object)fetchSize, (Object)1000)) > 0 ? 1 : 0) != 0, (String)"theFetchSize must be a positive integer, got: %s", (long)fetchSize.intValue());
        return new RemoteHfqlExecutionResult(theRequestParameters, this.myBaseUrl, this.myClient, fetchSize, theSupportsContinuations);
    }

    public void close() {
        IoUtil.closeQuietly((AutoCloseable)this.myClient);
    }
}

