/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.fql.jdbc;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.fql.jdbc.HfqlRestClient;
import ca.uhn.fhir.jpa.fql.jdbc.JdbcDatabaseMetadata;
import ca.uhn.fhir.jpa.fql.jdbc.JdbcStatement;
import jakarta.annotation.Nonnull;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

class JdbcConnection
implements Connection {
    private final String myServerUrl;
    private boolean myClosed;
    private HfqlRestClient myClient;
    private String myUsername;
    private String myPassword;

    public JdbcConnection(String theServerUrl) {
        this.myServerUrl = theServerUrl;
    }

    @Override
    public Statement createStatement() {
        return new JdbcStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean getAutoCommit() {
        return false;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }

    @Override
    public void close() {
        this.myClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.myClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() {
        return new JdbcDatabaseMetadata(this, this.getClient());
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getCatalog() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getTransactionIsolation() {
        return 2;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean isValid(int timeout) {
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public void setClientInfo(Properties properties) {
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getSchema() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public <T> T unwrap(Class<T> theInterface) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean isWrapperFor(Class<?> theInterface) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    public HfqlRestClient getClient() {
        if (this.myClient == null) {
            this.myClient = new HfqlRestClient(this.myServerUrl, this.myUsername, this.myPassword);
        }
        return this.myClient;
    }

    public void setUsername(String theUsername) {
        this.myUsername = theUsername;
    }

    public void setPassword(String thePassword) {
        this.myPassword = thePassword;
    }

    @Nonnull
    static SQLException newSqlExceptionForUnsupportedOperation() {
        return new SQLException(Msg.code((int)2394) + "This JDBC method is not yet supported by the HFQL JDBC Driver");
    }

    @Nonnull
    static SQLFeatureNotSupportedException newSqlExceptionForFeatureNotSupported() {
        return new SQLFeatureNotSupportedException(Msg.code((int)2398) + "This JDBC method is not yet supported by the HFQL JDBC Driver");
    }
}

