/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.fql.jdbc;

import ca.uhn.fhir.jpa.fql.executor.IHfqlExecutionResult;
import ca.uhn.fhir.jpa.fql.jdbc.HfqlRestClient;
import ca.uhn.fhir.jpa.fql.jdbc.JdbcConnection;
import ca.uhn.fhir.jpa.fql.jdbc.JdbcResultSet;
import ca.uhn.fhir.util.VersionUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Type;

public class JdbcDatabaseMetadata
implements DatabaseMetaData {
    private final Connection myConnection;
    private final HfqlRestClient myRestClient;

    public JdbcDatabaseMetadata(Connection theConnection, HfqlRestClient theRestClient) {
        this.myConnection = theConnection;
        this.myRestClient = theRestClient;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getURL() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getUserName() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "HAPI FHIR";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return VersionUtil.getVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return "HAPI FHIR FQL JDBC";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return VersionUtil.getVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 1;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getStringFunctions() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxConnections() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxStatements() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        Parameters input = new Parameters();
        input.addParameter("action", (Type)new CodeType("introspectTables"));
        IHfqlExecutionResult outcome = this.myRestClient.execute(input, false, null);
        return new JdbcResultSet(outcome);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return new JdbcResultSet();
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return new JdbcResultSet();
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException, SQLException {
        Parameters input = new Parameters();
        input.addParameter("action", (Type)new CodeType("introspectColumns"));
        IHfqlExecutionResult outcome = this.myRestClient.execute(input, false, null);
        return new JdbcResultSet(outcome);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return new JdbcResultSet();
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return new JdbcResultSet();
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.myConnection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return Integer.parseInt(VersionUtil.getVersion().split("\\.")[0]);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return Integer.parseInt(VersionUtil.getVersion().split("\\.")[1]);
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return Integer.parseInt(VersionUtil.getVersion().split("\\.")[0]);
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return Integer.parseInt(VersionUtil.getVersion().split("\\.")[1]);
    }

    @Override
    public int getSQLStateType() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public <T> T unwrap(Class<T> theInterface) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean isWrapperFor(Class<?> theInterface) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }
}

