/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.fql.jdbc;

import ca.uhn.fhir.jpa.fql.jdbc.JdbcConnection;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;

public class JdbcDriver
implements Driver {
    private static final JdbcDriver INSTANCE = new JdbcDriver();
    public static final String URL_PREFIX = "jdbc:hapifhirql:";
    private static boolean ourRegistered;

    @Override
    public Connection connect(String theUrl, Properties theProperties) throws SQLException {
        String serverUrl = theUrl.substring(URL_PREFIX.length());
        JdbcConnection connection = new JdbcConnection(serverUrl);
        connection.setUsername(theProperties.getProperty("user", null));
        connection.setPassword(theProperties.getProperty("password", null));
        return connection;
    }

    @Override
    public boolean acceptsURL(String theUrl) {
        return theUrl.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String theUrl, Properties theInfo) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger(this.getClass().getPackageName());
    }

    public static synchronized Driver load() {
        try {
            if (!ourRegistered) {
                ourRegistered = true;
                DriverManager.registerDriver(INSTANCE);
            }
        }
        catch (SQLException e) {
            JdbcDriver.logException(e);
        }
        return INSTANCE;
    }

    private static void logException(SQLException e) {
        PrintStream out = System.out;
        e.printStackTrace(out);
    }

    public static synchronized void unload() {
        try {
            if (ourRegistered) {
                ourRegistered = false;
                DriverManager.deregisterDriver(INSTANCE);
            }
        }
        catch (SQLException e) {
            JdbcDriver.logException(e);
        }
    }

    static {
        JdbcDriver.load();
    }
}

