/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.fql.jdbc;

import ca.uhn.fhir.jpa.fql.executor.IHfqlExecutionResult;
import ca.uhn.fhir.jpa.fql.jdbc.HfqlRestClient;
import ca.uhn.fhir.jpa.fql.jdbc.JdbcConnection;
import ca.uhn.fhir.jpa.fql.jdbc.JdbcResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hl7.fhir.r4.model.Parameters;

class JdbcStatement
implements Statement {
    private final JdbcConnection myConnection;
    private int myMaxRows;
    private int myFetchSize = 1000;
    private JdbcResultSet myResultSet;

    public JdbcStatement(JdbcConnection theConnection) {
        this.myConnection = theConnection;
    }

    @Override
    public ResultSet executeQuery(String theSqlText) throws SQLException {
        this.execute(theSqlText);
        return this.getResultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public void close() {
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) {
    }

    @Override
    public int getMaxRows() {
        return this.myMaxRows;
    }

    @Override
    public void setMaxRows(int theMaxRows) {
        this.myMaxRows = theMaxRows;
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    @Override
    public int getQueryTimeout() {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void setCursorName(String name) {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        Integer limit = null;
        if (this.getMaxRows() > 0) {
            limit = this.getMaxRows();
        }
        int fetchSize = this.myFetchSize;
        Parameters input = HfqlRestClient.newQueryRequestParameters(sql, limit, fetchSize);
        IHfqlExecutionResult result = this.myConnection.getClient().execute(input, true, this.getFetchSize());
        this.myResultSet = new JdbcResultSet(result, this);
        return true;
    }

    @Override
    public ResultSet getResultSet() {
        return this.myResultSet;
    }

    @Override
    public int getUpdateCount() {
        return 0;
    }

    @Override
    public boolean getMoreResults() {
        return false;
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public int getFetchSize() {
        return this.myFetchSize;
    }

    @Override
    public void setFetchSize(int theFetchSize) {
        this.myFetchSize = theFetchSize;
    }

    @Override
    public int getResultSetConcurrency() {
        return 1007;
    }

    @Override
    public int getResultSetType() {
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int[] executeBatch() {
        return new int[0];
    }

    @Override
    public Connection getConnection() {
        return this.myConnection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw JdbcConnection.newSqlExceptionForUnsupportedOperation();
    }

    @Override
    public int getResultSetHoldability() {
        return 2;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public boolean isPoolable() {
        return false;
    }

    @Override
    public void setPoolable(boolean thePoolable) {
    }

    @Override
    public void closeOnCompletion() {
    }

    @Override
    public boolean isCloseOnCompletion() {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> theInterface) {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> theInterface) {
        return false;
    }
}

