/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.fql.jdbc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.fql.executor.IHfqlExecutionResult;
import ca.uhn.fhir.jpa.fql.jdbc.HfqlRestClient;
import ca.uhn.fhir.jpa.fql.parser.HfqlStatement;
import ca.uhn.fhir.rest.client.apache.ResourceEntity;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.IoUtil;
import ca.uhn.fhir.util.JsonUtil;
import ca.uhn.fhir.util.ValidateUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

public class RemoteHfqlExecutionResult
implements IHfqlExecutionResult {
    private final boolean mySupportsContinuations;
    private final String myBaseUrl;
    private final CloseableHttpClient myClient;
    private final int myFetchSize;
    private String mySearchId;
    private int myLimit;
    private InputStreamReader myReader;
    private Iterator<CSVRecord> myIterator;
    private int myCurrentFetchCount;
    private CloseableHttpResponse myRequest;
    private int myLastRowNumber;
    private boolean myExhausted;
    private HfqlStatement myStatement;

    public RemoteHfqlExecutionResult(Parameters theRequestParameters, String theBaseUrl, CloseableHttpClient theClient, int theFetchSize, boolean theSupportsContinuations) throws SQLException {
        this.myBaseUrl = theBaseUrl;
        this.myClient = theClient;
        this.myFetchSize = theFetchSize;
        this.mySupportsContinuations = theSupportsContinuations;
        HttpPost post = new HttpPost(this.myBaseUrl + "/$hfql-execute");
        post.setEntity((HttpEntity)new ResourceEntity(FhirContext.forR4Cached(), (IBaseResource)theRequestParameters));
        try {
            this.myRequest = this.myClient.execute((HttpUriRequest)post);
            this.validateResponse();
            this.myReader = new InputStreamReader(this.myRequest.getEntity().getContent(), StandardCharsets.UTF_8);
            CSVParser csvParser = new CSVParser((Reader)this.myReader, HfqlRestClient.CSV_FORMAT);
            this.myIterator = csvParser.iterator();
            this.readHeaderRows(true);
        }
        catch (IOException e) {
            throw new SQLException(Msg.code((int)2400) + e.getMessage(), e);
        }
    }

    public RemoteHfqlExecutionResult(Parameters theRequestParameters, IGenericClient theClient) throws IOException {
        this.myBaseUrl = null;
        this.myClient = null;
        this.myFetchSize = 100;
        this.mySupportsContinuations = false;
        Binary response = (Binary)((IOperationUnnamed)theClient.operation().onServer()).named("$hfql-execute").withParameters((IBaseParameters)theRequestParameters).returnResourceType(Binary.class).execute();
        String contentType = (String)StringUtils.defaultIfBlank((CharSequence)response.getContentType(), (CharSequence)"");
        if (contentType.contains(";")) {
            contentType = contentType.substring(0, contentType.indexOf(59));
        }
        contentType = contentType.trim();
        Validate.isTrue((boolean)"text/csv".equals(contentType), (String)"Unexpected content-type: %s", (Object[])new Object[]{contentType});
        this.myReader = new InputStreamReader((InputStream)new ByteArrayInputStream(response.getContent()), StandardCharsets.UTF_8);
        CSVParser csvParser = new CSVParser((Reader)this.myReader, HfqlRestClient.CSV_FORMAT);
        this.myIterator = csvParser.iterator();
        this.readHeaderRows(true);
    }

    private void validateResponse() {
        Validate.isTrue((this.myRequest.getStatusLine().getStatusCode() == 200 ? 1 : 0) != 0, (String)"Server returned wrong status: %d", (long)this.myRequest.getStatusLine().getStatusCode());
    }

    private void readHeaderRows(boolean theFirstPage) {
        CSVRecord protocolVersionRow = this.myIterator.next();
        String protocolVersion = protocolVersionRow.get(0);
        ValidateUtil.isTrueOrThrowInvalidRequest((boolean)"1".equals(protocolVersion), (String)"Wrong protocol version, expected %s but got %s", (Object[])new Object[]{"1", protocolVersion});
        CSVRecord searchIdRow = this.myIterator.next();
        this.mySearchId = searchIdRow.get(0);
        this.myLimit = Integer.parseInt(searchIdRow.get(1));
        String statementJsonString = searchIdRow.get(2);
        if (theFirstPage && StringUtils.isNotBlank((CharSequence)statementJsonString)) {
            this.myStatement = (HfqlStatement)JsonUtil.deserialize((String)statementJsonString, HfqlStatement.class);
        }
        this.myCurrentFetchCount = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.myExhausted) {
            return false;
        }
        boolean hasNext = this.myIterator.hasNext();
        if (!hasNext && this.myCurrentFetchCount < this.myFetchSize) {
            this.myExhausted = true;
            this.close();
        } else if (!hasNext) {
            this.close();
            if (this.mySupportsContinuations) {
                hasNext = this.executeContinuationSearch();
            }
        }
        return hasNext;
    }

    @Override
    public IHfqlExecutionResult.Row getNextRow() {
        Validate.isTrue((!this.myExhausted ? 1 : 0) != 0, (String)"Search is exhausted. This is a bug.", (Object[])new Object[0]);
        ArrayList<Object> columnValues = new ArrayList<Object>();
        boolean first = true;
        CSVRecord nextRecord = this.myIterator.next();
        ++this.myCurrentFetchCount;
        for (String next : nextRecord) {
            if (first) {
                first = false;
                this.myLastRowNumber = Integer.parseInt(next);
                continue;
            }
            columnValues.add(next);
        }
        for (int i = 0; i < columnValues.size(); ++i) {
            String existingValue = (String)columnValues.get(i);
            if (StringUtils.isNotBlank((CharSequence)existingValue)) {
                Object newValue = null;
                switch (this.myStatement.getSelectClauses().get(i).getDataType()) {
                    case STRING: 
                    case JSON: {
                        break;
                    }
                    case TIME: {
                        break;
                    }
                    case INTEGER: {
                        newValue = Integer.parseInt(existingValue);
                        break;
                    }
                    case BOOLEAN: {
                        newValue = Boolean.parseBoolean(existingValue);
                        break;
                    }
                    case DATE: {
                        DateType dateType = new DateType();
                        dateType.setValueAsString(existingValue);
                        newValue = dateType.getValue();
                        break;
                    }
                    case TIMESTAMP: {
                        DateTimeType dateTimeType = new DateTimeType();
                        dateTimeType.setValueAsString(existingValue);
                        newValue = dateTimeType.getValue();
                        break;
                    }
                    case LONGINT: {
                        newValue = Long.parseLong(existingValue);
                        break;
                    }
                    case DECIMAL: {
                        newValue = new DecimalType(existingValue).getValue();
                    }
                }
                if (newValue == null) continue;
                columnValues.set(i, newValue);
                continue;
            }
            columnValues.set(i, null);
        }
        return new IHfqlExecutionResult.Row(this.myLastRowNumber, columnValues);
    }

    private boolean executeContinuationSearch() {
        HttpPost post = new HttpPost(this.myBaseUrl + "/$hfql-execute");
        Parameters input = new Parameters();
        input.addParameter("action", (Type)new CodeType("searchContinuation"));
        input.addParameter("continuation", (Type)new StringType(this.mySearchId));
        input.addParameter("offset", (Type)new IntegerType(this.myLastRowNumber + 1));
        input.addParameter("limit", (Type)new IntegerType(this.myLimit));
        input.addParameter("fetchSize", (Type)new IntegerType(this.myFetchSize));
        input.addParameter("statement", (Type)new StringType(JsonUtil.serialize((Object)this.myStatement, (boolean)false)));
        post.setEntity((HttpEntity)new ResourceEntity(FhirContext.forR4Cached(), (IBaseResource)input));
        try {
            this.myRequest = this.myClient.execute((HttpUriRequest)post);
            this.validateResponse();
            this.myReader = new InputStreamReader(this.myRequest.getEntity().getContent(), StandardCharsets.UTF_8);
            CSVParser csvParser = new CSVParser((Reader)this.myReader, HfqlRestClient.CSV_FORMAT);
            this.myIterator = csvParser.iterator();
            this.readHeaderRows(false);
        }
        catch (IOException e) {
            throw new InternalErrorException(Msg.code((int)2399) + e.getMessage(), (Throwable)e);
        }
        boolean hasNext = this.myIterator.hasNext();
        return hasNext;
    }

    @Override
    public boolean isClosed() {
        return this.myRequest == null;
    }

    @Override
    public void close() {
        IoUtil.closeQuietly((AutoCloseable)this.myReader);
        IoUtil.closeQuietly((AutoCloseable)this.myRequest);
        this.myRequest = null;
    }

    @Override
    public String getSearchId() {
        return this.mySearchId;
    }

    @Override
    public int getLimit() {
        return this.myLimit;
    }

    @Override
    public HfqlStatement getStatement() {
        return this.myStatement;
    }
}

