/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.fql.parser;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.jpa.fql.executor.HfqlDataTypeEnum;
import ca.uhn.fhir.jpa.fql.parser.HfqlLexer;
import ca.uhn.fhir.jpa.fql.parser.HfqlLexerOptions;
import ca.uhn.fhir.jpa.fql.parser.HfqlLexerToken;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.apache.commons.text.WordUtils;

public class HfqlFhirPathParser {
    private static final Map<String, HfqlDataTypeEnum> FHIR_DATATYPE_TO_FQL_DATATYPE = Map.ofEntries(Map.entry("base64Binary", HfqlDataTypeEnum.STRING), Map.entry("boolean", HfqlDataTypeEnum.BOOLEAN), Map.entry("canonical", HfqlDataTypeEnum.STRING), Map.entry("code", HfqlDataTypeEnum.STRING), Map.entry("date", HfqlDataTypeEnum.DATE), Map.entry("dateTime", HfqlDataTypeEnum.TIMESTAMP), Map.entry("decimal", HfqlDataTypeEnum.DECIMAL), Map.entry("id", HfqlDataTypeEnum.STRING), Map.entry("instant", HfqlDataTypeEnum.TIMESTAMP), Map.entry("integer", HfqlDataTypeEnum.INTEGER), Map.entry("integer64", HfqlDataTypeEnum.LONGINT), Map.entry("markdown", HfqlDataTypeEnum.STRING), Map.entry("oid", HfqlDataTypeEnum.STRING), Map.entry("positiveInt", HfqlDataTypeEnum.INTEGER), Map.entry("string", HfqlDataTypeEnum.STRING), Map.entry("time", HfqlDataTypeEnum.TIME), Map.entry("unsignedInt", HfqlDataTypeEnum.INTEGER), Map.entry("uri", HfqlDataTypeEnum.STRING), Map.entry("url", HfqlDataTypeEnum.STRING), Map.entry("uuid", HfqlDataTypeEnum.STRING), Map.entry("xhtml", HfqlDataTypeEnum.STRING));
    private final FhirContext myFhirContext;

    public HfqlFhirPathParser(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    public HfqlDataTypeEnum determineDatatypeForPath(String theResourceType, String theFhirPath) {
        RuntimeResourceDefinition currentElementDefinition = this.myFhirContext.getResourceDefinition(theResourceType);
        RuntimePrimitiveDatatypeDefinition leafDefinition = null;
        HfqlLexer lexer = new HfqlLexer(theFhirPath);
        boolean firstToken = true;
        boolean potentiallyRepeatableAtCurrentPath = false;
        while (lexer.hasNextToken(HfqlLexerOptions.FHIRPATH_EXPRESSION_PART)) {
            BaseRuntimeElementDefinition elementDefForNode;
            BaseRuntimeChildDefinition childDefForNode;
            HfqlLexerToken nextToken = lexer.getNextToken(HfqlLexerOptions.FHIRPATH_EXPRESSION_PART);
            Object nextTokenString = nextToken.getToken();
            if (firstToken) {
                firstToken = false;
                if (((String)nextTokenString).equals(theResourceType)) continue;
            }
            if (".".equals(nextTokenString)) continue;
            if (((String)nextTokenString).contains("(")) {
                String keyword;
                switch (keyword = nextToken.asKeyword()) {
                    case "FIRST()": 
                    case "LAST()": {
                        potentiallyRepeatableAtCurrentPath = false;
                        break;
                    }
                    case "TOINTEGER()": {
                        if (lexer.hasNextToken(HfqlLexerOptions.FHIRPATH_EXPRESSION_PART)) break;
                        return HfqlDataTypeEnum.INTEGER;
                    }
                }
                continue;
            }
            boolean hasArrayIndex = false;
            int leftSquareBracketIndex = ((String)nextTokenString).indexOf(91);
            if (leftSquareBracketIndex != -1 && ((String)nextTokenString).endsWith("]")) {
                nextTokenString = ((String)nextTokenString).substring(0, leftSquareBracketIndex);
                hasArrayIndex = true;
            }
            if ((childDefForNode = currentElementDefinition.getChildByName((String)nextTokenString)) == null && (childDefForNode = currentElementDefinition.getChildByName((String)nextTokenString + "[x]")) != null) {
                String token;
                if (lexer.peekNextToken(HfqlLexerOptions.FHIRPATH_EXPRESSION_PART).getToken().equals(".")) {
                    lexer.consumeNextToken();
                }
                if (lexer.hasNextToken(HfqlLexerOptions.FHIRPATH_EXPRESSION_PART) && (token = lexer.getNextToken(HfqlLexerOptions.FHIRPATH_EXPRESSION_PART).getToken()).startsWith("ofType(") && token.endsWith(")")) {
                    String type = token.substring(7, token.length() - 1);
                    nextTokenString = (String)nextTokenString + WordUtils.capitalize((String)type);
                }
            }
            if (childDefForNode == null) break;
            if (childDefForNode.getMax() != 1 && !hasArrayIndex) {
                potentiallyRepeatableAtCurrentPath = true;
            }
            if (!childDefForNode.getValidChildNames().contains(nextTokenString) || (elementDefForNode = childDefForNode.getChildByName((String)nextTokenString)) == null) break;
            if (elementDefForNode instanceof BaseRuntimeElementCompositeDefinition) {
                currentElementDefinition = (BaseRuntimeElementCompositeDefinition)elementDefForNode;
                continue;
            }
            if (!(elementDefForNode instanceof RuntimePrimitiveDatatypeDefinition)) break;
            leafDefinition = (RuntimePrimitiveDatatypeDefinition)elementDefForNode;
        }
        if (potentiallyRepeatableAtCurrentPath) {
            return HfqlDataTypeEnum.JSON;
        }
        if (leafDefinition != null) {
            String typeName = leafDefinition.getName();
            return HfqlFhirPathParser.getHfqlDataTypeForFhirType(typeName);
        }
        return null;
    }

    static HfqlDataTypeEnum getHfqlDataTypeForFhirType(String theTypeName) {
        return FHIR_DATATYPE_TO_FQL_DATATYPE.get(theTypeName);
    }

    @Nullable
    private static String getNextFhirPathPartTokenOrNull(HfqlLexer lexer) {
        String finalToken = null;
        if (lexer.hasNextToken(HfqlLexerOptions.FHIRPATH_EXPRESSION_PART)) {
            finalToken = lexer.getNextToken(HfqlLexerOptions.FHIRPATH_EXPRESSION_PART).getToken();
        }
        if (".".equals(finalToken) && lexer.hasNextToken(HfqlLexerOptions.FHIRPATH_EXPRESSION_PART)) {
            finalToken = lexer.getNextToken(HfqlLexerOptions.FHIRPATH_EXPRESSION_PART).getToken();
        }
        return finalToken;
    }
}

