/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.fql.parser;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.fql.parser.HfqlLexerOptions;
import ca.uhn.fhir.jpa.fql.parser.HfqlLexerToken;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

class HfqlLexer {
    private final char[] myInput;
    private final StringBuilder myBuffer = new StringBuilder();
    private int myPosition = 0;
    private int myLine = 0;
    private int myColumn = 0;
    private int myParenDepth = 0;
    private LexerState myState = LexerState.INITIAL;
    private String myNextToken;
    private int myNextTokenLine;
    private int myNextTokenColumn;
    private int myNextTokenStartPosition;
    private HfqlLexerOptions myNextTokenOptions;

    public HfqlLexer(String theInput) {
        this.myInput = theInput.toCharArray();
    }

    @Nonnull
    public HfqlLexerToken getNextToken() {
        return this.getNextToken(HfqlLexerOptions.HFQL_TOKEN);
    }

    @Nonnull
    public HfqlLexerToken getNextToken(@Nonnull HfqlLexerOptions theOptions) {
        this.lexNextToken(theOptions);
        Validate.notBlank((CharSequence)this.myNextToken, (String)"No next token is available", (Object[])new Object[0]);
        HfqlLexerToken token = new HfqlLexerToken(this.myNextToken, this.myNextTokenLine, this.myNextTokenColumn);
        this.myNextToken = null;
        return token;
    }

    private void lexNextToken(@Nonnull HfqlLexerOptions theOptions) {
        if (this.myNextToken != null) {
            if (theOptions == this.myNextTokenOptions) {
                return;
            }
            this.myNextToken = null;
            this.myPosition = this.myNextTokenStartPosition;
        }
        while (true) {
            if (this.myPosition == this.myInput.length) {
                if (this.myBuffer.length() > 0) {
                    if (this.myState == LexerState.IN_SINGLE_QUOTED_STRING || this.myParenDepth > 0) {
                        throw new InvalidRequestException(Msg.code((int)2401) + "Unexpected end of string at position " + this.describePosition());
                    }
                    this.setNextToken(theOptions, this.myBuffer.toString());
                }
                return;
            }
            char nextChar = this.myInput[this.myPosition];
            this.handleNextChar(theOptions, nextChar);
            if (this.myNextToken != null) {
                return;
            }
            ++this.myPosition;
            if (nextChar == '\n') {
                ++this.myLine;
                this.myColumn = 0;
                continue;
            }
            if (nextChar == '\r') continue;
            ++this.myColumn;
        }
    }

    private void setNextToken(@Nonnull HfqlLexerOptions theOptions, String theNextToken) {
        this.myNextTokenOptions = theOptions;
        this.myNextToken = theNextToken;
        this.myBuffer.setLength(0);
        this.myState = LexerState.INITIAL;
    }

    private void handleNextChar(@Nonnull HfqlLexerOptions theOptions, char theNextChar) {
        if (theOptions.isSlurpParens()) {
            if (theNextChar == '(') {
                ++this.myParenDepth;
            } else if (theNextChar == ')') {
                --this.myParenDepth;
            }
        }
        switch (this.myState) {
            case INITIAL: {
                if (Character.isWhitespace(theNextChar)) {
                    return;
                }
                for (String nextMultiCharToken : theOptions.getMultiCharTokens()) {
                    boolean haveStringStartingHere = true;
                    for (int i = 0; i < nextMultiCharToken.length(); ++i) {
                        if (this.myInput.length > this.myPosition + 1 && nextMultiCharToken.charAt(i) == this.myInput[this.myPosition + i]) continue;
                        haveStringStartingHere = false;
                        break;
                    }
                    if (!haveStringStartingHere) continue;
                    this.setNextToken(theOptions, nextMultiCharToken);
                    this.myPosition += nextMultiCharToken.length();
                    return;
                }
                if (theNextChar == '\'') {
                    this.myNextTokenLine = this.myLine;
                    this.myNextTokenColumn = this.myColumn;
                    this.myState = LexerState.IN_SINGLE_QUOTED_STRING;
                    this.myBuffer.append(theNextChar);
                    return;
                }
                if (theOptions.getSingleCharTokenCharacters().contains(Character.valueOf(theNextChar))) {
                    this.myNextTokenStartPosition = this.myPosition++;
                    this.setNextToken(theOptions, Character.toString(theNextChar));
                    return;
                }
                if (!theOptions.getMultiCharTokenCharacters().contains(Character.valueOf(theNextChar))) break;
                this.myNextTokenStartPosition = this.myPosition;
                this.myNextTokenOptions = theOptions;
                this.myNextTokenLine = this.myLine;
                this.myNextTokenColumn = this.myColumn;
                this.myState = LexerState.IN_TOKEN;
                this.myBuffer.append(theNextChar);
                return;
            }
            case IN_TOKEN: {
                if (theOptions.getMultiCharTokenCharacters().contains(Character.valueOf(theNextChar))) {
                    this.myBuffer.append(theNextChar);
                    return;
                }
                if (this.myParenDepth > 0) {
                    this.myBuffer.append(theNextChar);
                    return;
                }
                this.setNextToken(theOptions, this.myBuffer.toString());
                return;
            }
            case IN_SINGLE_QUOTED_STRING: {
                char followingChar;
                if (theNextChar == '\'') {
                    this.myBuffer.append(theNextChar);
                    ++this.myPosition;
                    this.setNextToken(theOptions, this.myBuffer.toString());
                    return;
                }
                if (theNextChar == '\\' && this.myPosition < this.myInput.length - 1 && (followingChar = this.myInput[this.myPosition + 1]) == '\'') {
                    this.myBuffer.append(followingChar);
                    ++this.myPosition;
                    return;
                }
                this.myBuffer.append(theNextChar);
                return;
            }
        }
        throw new DataFormatException(Msg.code((int)2405) + "Unexpected character at position " + this.describePosition() + ": '" + theNextChar + "' (" + theNextChar + ")");
    }

    private String describePosition() {
        return "[line " + this.myLine + ", column " + this.myColumn + "]";
    }

    public List<String> allTokens() {
        return this.allTokens(HfqlLexerOptions.HFQL_TOKEN);
    }

    public List<String> allTokens(@Nonnull HfqlLexerOptions theOptions) {
        ArrayList<String> retVal = new ArrayList<String>();
        while (this.hasNextToken(theOptions)) {
            retVal.add(this.getNextToken(theOptions).toString());
        }
        return retVal;
    }

    public boolean hasNextToken(@Nonnull HfqlLexerOptions theOptions) {
        this.lexNextToken(theOptions);
        return this.myNextToken != null;
    }

    public void consumeNextToken() {
        Validate.isTrue((this.myNextToken != null ? 1 : 0) != 0);
        this.myNextToken = null;
    }

    public HfqlLexerToken peekNextToken(HfqlLexerOptions theOptions) {
        this.lexNextToken(theOptions);
        if (this.myNextToken == null) {
            return null;
        }
        return new HfqlLexerToken(this.myNextToken, this.myNextTokenLine, this.myNextTokenColumn);
    }

    private static enum LexerState {
        INITIAL,
        IN_SINGLE_QUOTED_STRING,
        IN_TOKEN;

    }
}

