/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.fql.parser;

import jakarta.annotation.Nonnull;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

class HfqlLexerToken {
    @Nonnull
    public final String myToken;
    private final int myLine;
    private final int myColumn;

    HfqlLexerToken(@Nonnull String theToken, int theLine, int theColumn) {
        this.myToken = theToken;
        this.myLine = theLine;
        this.myColumn = theColumn;
    }

    @Nonnull
    String getToken() {
        return this.myToken;
    }

    int getLine() {
        return this.myLine;
    }

    int getColumn() {
        return this.myColumn;
    }

    @Nonnull
    public String asKeyword() {
        return this.myToken.toUpperCase(Locale.US);
    }

    @Nonnull
    public String asString() {
        return this.myToken;
    }

    @Nonnull
    public String describePosition() {
        return "[line=" + this.getLine() + ", column=" + this.getColumn() + "]";
    }

    public boolean isQuotedString() {
        return StringUtils.startsWith((CharSequence)this.myToken, (CharSequence)"'") && StringUtils.endsWith((CharSequence)this.myToken, (CharSequence)"'");
    }

    public String toString() {
        return this.myToken;
    }

    public Integer asInteger() throws NumberFormatException {
        return Integer.parseInt(this.getToken());
    }
}

