/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.fql.parser;

import ca.uhn.fhir.jpa.fql.executor.HfqlDataTypeEnum;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.util.ValidateUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class HfqlStatement
implements IModelJson {
    @JsonProperty(value="select")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<SelectClause> mySelectClauses = new ArrayList<SelectClause>();
    @JsonProperty(value="where")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<WhereClause> myWhereClauses = new ArrayList<WhereClause>();
    @JsonProperty(value="groupBy")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<String> myGroupByClauses = new ArrayList<String>();
    @JsonProperty(value="orderBy")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<OrderByClause> myOrderByClauses = new ArrayList<OrderByClause>();
    @JsonProperty(value="fromResourceName")
    private String myFromResourceName;
    @JsonProperty(value="limit")
    private Integer myLimit;

    public List<SelectClause> getSelectClauses() {
        return this.mySelectClauses;
    }

    public String getFromResourceName() {
        return this.myFromResourceName;
    }

    public void setFromResourceName(String theFromResourceName) {
        this.myFromResourceName = theFromResourceName;
    }

    @Nonnull
    public SelectClause addSelectClause(@Nonnull String theClause) {
        SelectClauseOperator operator = SelectClauseOperator.SELECT;
        return this.addSelectClause(theClause, operator);
    }

    @Nonnull
    public SelectClause addSelectClause(@Nonnull String theClause, @Nonnull SelectClauseOperator operator) {
        SelectClause clause = new SelectClause();
        clause.setClause(theClause);
        clause.setOperator(operator);
        this.mySelectClauses.add(clause);
        return clause;
    }

    public WhereClause addWhereClause() {
        WhereClause clause = new WhereClause();
        this.myWhereClauses.add(clause);
        return clause;
    }

    public void addWhereClause(String theLeft, WhereClauseOperatorEnum theOperator) {
        WhereClause whereClause = this.addWhereClause();
        whereClause.setLeft(theLeft);
        whereClause.setOperator(theOperator);
    }

    public List<WhereClause> getWhereClauses() {
        return this.myWhereClauses;
    }

    @Nullable
    public Integer getLimit() {
        return this.myLimit;
    }

    public void setLimit(Integer theLimit) {
        this.myLimit = theLimit;
    }

    public void addGroupByClause(String theGroupByClause) {
        ValidateUtil.isNotBlankOrThrowIllegalArgument((String)theGroupByClause, (String)"theGroupByClause must not be null or blank");
        this.getGroupByClauses().add(theGroupByClause);
    }

    public List<String> getGroupByClauses() {
        if (this.myGroupByClauses == null) {
            this.myGroupByClauses = new ArrayList<String>();
        }
        return this.myGroupByClauses;
    }

    public boolean hasCountClauses() {
        return this.getSelectClauses().stream().anyMatch(t -> t.getOperator() == SelectClauseOperator.COUNT);
    }

    public OrderByClause addOrderByClause(String theClause, boolean theAscending) {
        ValidateUtil.isNotBlankOrThrowIllegalArgument((String)theClause, (String)"theClause must not be null or blank");
        OrderByClause clause = new OrderByClause();
        clause.setClause(theClause);
        clause.setAscending(theAscending);
        this.getOrderByClauses().add(clause);
        return clause;
    }

    public List<OrderByClause> getOrderByClauses() {
        if (this.myOrderByClauses == null) {
            this.myGroupByClauses = new ArrayList<String>();
        }
        return this.myOrderByClauses;
    }

    public int findSelectClauseIndex(String theClause) {
        for (int i = 0; i < this.getSelectClauses().size(); ++i) {
            if (!theClause.equals(this.getSelectClauses().get(i).getClause()) && !theClause.equals(this.getSelectClauses().get(i).getAlias())) continue;
            return i;
        }
        return -1;
    }

    public boolean hasOrderClause() {
        return !this.getOrderByClauses().isEmpty();
    }

    public List<String> toSelectedColumnAliases() {
        return this.mySelectClauses.stream().map(SelectClause::getAlias).collect(Collectors.toList());
    }

    public List<HfqlDataTypeEnum> toSelectedColumnDataTypes() {
        return this.mySelectClauses.stream().map(SelectClause::getDataType).collect(Collectors.toList());
    }

    public SelectClause addSelectClauseAndAlias(String theSelectClause) {
        return this.addSelectClause(theSelectClause).setAlias(theSelectClause);
    }

    public static enum SelectClauseOperator {
        SELECT,
        COUNT;

    }

    public static class SelectClause
    implements IModelJson {
        @JsonProperty(value="clause")
        private String myClause;
        @JsonProperty(value="alias")
        private String myAlias;
        @JsonProperty(value="operator")
        private SelectClauseOperator myOperator;
        @JsonProperty(value="dataType")
        private HfqlDataTypeEnum myDataType;

        public SelectClause() {
        }

        public SelectClause(String theClause) {
            this.setOperator(SelectClauseOperator.SELECT);
            this.setClause(theClause);
        }

        public HfqlDataTypeEnum getDataType() {
            return this.myDataType;
        }

        public SelectClause setDataType(HfqlDataTypeEnum theDataType) {
            this.myDataType = theDataType;
            return this;
        }

        public SelectClauseOperator getOperator() {
            return this.myOperator;
        }

        public void setOperator(SelectClauseOperator theOperator) {
            this.myOperator = theOperator;
        }

        public String getAlias() {
            return this.myAlias;
        }

        public SelectClause setAlias(String theAlias) {
            this.myAlias = theAlias;
            return this;
        }

        public String getClause() {
            return this.myClause;
        }

        public void setClause(String theClause) {
            this.myClause = theClause;
        }
    }

    public static class WhereClause
    implements IModelJson {
        @JsonProperty(value="left")
        private String myLeft;
        @JsonProperty(value="operator")
        private WhereClauseOperatorEnum myOperator;
        @JsonProperty(value="right")
        private List<String> myRight = new ArrayList<String>();

        public WhereClauseOperatorEnum getOperator() {
            return this.myOperator;
        }

        public void setOperator(WhereClauseOperatorEnum theOperator) {
            this.myOperator = theOperator;
        }

        public String getLeft() {
            return this.myLeft;
        }

        public void setLeft(String theLeft) {
            this.myLeft = theLeft;
        }

        public List<String> getRight() {
            return this.myRight;
        }

        public void setRight(String ... theValues) {
            this.myRight.clear();
            this.myRight.addAll(Arrays.asList(theValues));
        }

        public void addRight(String theRight) {
            this.myRight.add(theRight);
        }

        public List<String> getRightAsStrings() {
            ArrayList<String> retVal = new ArrayList<String>();
            for (String next : this.getRight()) {
                if (next.startsWith("'")) {
                    next = next.substring(1, next.length() - 1);
                }
                retVal.add(next);
            }
            return retVal;
        }

        public String asUnaryExpression() {
            return this.getLeft() + " " + StringUtils.join(this.getRight(), (char)' ');
        }
    }

    public static enum WhereClauseOperatorEnum {
        EQUALS,
        IN,
        UNARY_BOOLEAN,
        SEARCH_MATCH;

    }

    public static class OrderByClause
    implements IModelJson {
        @JsonProperty(value="clause")
        private String myClause;
        @JsonProperty(value="ascending")
        private boolean myAscending;

        public String getClause() {
            return this.myClause;
        }

        public void setClause(String theClause) {
            this.myClause = theClause;
        }

        public boolean isAscending() {
            return this.myAscending;
        }

        public void setAscending(boolean theAscending) {
            this.myAscending = theAscending;
        }
    }
}

