/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.fql.parser;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.fql.parser.HfqlLexer;
import ca.uhn.fhir.jpa.fql.parser.HfqlLexerOptions;
import ca.uhn.fhir.jpa.fql.parser.HfqlLexerToken;
import ca.uhn.fhir.jpa.fql.parser.HfqlStatement;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.util.UrlUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class HfqlStatementParser {
    public static final String KEYWORD_AND = "AND";
    public static final String KEYWORD_WHERE = "WHERE";
    public static final String KEYWORD_SELECT = "SELECT";
    public static final String KEYWORD_FROM = "FROM";
    public static final String KEYWORD_LIMIT = "LIMIT";
    public static final String KEYWORD_GROUP = "GROUP";
    public static final String KEYWORD_ORDER = "ORDER";
    public static final String KEYWORD_TRUE = "TRUE";
    public static final String KEYWORD_FALSE = "FALSE";
    private static final Set<String> DIRECTIVE_KEYWORDS = Set.of("FROM", "GROUP", "LIMIT", "ORDER", "WHERE", "SELECT");
    private final HfqlLexer myLexer;
    private final FhirContext myFhirContext;
    private BaseState myState;
    private HfqlStatement myStatement;

    public HfqlStatementParser(FhirContext theFhirContext, String theInput) {
        this.myFhirContext = theFhirContext;
        this.myLexer = new HfqlLexer(theInput);
        this.myState = new InitialState();
    }

    public HfqlStatement parse() {
        Validate.isTrue((this.myStatement == null ? 1 : 0) != 0, (String)"Already completed parsing", (Object[])new Object[0]);
        this.myStatement = new HfqlStatement();
        while (this.myLexer.hasNextToken(this.myState.getLexerOptions())) {
            HfqlLexerToken nextToken = this.myLexer.getNextToken(this.myState.getLexerOptions());
            this.myState.consume(nextToken);
        }
        if (StringUtils.isBlank((CharSequence)this.myStatement.getFromResourceName())) {
            throw HfqlStatementParser.newExceptionUnexpectedTokenExpectToken(null, KEYWORD_FROM);
        }
        if (this.myStatement.getSelectClauses().isEmpty()) {
            throw HfqlStatementParser.newExceptionUnexpectedTokenExpectToken(null, KEYWORD_SELECT);
        }
        HashSet<String> existingAliases = new HashSet<String>();
        for (HfqlStatement.SelectClause next : this.myStatement.getSelectClauses()) {
            if (!StringUtils.isNotBlank((CharSequence)next.getAlias()) || existingAliases.add(next.getAlias())) continue;
            throw new DataFormatException(Msg.code((int)2414) + "Duplicate SELECT column alias: " + UrlUtil.sanitizeUrlPart((CharSequence)next.getAlias()));
        }
        for (HfqlStatement.SelectClause next : this.myStatement.getSelectClauses()) {
            if (!StringUtils.isBlank((CharSequence)next.getAlias())) continue;
            Object candidateAlias = next.getClause();
            int nextSuffix = 2;
            while (existingAliases.contains(candidateAlias)) {
                candidateAlias = next.getClause() + nextSuffix;
                ++nextSuffix;
            }
            existingAliases.add((String)candidateAlias);
            next.setAlias((String)candidateAlias);
        }
        return this.myStatement;
    }

    @Nonnull
    private HfqlLexerToken getNextTokenRequired(@Nonnull HfqlLexerOptions theOptions) {
        if (!this.myLexer.hasNextToken(theOptions)) {
            throw HfqlStatementParser.newExceptionUnexpectedToken(null);
        }
        return this.myLexer.getNextToken(theOptions);
    }

    @Nonnull
    private static DataFormatException newExceptionUnexpectedToken(@Nullable HfqlLexerToken theToken) {
        return HfqlStatementParser.newExceptionUnexpectedTokenExpectDescription(theToken, null);
    }

    @Nonnull
    private static DataFormatException newExceptionUnexpectedTokenExpectToken(@Nullable HfqlLexerToken theToken, @Nonnull String theExpectedToken) {
        return HfqlStatementParser.newExceptionUnexpectedTokenExpectDescription(theToken, "\"" + theExpectedToken + "\"");
    }

    @Nonnull
    private static DataFormatException newExceptionUnexpectedTokenExpectDescription(@Nullable HfqlLexerToken theToken, @Nullable String theExpectedDescription) {
        StringBuilder b = new StringBuilder();
        b.append("Unexpected ");
        if (theToken != null) {
            b.append("token");
        } else {
            b.append("end of stream");
        }
        if (theExpectedDescription != null) {
            b.append(" (expected ");
            b.append(theExpectedDescription);
            b.append(")");
        }
        if (theToken != null) {
            b.append(" at position ");
            b.append(theToken.describePosition());
            b.append(": ");
            b.append(theToken.getToken());
        }
        String message = b.toString();
        return new DataFormatException(message);
    }

    @Nonnull
    private static DataFormatException newExceptionUnknownResourceType(HfqlLexerToken theToken, String resourceType) {
        return new DataFormatException("Invalid FROM statement. Unknown resource type '" + resourceType + "' at position: " + theToken.describePosition());
    }

    private static void validateNotPresent(List<?> theClauses, HfqlLexerToken theKeyword) {
        if (!theClauses.isEmpty()) {
            throw HfqlStatementParser.newExceptionUnexpectedToken(theKeyword);
        }
    }

    private static void validateNotPresent(Object theValue, HfqlLexerToken theKeyword) {
        if (theValue != null) {
            throw HfqlStatementParser.newExceptionUnexpectedToken(theKeyword);
        }
    }

    public class InitialState
    extends BaseRootState {
    }

    private static abstract class BaseState {
        private BaseState() {
        }

        abstract void consume(HfqlLexerToken var1);

        @Nonnull
        public HfqlLexerOptions getLexerOptions() {
            return HfqlLexerOptions.HFQL_TOKEN;
        }
    }

    private class OrderByAfterState
    extends BaseRootState {
        private final HfqlStatement.OrderByClause myClause;

        public OrderByAfterState(HfqlStatement.OrderByClause theClause) {
            this.myClause = theClause;
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            if ("ASC".equals(theToken.asKeyword())) {
                this.myClause.setAscending(true);
            } else if ("DESC".equals(theToken.asKeyword())) {
                this.myClause.setAscending(false);
            } else if (",".equals(theToken.getToken())) {
                HfqlStatementParser.this.myState = new OrderByState();
            } else {
                super.consume(theToken);
            }
        }
    }

    private class OrderByState
    extends BaseState {
        private OrderByState() {
        }

        @Override
        @Nonnull
        public HfqlLexerOptions getLexerOptions() {
            return HfqlLexerOptions.FHIRPATH_EXPRESSION;
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            HfqlStatement.OrderByClause clause = HfqlStatementParser.this.myStatement.addOrderByClause(theToken.getToken(), true);
            HfqlStatementParser.this.myState = new OrderByAfterState(clause);
        }
    }

    private class OrderState
    extends BaseState {
        private OrderState() {
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            if (!"BY".equals(theToken.asKeyword())) {
                throw HfqlStatementParser.newExceptionUnexpectedTokenExpectToken(theToken, "BY");
            }
            HfqlStatementParser.this.myState = new OrderByState();
        }
    }

    private class StateAfterGroupBy
    extends BaseRootState {
        private StateAfterGroupBy() {
        }
    }

    private class StateGroupBy
    extends BaseState {
        private StateGroupBy() {
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            HfqlStatementParser.this.myStatement.addGroupByClause(theToken.asString());
            if (HfqlStatementParser.this.myLexer.hasNextToken(HfqlLexerOptions.HFQL_TOKEN) && ",".equals(HfqlStatementParser.this.myLexer.peekNextToken(HfqlLexerOptions.HFQL_TOKEN).getToken())) {
                HfqlStatementParser.this.myLexer.consumeNextToken();
            } else {
                HfqlStatementParser.this.myState = new StateAfterGroupBy();
            }
        }
    }

    private class StateGroup
    extends BaseState {
        private StateGroup() {
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            if (!"BY".equals(theToken.asKeyword())) {
                throw HfqlStatementParser.newExceptionUnexpectedTokenExpectToken(theToken, "BY");
            }
            HfqlStatementParser.this.myState = new StateGroupBy();
        }
    }

    private abstract class BaseRootState
    extends BaseState {
        private BaseRootState() {
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            String keyword;
            switch (keyword = theToken.asKeyword()) {
                case "WHERE": {
                    HfqlStatementParser.validateNotPresent(HfqlStatementParser.this.myStatement.getWhereClauses(), theToken);
                    HfqlStatementParser.this.myState = new StateInWhereInitial();
                    break;
                }
                case "SELECT": {
                    HfqlStatementParser.validateNotPresent(HfqlStatementParser.this.myStatement.getSelectClauses(), theToken);
                    HfqlStatementParser.this.myState = new StateInSelect();
                    break;
                }
                case "FROM": {
                    HfqlStatementParser.validateNotPresent(HfqlStatementParser.this.myStatement.getFromResourceName(), theToken);
                    HfqlStatementParser.this.myState = new StateFromStart();
                    break;
                }
                case "LIMIT": {
                    HfqlStatementParser.validateNotPresent(HfqlStatementParser.this.myStatement.getLimit(), theToken);
                    HfqlStatementParser.this.myState = new LimitState();
                    break;
                }
                case "GROUP": {
                    HfqlStatementParser.validateNotPresent(HfqlStatementParser.this.myStatement.getGroupByClauses(), theToken);
                    HfqlStatementParser.this.myState = new StateGroup();
                    break;
                }
                case "ORDER": {
                    HfqlStatementParser.validateNotPresent(HfqlStatementParser.this.myStatement.getOrderByClauses(), theToken);
                    HfqlStatementParser.this.myState = new OrderState();
                    break;
                }
                default: {
                    if (HfqlStatementParser.this.myStatement.getWhereClauses().isEmpty()) {
                        throw HfqlStatementParser.newExceptionUnexpectedTokenExpectToken(theToken, HfqlStatementParser.KEYWORD_SELECT);
                    }
                    throw HfqlStatementParser.newExceptionUnexpectedToken(theToken);
                }
            }
        }
    }

    private class LimitState
    extends BaseState {
        private LimitState() {
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            try {
                HfqlStatementParser.this.myStatement.setLimit(theToken.asInteger());
            }
            catch (NumberFormatException e) {
                throw HfqlStatementParser.newExceptionUnexpectedTokenExpectDescription(theToken, "integer value");
            }
        }
    }

    private class StateAfterWhere
    extends BaseRootState {
        private StateAfterWhere() {
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            String keyword = theToken.asKeyword();
            if (keyword.equals(HfqlStatementParser.KEYWORD_AND)) {
                HfqlStatementParser.this.myState = new StateInWhereInitial();
            } else {
                super.consume(theToken);
            }
        }
    }

    private class StateInWhereSearchMatch
    extends BaseState {
        private final HfqlStatement.WhereClause myWhereClause;

        public StateInWhereSearchMatch(HfqlStatement.WhereClause theWhereClause) {
            this.myWhereClause = theWhereClause;
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            if (")".equals(theToken.getToken())) {
                HfqlStatementParser.this.myState = new StateAfterWhere();
            } else {
                this.myWhereClause.addRight(theToken.getToken());
                HfqlLexerToken nextToken = HfqlStatementParser.this.getNextTokenRequired(this.getLexerOptions());
                if (")".equals(nextToken.getToken())) {
                    HfqlStatementParser.this.myState = new StateAfterWhere();
                } else if (!",".equals(nextToken.getToken())) {
                    throw HfqlStatementParser.newExceptionUnexpectedTokenExpectToken(nextToken, ",");
                }
            }
        }
    }

    private class StateInWhereAfterOperatorIn
    extends BaseState {
        private final HfqlStatement.WhereClause myWhereClause;

        public StateInWhereAfterOperatorIn(HfqlStatement.WhereClause theWhereClause) {
            this.myWhereClause = theWhereClause;
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            this.myWhereClause.addRight(theToken.getToken());
            if (HfqlStatementParser.this.myLexer.peekNextToken(this.getLexerOptions()) != null) {
                if (HfqlStatementParser.this.myLexer.peekNextToken(this.getLexerOptions()).getToken().equals("|")) {
                    HfqlStatementParser.this.myLexer.consumeNextToken();
                    return;
                }
                if (HfqlStatementParser.this.myLexer.peekNextToken(this.getLexerOptions()).getToken().equals(",")) {
                    HfqlStatementParser.this.myLexer.consumeNextToken();
                    return;
                }
                if (HfqlStatementParser.this.myLexer.peekNextToken(this.getLexerOptions()).getToken().equals(")")) {
                    HfqlStatementParser.this.myLexer.consumeNextToken();
                    HfqlStatementParser.this.myState = new StateAfterWhere();
                    return;
                }
            }
            throw HfqlStatementParser.newExceptionUnexpectedToken(HfqlStatementParser.this.myLexer.peekNextToken(this.getLexerOptions()));
        }
    }

    private class StateInWhereAfterOperatorEquals
    extends BaseState {
        private final HfqlStatement.WhereClause myWhereClause;

        public StateInWhereAfterOperatorEquals(HfqlStatement.WhereClause theWhereClause) {
            this.myWhereClause = theWhereClause;
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            String token = theToken.getToken();
            String keyword = theToken.asKeyword();
            if (HfqlStatementParser.KEYWORD_TRUE.equals(keyword) || HfqlStatementParser.KEYWORD_FALSE.equals(keyword)) {
                token = keyword.toLowerCase(Locale.US);
            } else if (!theToken.isQuotedString()) {
                throw HfqlStatementParser.newExceptionUnexpectedTokenExpectDescription(theToken, "quoted string");
            }
            this.myWhereClause.addRight(token);
            HfqlStatementParser.this.myState = new StateAfterWhere();
        }
    }

    private class StateInWhereAfterLeft
    extends BaseRootState {
        private final HfqlStatement.WhereClause myWhereClause;

        public StateInWhereAfterLeft(HfqlStatement.WhereClause theWhereClause) {
            this.myWhereClause = theWhereClause;
        }

        @Override
        @Nonnull
        public HfqlLexerOptions getLexerOptions() {
            return HfqlLexerOptions.FHIRPATH_EXPRESSION;
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            if ("=".equals(theToken.getToken())) {
                this.myWhereClause.setOperator(HfqlStatement.WhereClauseOperatorEnum.EQUALS);
                HfqlStatementParser.this.myState = new StateInWhereAfterOperatorEquals(this.myWhereClause);
            } else {
                HfqlLexerToken nextToken;
                block16: {
                    if ("IN".equals(theToken.asKeyword())) {
                        HfqlLexerToken nextToken2 = HfqlStatementParser.this.getNextTokenRequired(HfqlLexerOptions.HFQL_TOKEN);
                        switch (nextToken2.asKeyword()) {
                            case "(": {
                                this.myWhereClause.setOperator(HfqlStatement.WhereClauseOperatorEnum.IN);
                                HfqlStatementParser.this.myState = new StateInWhereAfterOperatorIn(this.myWhereClause);
                                return;
                            }
                            case "SEARCH_MATCH": {
                                this.myWhereClause.setOperator(HfqlStatement.WhereClauseOperatorEnum.SEARCH_MATCH);
                                HfqlLexerToken argumentsToken = HfqlStatementParser.this.getNextTokenRequired(HfqlLexerOptions.HFQL_TOKEN);
                                String token = argumentsToken.getToken();
                                if (!token.equals("(")) {
                                    throw HfqlStatementParser.newExceptionUnexpectedTokenExpectToken(theToken, "(");
                                }
                                HfqlStatementParser.this.myState = new StateInWhereSearchMatch(this.myWhereClause);
                                return;
                            }
                        }
                        throw HfqlStatementParser.newExceptionUnexpectedTokenExpectToken(theToken, "(");
                    }
                    this.myWhereClause.setOperator(HfqlStatement.WhereClauseOperatorEnum.UNARY_BOOLEAN);
                    nextToken = theToken;
                    if (!HfqlStatementParser.KEYWORD_AND.equals(nextToken.asKeyword()) && !DIRECTIVE_KEYWORDS.contains(nextToken.asKeyword())) {
                        this.myWhereClause.addRight(nextToken.getToken());
                        while (HfqlStatementParser.this.myLexer.hasNextToken(HfqlLexerOptions.FHIRPATH_EXPRESSION)) {
                            nextToken = HfqlStatementParser.this.myLexer.getNextToken(HfqlLexerOptions.FHIRPATH_EXPRESSION);
                            String nextTokenAsKeyword = nextToken.asKeyword();
                            if (!HfqlStatementParser.KEYWORD_AND.equals(nextTokenAsKeyword) && !DIRECTIVE_KEYWORDS.contains(nextTokenAsKeyword)) {
                                this.myWhereClause.addRight(nextToken.getToken());
                                continue;
                            }
                            break block16;
                        }
                        nextToken = null;
                    }
                }
                if (nextToken != null) {
                    super.consume(nextToken);
                }
            }
        }
    }

    private class StateInWhereInitial
    extends BaseState {
        private StateInWhereInitial() {
        }

        @Override
        @Nonnull
        public HfqlLexerOptions getLexerOptions() {
            return HfqlLexerOptions.FHIRPATH_EXPRESSION;
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            HfqlStatement.WhereClause whereClause = HfqlStatementParser.this.myStatement.addWhereClause();
            String token = theToken.getToken();
            whereClause.setLeft(token);
            whereClause.setOperator(HfqlStatement.WhereClauseOperatorEnum.UNARY_BOOLEAN);
            HfqlStatementParser.this.myState = new StateInWhereAfterLeft(whereClause);
        }
    }

    private class StateSelectAfterClauseFinal
    extends BaseRootState {
        protected final HfqlStatement.SelectClause mySelectClause;

        private StateSelectAfterClauseFinal(HfqlStatement.SelectClause theSelectClause) {
            this.mySelectClause = theSelectClause;
        }

        @Override
        @Nonnull
        public HfqlLexerOptions getLexerOptions() {
            return HfqlLexerOptions.FHIRPATH_EXPRESSION;
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            if (theToken.getToken().equals(",")) {
                HfqlStatementParser.this.myState = new StateInSelect();
            } else if (!DIRECTIVE_KEYWORDS.contains(theToken.asKeyword())) {
                String newClause = this.mySelectClause.getClause() + " " + theToken.getToken();
                this.mySelectClause.setClause(newClause);
            } else {
                super.consume(theToken);
            }
        }
    }

    private class StateInSelectAfterClause
    extends StateSelectAfterClauseFinal {
        public StateInSelectAfterClause(HfqlStatement.SelectClause theSelectClause) {
            super(theSelectClause);
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            if (theToken.getToken().equals(":")) {
                HfqlLexerToken nextToken = HfqlStatementParser.this.getNextTokenRequired(HfqlLexerOptions.FHIRPATH_EXPRESSION);
                String clause = nextToken.asString();
                String alias = this.mySelectClause.getClause();
                this.mySelectClause.setAlias(alias);
                this.mySelectClause.setClause(clause);
                HfqlStatementParser.this.myState = new StateSelectAfterClauseFinal(this.mySelectClause);
            } else if (theToken.asKeyword().equals("AS")) {
                HfqlLexerToken nextToken = HfqlStatementParser.this.getNextTokenRequired(HfqlLexerOptions.HFQL_TOKEN);
                String alias = nextToken.asString();
                this.mySelectClause.setAlias(alias);
                HfqlStatementParser.this.myState = new StateSelectAfterClauseFinal(this.mySelectClause);
            } else {
                super.consume(theToken);
            }
        }
    }

    public class StateInSelect
    extends BaseState {
        @Override
        @Nonnull
        public HfqlLexerOptions getLexerOptions() {
            return HfqlLexerOptions.FHIRPATH_EXPRESSION;
        }

        @Override
        void consume(HfqlLexerToken theToken) {
            HfqlStatement.SelectClause clause;
            String asKeyword = theToken.asKeyword();
            if (asKeyword.startsWith("COUNT(") && asKeyword.endsWith(")")) {
                String countClause = theToken.asString().substring("COUNT(".length(), asKeyword.length() - 1);
                clause = HfqlStatementParser.this.myStatement.addSelectClause(countClause, HfqlStatement.SelectClauseOperator.COUNT);
                clause.setAlias(theToken.getToken());
            } else {
                String string = theToken.asString();
                clause = HfqlStatementParser.this.myStatement.addSelectClause(string);
            }
            HfqlStatementParser.this.myState = new StateInSelectAfterClause(clause);
        }
    }

    public class StateFromAfter
    extends BaseRootState {
    }

    public class StateFromStart
    extends BaseState {
        @Override
        void consume(HfqlLexerToken theToken) {
            String resourceType = theToken.asString();
            if (!HfqlStatementParser.this.myFhirContext.getResourceTypes().contains(resourceType)) {
                throw HfqlStatementParser.newExceptionUnknownResourceType(theToken, resourceType);
            }
            HfqlStatementParser.this.myStatement.setFromResourceName(resourceType);
            HfqlStatementParser.this.myState = new StateFromAfter();
        }
    }
}

