/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.fql.provider;

import ca.uhn.fhir.jpa.fql.executor.IHfqlExecutionResult;
import ca.uhn.fhir.jpa.fql.executor.IHfqlExecutor;
import ca.uhn.fhir.jpa.fql.jdbc.HfqlRestClient;
import ca.uhn.fhir.jpa.fql.parser.HfqlStatement;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.DatatypeUtil;
import ca.uhn.fhir.util.JsonUtil;
import ca.uhn.fhir.util.ValidateUtil;
import ca.uhn.fhir.util.VersionUtil;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.csv.CSVPrinter;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.beans.factory.annotation.Autowired;

public class HfqlRestProvider {
    @Autowired
    private IHfqlExecutor myHfqlExecutor;

    public HfqlRestProvider() {
        this(null);
    }

    public HfqlRestProvider(IHfqlExecutor theHfqlExecutor) {
        this.myHfqlExecutor = theHfqlExecutor;
    }

    public IHfqlExecutor getHfqlExecutor() {
        return this.myHfqlExecutor;
    }

    public void setHfqlExecutor(IHfqlExecutor theHfqlExecutor) {
        this.myHfqlExecutor = theHfqlExecutor;
    }

    @Operation(name="$hfql-execute", manualResponse=true)
    public void executeFql(@OperationParam(name="action", typeName="code", min=0, max=1) IPrimitiveType<String> theAction, @OperationParam(name="query", typeName="string", min=0, max=1) IPrimitiveType<String> theQuery, @OperationParam(name="statement", typeName="string", min=0, max=1) IPrimitiveType<String> theStatement, @OperationParam(name="continuation", typeName="string", min=0, max=1) IPrimitiveType<String> theContinuation, @OperationParam(name="limit", typeName="integer", min=0, max=1) IPrimitiveType<Integer> theLimit, @OperationParam(name="offset", typeName="integer", min=0, max=1) IPrimitiveType<Integer> theOffset, @OperationParam(name="fetchSize", typeName="integer", min=0, max=1) IPrimitiveType<Integer> theFetchSize, @OperationParam(name="introspectTableName", typeName="string", min=0, max=1) IPrimitiveType<String> theIntrospectTableName, @OperationParam(name="introspectColumnName", typeName="string", min=0, max=1) IPrimitiveType<String> theIntrospectColumnName, RequestDetails theRequestDetails, HttpServletResponse theServletResponse) throws IOException {
        String action = DatatypeUtil.toStringValue(theAction);
        int fetchSize = HfqlRestProvider.parseFetchSize(theFetchSize);
        Integer limit = HfqlRestProvider.parseLimit(theLimit);
        switch (action) {
            case "search": {
                String query = DatatypeUtil.toStringValue(theQuery);
                IHfqlExecutionResult outcome = this.getHfqlExecutor().executeInitialSearch(query, limit, theRequestDetails);
                HfqlRestProvider.streamResponseCsv(theServletResponse, fetchSize, outcome, true, outcome.getStatement());
                break;
            }
            case "searchContinuation": {
                String continuation = DatatypeUtil.toStringValue(theContinuation);
                ValidateUtil.isTrueOrThrowInvalidRequest((theOffset != null && theOffset.hasValue() ? 1 : 0) != 0, (String)"No offset supplied", (Object[])new Object[0]);
                int startingOffset = (Integer)theOffset.getValue();
                String statement = DatatypeUtil.toStringValue(theStatement);
                ValidateUtil.isNotBlankOrThrowIllegalArgument((String)statement, (String)"No statement provided");
                HfqlStatement statementJson = (HfqlStatement)JsonUtil.deserialize((String)statement, HfqlStatement.class);
                IHfqlExecutionResult outcome = this.myHfqlExecutor.executeContinuation(statementJson, continuation, startingOffset, limit, theRequestDetails);
                HfqlRestProvider.streamResponseCsv(theServletResponse, fetchSize, outcome, false, outcome.getStatement());
                break;
            }
            case "introspectTables": {
                IHfqlExecutionResult outcome = this.myHfqlExecutor.introspectTables();
                HfqlRestProvider.streamResponseCsv(theServletResponse, fetchSize, outcome, true, outcome.getStatement());
                break;
            }
            case "introspectColumns": {
                String tableName = DatatypeUtil.toStringValue(theIntrospectTableName);
                String columnName = DatatypeUtil.toStringValue(theIntrospectColumnName);
                IHfqlExecutionResult outcome = this.myHfqlExecutor.introspectColumns(tableName, columnName);
                HfqlRestProvider.streamResponseCsv(theServletResponse, fetchSize, outcome, true, outcome.getStatement());
                break;
            }
            default: {
                ValidateUtil.isTrueOrThrowInvalidRequest((boolean)false, (String)"Unrecognized action: %s", (Object[])new Object[]{action});
            }
        }
    }

    @Nullable
    private static Integer parseLimit(IPrimitiveType<Integer> theLimit) {
        Integer limit = null;
        if (theLimit != null) {
            limit = (Integer)theLimit.getValue();
        }
        return limit;
    }

    private static int parseFetchSize(IPrimitiveType<Integer> theFetchSize) {
        int fetchSize = 1000;
        if (theFetchSize != null && theFetchSize.getValue() != null) {
            fetchSize = (Integer)theFetchSize.getValue();
        }
        if (fetchSize == 0) {
            fetchSize = 10000;
        }
        ValidateUtil.isTrueOrThrowInvalidRequest((fetchSize >= 1 && fetchSize <= 10000 ? 1 : 0) != 0, (String)"Fetch size must be between %d and %d", (Object[])new Object[]{1, 10000});
        return fetchSize;
    }

    private static void streamResponseCsv(HttpServletResponse theServletResponse, int theFetchSize, IHfqlExecutionResult theResult, boolean theInitialPage, HfqlStatement theStatement) throws IOException {
        theServletResponse.setStatus(200);
        theServletResponse.setContentType("text/csv; charset=UTF-8");
        try (ServletOutputStream outputStream = theServletResponse.getOutputStream();){
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream);
            try (CSVPrinter csvWriter = new CSVPrinter((Appendable)out, HfqlRestClient.CSV_FORMAT);){
                csvWriter.printRecords(new Object[0]);
                csvWriter.printRecord(new Object[]{"1", "HAPI FHIR " + VersionUtil.getVersion()});
                String searchId = theResult.getSearchId();
                String parsedFqlStatement = "";
                if (theInitialPage && theStatement != null) {
                    parsedFqlStatement = JsonUtil.serialize((Object)theStatement, (boolean)false);
                }
                csvWriter.printRecord(new Object[]{searchId, theResult.getLimit(), parsedFqlStatement});
                int recordCount = 0;
                while (recordCount++ < theFetchSize && theResult.hasNext()) {
                    IHfqlExecutionResult.Row nextRow = theResult.getNextRow();
                    csvWriter.print((Object)nextRow.getRowOffset());
                    csvWriter.printRecord(nextRow.getRowValues());
                }
                csvWriter.flush();
            }
        }
    }
}

