/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.ips.api;

import ca.uhn.fhir.jpa.ips.api.IpsContext;
import ca.uhn.fhir.jpa.ips.api.IpsSectionContext;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.thymeleaf.util.Validate;

public interface ISectionResourceSupplier {
    @Nullable
    public <T extends IBaseResource> List<ResourceEntry> fetchResourcesForSection(IpsContext var1, IpsSectionContext<T> var2, RequestDetails var3);

    public static class ResourceEntry {
        private final IBaseResource myResource;
        private final InclusionTypeEnum myInclusionType;

        public ResourceEntry(@Nonnull IBaseResource theResource, @Nonnull InclusionTypeEnum theInclusionType) {
            Validate.notNull((Object)theResource, (String)"theResource must not be null");
            Validate.notNull((Object)((Object)theInclusionType), (String)"theInclusionType must not be null");
            this.myResource = theResource;
            this.myInclusionType = theInclusionType;
        }

        public IBaseResource getResource() {
            return this.myResource;
        }

        public InclusionTypeEnum getInclusionType() {
            return this.myInclusionType;
        }
    }

    public static enum InclusionTypeEnum {
        PRIMARY_RESOURCE,
        SECONDARY_RESOURCE,
        EXCLUDE;

    }
}

