/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.ips.api;

import ca.uhn.fhir.jpa.ips.api.INoInfoGenerator;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class Section {
    private final String myTitle;
    private final String mySectionCode;
    private final String mySectionDisplay;
    private final List<Class<? extends IBaseResource>> myResourceTypes;
    private final String myProfile;
    private final INoInfoGenerator myNoInfoGenerator;
    private final String mySectionSystem;

    private Section(String theTitle, String theSectionSystem, String theSectionCode, String theSectionDisplay, List<Class<? extends IBaseResource>> theResourceTypes, String theProfile, INoInfoGenerator theNoInfoGenerator) {
        this.myTitle = theTitle;
        this.mySectionSystem = theSectionSystem;
        this.mySectionCode = theSectionCode;
        this.mySectionDisplay = theSectionDisplay;
        this.myResourceTypes = List.copyOf(theResourceTypes);
        this.myProfile = theProfile;
        this.myNoInfoGenerator = theNoInfoGenerator;
    }

    @Nullable
    public INoInfoGenerator getNoInfoGenerator() {
        return this.myNoInfoGenerator;
    }

    public List<Class<? extends IBaseResource>> getResourceTypes() {
        return this.myResourceTypes;
    }

    public String getProfile() {
        return this.myProfile;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public String getSectionSystem() {
        return this.mySectionSystem;
    }

    public String getSectionCode() {
        return this.mySectionCode;
    }

    public String getSectionDisplay() {
        return this.mySectionDisplay;
    }

    public boolean equals(Object theO) {
        if (theO instanceof Section) {
            Section o = (Section)theO;
            return StringUtils.equals((CharSequence)this.myProfile, (CharSequence)o.myProfile);
        }
        return false;
    }

    public int hashCode() {
        return this.myProfile.hashCode();
    }

    public static SectionBuilder newBuilder() {
        return new SectionBuilder();
    }

    public static SectionBuilder newBuilder(Section theSection) {
        return new SectionBuilder(theSection.myTitle, theSection.mySectionSystem, theSection.mySectionCode, theSection.mySectionDisplay, theSection.myProfile, theSection.myNoInfoGenerator, theSection.myResourceTypes);
    }

    public static class SectionBuilder {
        private String myTitle;
        private String mySectionSystem;
        private String mySectionCode;
        private String mySectionDisplay;
        private List<Class<? extends IBaseResource>> myResourceTypes = new ArrayList<Class<? extends IBaseResource>>();
        private String myProfile;
        private INoInfoGenerator myNoInfoGenerator;

        private SectionBuilder() {
        }

        public SectionBuilder(String theTitle, String theSectionSystem, String theSectionCode, String theSectionDisplay, String theProfile, INoInfoGenerator theNoInfoGenerator, List<Class<? extends IBaseResource>> theResourceTypes) {
            this.myTitle = theTitle;
            this.mySectionSystem = theSectionSystem;
            this.mySectionCode = theSectionCode;
            this.mySectionDisplay = theSectionDisplay;
            this.myNoInfoGenerator = theNoInfoGenerator;
            this.myProfile = theProfile;
            this.myResourceTypes = new ArrayList<Class<? extends IBaseResource>>(theResourceTypes);
        }

        public SectionBuilder withTitle(String theTitle) {
            Validate.notBlank((CharSequence)theTitle);
            this.myTitle = theTitle;
            return this;
        }

        public SectionBuilder withSectionSystem(String theSectionSystem) {
            Validate.notBlank((CharSequence)theSectionSystem);
            this.mySectionSystem = theSectionSystem;
            return this;
        }

        public SectionBuilder withSectionCode(String theSectionCode) {
            Validate.notBlank((CharSequence)theSectionCode);
            this.mySectionCode = theSectionCode;
            return this;
        }

        public SectionBuilder withSectionDisplay(String theSectionDisplay) {
            Validate.notBlank((CharSequence)theSectionDisplay);
            this.mySectionDisplay = theSectionDisplay;
            return this;
        }

        public SectionBuilder withResourceType(Class<? extends IBaseResource> theResourceType) {
            Validate.notNull(theResourceType, (String)"theResourceType must not be null", (Object[])new Object[0]);
            Validate.isTrue((!this.myResourceTypes.contains(theResourceType) ? 1 : 0) != 0, (String)"theResourceType has already been added", (Object[])new Object[0]);
            this.myResourceTypes.add(theResourceType);
            return this;
        }

        public SectionBuilder withProfile(String theProfile) {
            Validate.notBlank((CharSequence)theProfile);
            this.myProfile = theProfile;
            return this;
        }

        public SectionBuilder withNoInfoGenerator(@Nullable INoInfoGenerator theNoInfoGenerator) {
            this.myNoInfoGenerator = theNoInfoGenerator;
            return this;
        }

        public Section build() {
            Validate.notBlank((CharSequence)this.mySectionSystem, (String)"No section system has been defined for this section", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)this.mySectionCode, (String)"No section code has been defined for this section", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)this.mySectionDisplay, (String)"No section display has been defined for this section", (Object[])new Object[0]);
            return new Section(this.myTitle, this.mySectionSystem, this.mySectionCode, this.mySectionDisplay, this.myResourceTypes, this.myProfile, this.myNoInfoGenerator);
        }
    }
}

