/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.ips.generator;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fhirpath.IFhirPathEvaluationContext;
import ca.uhn.fhir.jpa.ips.api.IIpsGenerationStrategy;
import ca.uhn.fhir.jpa.ips.api.ISectionResourceSupplier;
import ca.uhn.fhir.jpa.ips.api.IpsContext;
import ca.uhn.fhir.jpa.ips.api.IpsSectionContext;
import ca.uhn.fhir.jpa.ips.api.Section;
import ca.uhn.fhir.jpa.ips.generator.IIpsGeneratorSvc;
import ca.uhn.fhir.narrative.CustomThymeleafNarrativeGenerator;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.util.BundleBuilder;
import ca.uhn.fhir.util.CompositionBuilder;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Resource;

public class IpsGeneratorSvcImpl
implements IIpsGeneratorSvc {
    public static final String RESOURCE_ENTRY_INCLUSION_TYPE = "RESOURCE_ENTRY_INCLUSION_TYPE";
    public static final String URL_NARRATIVE_LINK = "http://hl7.org/fhir/StructureDefinition/narrativeLink";
    private final List<IIpsGenerationStrategy> myGenerationStrategies;
    private final FhirContext myFhirContext;

    public IpsGeneratorSvcImpl(FhirContext theFhirContext, IIpsGenerationStrategy theGenerationStrategy) {
        this(theFhirContext, List.of(theGenerationStrategy));
    }

    public IpsGeneratorSvcImpl(FhirContext theFhirContext, List<IIpsGenerationStrategy> theIpsGenerationStrategies) {
        this.myGenerationStrategies = theIpsGenerationStrategies;
        this.myFhirContext = theFhirContext;
        this.myGenerationStrategies.forEach(IIpsGenerationStrategy::initialize);
    }

    @Override
    public IBaseBundle generateIps(RequestDetails theRequestDetails, IIdType thePatientId, String theProfile) {
        IIpsGenerationStrategy strategy = this.selectGenerationStrategy(theProfile);
        IBaseResource patient = strategy.fetchPatient(thePatientId, theRequestDetails);
        return this.generateIpsForPatient(strategy, theRequestDetails, patient);
    }

    @Override
    public IBaseBundle generateIps(RequestDetails theRequestDetails, TokenParam thePatientIdentifier, String theProfile) {
        IIpsGenerationStrategy strategy = this.selectGenerationStrategy(theProfile);
        IBaseResource patient = strategy.fetchPatient(thePatientIdentifier, theRequestDetails);
        return this.generateIpsForPatient(strategy, theRequestDetails, patient);
    }

    IIpsGenerationStrategy selectGenerationStrategy(@Nullable String theRequestedProfile) {
        return this.myGenerationStrategies.stream().filter(t -> StringUtils.isBlank((CharSequence)theRequestedProfile) || theRequestedProfile.equals(t.getBundleProfile())).findFirst().orElse(this.myGenerationStrategies.get(0));
    }

    private IBaseBundle generateIpsForPatient(IIpsGenerationStrategy theStrategy, RequestDetails theRequestDetails, IBaseResource thePatient) {
        IIdType originalSubjectId = this.myFhirContext.getVersion().newIdType().setValue(thePatient.getIdElement().getValue()).toUnqualifiedVersionless();
        this.massageResourceId(theStrategy, theRequestDetails, null, thePatient);
        IpsContext context = new IpsContext(thePatient, originalSubjectId);
        ResourceInclusionCollection globalResourcesToInclude = new ResourceInclusionCollection();
        globalResourcesToInclude.addResourceIfNotAlreadyPresent(thePatient, originalSubjectId.getValue());
        IBaseResource author = theStrategy.createAuthor();
        this.massageResourceId(theStrategy, theRequestDetails, context, author);
        CompositionBuilder compositionBuilder = this.createComposition(theStrategy, thePatient, context, author);
        this.determineInclusions(theStrategy, theRequestDetails, context, compositionBuilder, globalResourcesToInclude);
        IBaseResource composition = compositionBuilder.getComposition();
        CustomThymeleafNarrativeGenerator generator = this.newNarrativeGenerator(theStrategy, globalResourcesToInclude);
        generator.populateResourceNarrative(this.myFhirContext, composition);
        return this.createDocumentBundleForComposition(theStrategy, author, composition, globalResourcesToInclude);
    }

    private IBaseBundle createDocumentBundleForComposition(IIpsGenerationStrategy theStrategy, IBaseResource author, IBaseResource composition, ResourceInclusionCollection theResourcesToInclude) {
        BundleBuilder bundleBuilder = new BundleBuilder(this.myFhirContext);
        bundleBuilder.setType(Bundle.BundleType.DOCUMENT.toCode());
        bundleBuilder.setIdentifier("urn:ietf:rfc:4122", UUID.randomUUID().toString());
        bundleBuilder.setTimestamp((IPrimitiveType)InstantType.now());
        bundleBuilder.addProfile(theStrategy.getBundleProfile());
        bundleBuilder.addDocumentEntry(composition);
        for (IBaseResource next : theResourcesToInclude.getResources()) {
            bundleBuilder.addDocumentEntry(next);
        }
        bundleBuilder.addDocumentEntry(author);
        IBaseBundle retVal = bundleBuilder.getBundle();
        theStrategy.postManipulateIpsBundle(retVal);
        return retVal;
    }

    private void determineInclusions(IIpsGenerationStrategy theStrategy, RequestDetails theRequestDetails, IpsContext theIpsContext, CompositionBuilder theCompositionBuilder, ResourceInclusionCollection theGlobalResourcesToInclude) {
        for (Section nextSection : theStrategy.getSections()) {
            this.determineInclusionsForSection(theStrategy, theRequestDetails, theIpsContext, theCompositionBuilder, theGlobalResourcesToInclude, nextSection);
        }
    }

    private void determineInclusionsForSection(IIpsGenerationStrategy theStrategy, RequestDetails theRequestDetails, IpsContext theIpsContext, CompositionBuilder theCompositionBuilder, ResourceInclusionCollection theGlobalResourceCollectionToPopulate, Section theSection) {
        ResourceInclusionCollection sectionResourceCollectionToPopulate = new ResourceInclusionCollection();
        ISectionResourceSupplier resourceSupplier = theStrategy.getSectionResourceSupplier(theSection);
        this.determineInclusionsForSectionResourceTypes(theStrategy, theRequestDetails, theIpsContext, theGlobalResourceCollectionToPopulate, theSection, resourceSupplier, sectionResourceCollectionToPopulate);
        IpsGeneratorSvcImpl.generateSectionNoInfoResourceIfNoInclusionsFound(theIpsContext, theGlobalResourceCollectionToPopulate, theSection, sectionResourceCollectionToPopulate);
        this.updateReferencesInInclusionsForSection(theGlobalResourceCollectionToPopulate);
        if (sectionResourceCollectionToPopulate.isEmpty()) {
            return;
        }
        this.addSection(theStrategy, theSection, theCompositionBuilder, sectionResourceCollectionToPopulate, theGlobalResourceCollectionToPopulate);
    }

    private void updateReferencesInInclusionsForSection(ResourceInclusionCollection theGlobalResourceCollectionToPopulate) {
        for (IBaseResource nextResource : theGlobalResourceCollectionToPopulate.getResources()) {
            List references = this.myFhirContext.newTerser().getAllResourceReferences(nextResource);
            for (ResourceReferenceInfo nextReference : references) {
                String existingReference = nextReference.getResourceReference().getReferenceElement().getValue();
                if (!StringUtils.isNotBlank((CharSequence)existingReference)) continue;
                String replacement = theGlobalResourceCollectionToPopulate.getIdSubstitution(existingReference = new IdType(existingReference).toUnqualifiedVersionless().getValue());
                if (StringUtils.isNotBlank((CharSequence)replacement)) {
                    if (replacement.equals(existingReference)) continue;
                    nextReference.getResourceReference().setReference(replacement);
                    continue;
                }
                if (theGlobalResourceCollectionToPopulate.getResourceById(existingReference) != null) continue;
                nextReference.getResourceReference().setReference(null);
                nextReference.getResourceReference().setResource(null);
            }
        }
    }

    private static void generateSectionNoInfoResourceIfNoInclusionsFound(IpsContext theIpsContext, ResourceInclusionCollection theGlobalResourceCollectionToPopulate, Section theSection, ResourceInclusionCollection sectionResourceCollectionToPopulate) {
        if (sectionResourceCollectionToPopulate.isEmpty() && theSection.getNoInfoGenerator() != null) {
            IBaseResource noInfoResource = theSection.getNoInfoGenerator().generate(theIpsContext.getSubjectId());
            String id = IdType.newRandomUuid().getValue();
            if (noInfoResource.getIdElement().isEmpty()) {
                noInfoResource.setId(id);
            }
            noInfoResource.setUserData(RESOURCE_ENTRY_INCLUSION_TYPE, (Object)ISectionResourceSupplier.InclusionTypeEnum.PRIMARY_RESOURCE);
            theGlobalResourceCollectionToPopulate.addResourceIfNotAlreadyPresent(noInfoResource, noInfoResource.getIdElement().toUnqualifiedVersionless().getValue());
            sectionResourceCollectionToPopulate.addResourceIfNotAlreadyPresent(noInfoResource, id);
        }
    }

    private void determineInclusionsForSectionResourceTypes(IIpsGenerationStrategy theStrategy, RequestDetails theRequestDetails, IpsContext theIpsContext, ResourceInclusionCollection theGlobalResourceCollectionToPopulate, Section theSection, ISectionResourceSupplier resourceSupplier, ResourceInclusionCollection sectionResourceCollectionToPopulate) {
        for (Class<? extends IBaseResource> nextResourceType : theSection.getResourceTypes()) {
            this.determineInclusionsForSectionResourceType(theStrategy, theRequestDetails, theIpsContext, theGlobalResourceCollectionToPopulate, theSection, nextResourceType, resourceSupplier, sectionResourceCollectionToPopulate);
        }
    }

    private <T extends IBaseResource> void determineInclusionsForSectionResourceType(IIpsGenerationStrategy theStrategy, RequestDetails theRequestDetails, IpsContext theIpsContext, ResourceInclusionCollection theGlobalResourceCollectionToPopulate, Section theSection, Class<T> nextResourceType, ISectionResourceSupplier resourceSupplier, ResourceInclusionCollection sectionResourceCollectionToPopulate) {
        IpsSectionContext<T> ipsSectionContext = theIpsContext.newSectionContext(theSection, nextResourceType);
        List<ISectionResourceSupplier.ResourceEntry> resources = resourceSupplier.fetchResourcesForSection(theIpsContext, ipsSectionContext, theRequestDetails);
        if (resources != null) {
            for (ISectionResourceSupplier.ResourceEntry nextEntry : resources) {
                IBaseResource resource = nextEntry.getResource();
                Validate.isTrue((boolean)resource.getIdElement().hasIdPart(), (String)"fetchResourcesForSection(..) returned resource(s) with no ID populated", (Object[])new Object[0]);
                resource.setUserData(RESOURCE_ENTRY_INCLUSION_TYPE, (Object)nextEntry.getInclusionType());
            }
            this.addResourcesToIpsContents(theStrategy, theRequestDetails, theIpsContext, resources, theGlobalResourceCollectionToPopulate, sectionResourceCollectionToPopulate);
        }
    }

    private void addResourcesToIpsContents(IIpsGenerationStrategy theStrategy, RequestDetails theRequestDetails, IpsContext theIpsContext, List<ISectionResourceSupplier.ResourceEntry> theCandidateResources, ResourceInclusionCollection theGlobalResourcesCollectionToPopulate, ResourceInclusionCollection theSectionResourceCollectionToPopulate) {
        for (ISectionResourceSupplier.ResourceEntry nextCandidateEntry : theCandidateResources) {
            if (nextCandidateEntry.getInclusionType() == ISectionResourceSupplier.InclusionTypeEnum.EXCLUDE) continue;
            IBaseResource nextCandidate = nextCandidateEntry.getResource();
            boolean primaryResource = nextCandidateEntry.getInclusionType() == ISectionResourceSupplier.InclusionTypeEnum.PRIMARY_RESOURCE;
            String originalResourceId = nextCandidate.getIdElement().toUnqualifiedVersionless().getValue();
            IBaseResource previouslyExistingResource = theGlobalResourcesCollectionToPopulate.getResourceByOriginalId(originalResourceId);
            if (previouslyExistingResource != null) {
                IpsGeneratorSvcImpl.reuseAlreadyIncludedGlobalResourceInSectionCollection(theSectionResourceCollectionToPopulate, previouslyExistingResource, primaryResource, originalResourceId);
                continue;
            }
            if (theGlobalResourcesCollectionToPopulate.hasResourceWithReplacementId(originalResourceId)) {
                IpsGeneratorSvcImpl.addResourceToSectionCollectionOnlyIfPrimary(theSectionResourceCollectionToPopulate, primaryResource, nextCandidate, originalResourceId);
                continue;
            }
            this.addResourceToGlobalCollectionAndSectionCollection(theStrategy, theRequestDetails, theIpsContext, theGlobalResourcesCollectionToPopulate, theSectionResourceCollectionToPopulate, nextCandidate, originalResourceId, primaryResource);
        }
    }

    private static void addResourceToSectionCollectionOnlyIfPrimary(ResourceInclusionCollection theSectionResourceCollectionToPopulate, boolean primaryResource, IBaseResource nextCandidate, String originalResourceId) {
        if (primaryResource) {
            theSectionResourceCollectionToPopulate.addResourceIfNotAlreadyPresent(nextCandidate, originalResourceId);
        }
    }

    private void addResourceToGlobalCollectionAndSectionCollection(IIpsGenerationStrategy theStrategy, RequestDetails theRequestDetails, IpsContext theIpsContext, ResourceInclusionCollection theGlobalResourcesCollectionToPopulate, ResourceInclusionCollection theSectionResourceCollectionToPopulate, IBaseResource nextCandidate, String originalResourceId, boolean primaryResource) {
        this.massageResourceId(theStrategy, theRequestDetails, theIpsContext, nextCandidate);
        theGlobalResourcesCollectionToPopulate.addResourceIfNotAlreadyPresent(nextCandidate, originalResourceId);
        IpsGeneratorSvcImpl.addResourceToSectionCollectionOnlyIfPrimary(theSectionResourceCollectionToPopulate, primaryResource, nextCandidate, originalResourceId);
    }

    private static void reuseAlreadyIncludedGlobalResourceInSectionCollection(ResourceInclusionCollection theSectionResourceCollectionToPopulate, IBaseResource previouslyExistingResource, boolean primaryResource, String originalResourceId) {
        ISectionResourceSupplier.InclusionTypeEnum previouslyIncludedResourceInclusionType = (ISectionResourceSupplier.InclusionTypeEnum)((Object)previouslyExistingResource.getUserData(RESOURCE_ENTRY_INCLUSION_TYPE));
        if (previouslyIncludedResourceInclusionType != ISectionResourceSupplier.InclusionTypeEnum.PRIMARY_RESOURCE && primaryResource) {
            previouslyExistingResource.setUserData(RESOURCE_ENTRY_INCLUSION_TYPE, (Object)ISectionResourceSupplier.InclusionTypeEnum.PRIMARY_RESOURCE);
        }
        IBaseResource nextCandidate = previouslyExistingResource;
        theSectionResourceCollectionToPopulate.addResourceIfNotAlreadyPresent(nextCandidate, originalResourceId);
    }

    private void addSection(IIpsGenerationStrategy theStrategy, Section theSection, CompositionBuilder theCompositionBuilder, ResourceInclusionCollection theResourcesToInclude, ResourceInclusionCollection theGlobalResourcesToInclude) {
        CompositionBuilder.SectionBuilder sectionBuilder = theCompositionBuilder.addSection();
        sectionBuilder.setTitle(theSection.getTitle());
        sectionBuilder.addCodeCoding(theSection.getSectionSystem(), theSection.getSectionCode(), theSection.getSectionDisplay());
        for (IBaseResource next : theResourcesToInclude.getResources()) {
            ISectionResourceSupplier.InclusionTypeEnum inclusionType = (ISectionResourceSupplier.InclusionTypeEnum)((Object)next.getUserData(RESOURCE_ENTRY_INCLUSION_TYPE));
            if (inclusionType != ISectionResourceSupplier.InclusionTypeEnum.PRIMARY_RESOURCE) continue;
            IBaseHasExtensions extensionHolder = (IBaseHasExtensions)next;
            if (extensionHolder.getExtension().stream().noneMatch(t -> t.getUrl().equals(URL_NARRATIVE_LINK))) {
                IBaseExtension narrativeLink = extensionHolder.addExtension();
                narrativeLink.setUrl(URL_NARRATIVE_LINK);
                String narrativeLinkValue = theCompositionBuilder.getComposition().getIdElement().getValue() + "#" + this.myFhirContext.getResourceType(next) + "-" + next.getIdElement().getValue();
                IPrimitiveType narrativeLinkUri = (IPrimitiveType)Objects.requireNonNull(this.myFhirContext.getElementDefinition("url")).newInstance();
                narrativeLinkUri.setValueAsString(narrativeLinkValue);
                narrativeLink.setValue((IBaseDatatype)narrativeLinkUri);
            }
            sectionBuilder.addEntry(next.getIdElement());
        }
        String narrative = this.createSectionNarrative(theStrategy, theSection, theResourcesToInclude, theGlobalResourcesToInclude);
        sectionBuilder.setText("generated", narrative);
    }

    private CompositionBuilder createComposition(IIpsGenerationStrategy theStrategy, IBaseResource thePatient, IpsContext context, IBaseResource author) {
        CompositionBuilder compositionBuilder = new CompositionBuilder(this.myFhirContext);
        compositionBuilder.setId((IIdType)IdType.newRandomUuid());
        compositionBuilder.setStatus(Composition.CompositionStatus.FINAL.toCode());
        compositionBuilder.setSubject(thePatient.getIdElement().toUnqualifiedVersionless());
        compositionBuilder.addTypeCoding("http://loinc.org", "60591-5", "Patient Summary Document");
        compositionBuilder.setDate((IPrimitiveType)InstantType.now());
        compositionBuilder.setTitle(theStrategy.createTitle(context));
        compositionBuilder.setConfidentiality(theStrategy.createConfidentiality(context));
        compositionBuilder.addAuthor(author.getIdElement());
        return compositionBuilder;
    }

    private void massageResourceId(IIpsGenerationStrategy theStrategy, RequestDetails theRequestDetails, IpsContext theIpsContext, IBaseResource theResource) {
        String base = theRequestDetails.getFhirServerBase();
        IIdType id = theResource.getIdElement();
        if (!id.hasBaseUrl() && id.hasResourceType() && id.hasIdPart()) {
            id = id.withServerBase(base, id.getResourceType());
            theResource.setId(id);
        }
        if ((id = theStrategy.massageResourceId(theIpsContext, theResource)) != null) {
            theResource.setId(id);
        }
    }

    private String createSectionNarrative(IIpsGenerationStrategy theStrategy, Section theSection, ResourceInclusionCollection theResources, ResourceInclusionCollection theGlobalResourceCollection) {
        CustomThymeleafNarrativeGenerator generator = this.newNarrativeGenerator(theStrategy, theGlobalResourceCollection);
        Bundle bundle = new Bundle();
        for (IBaseResource resource : theResources.getResources()) {
            ISectionResourceSupplier.InclusionTypeEnum inclusionType = (ISectionResourceSupplier.InclusionTypeEnum)((Object)resource.getUserData(RESOURCE_ENTRY_INCLUSION_TYPE));
            if (inclusionType != ISectionResourceSupplier.InclusionTypeEnum.PRIMARY_RESOURCE) continue;
            bundle.addEntry().setResource((Resource)resource);
        }
        String profile = theSection.getProfile();
        bundle.getMeta().addProfile(profile);
        return generator.generateResourceNarrative(this.myFhirContext, (IBaseResource)bundle);
    }

    @Nonnull
    private CustomThymeleafNarrativeGenerator newNarrativeGenerator(IIpsGenerationStrategy theStrategy, final ResourceInclusionCollection theGlobalResourceCollection) {
        List<String> narrativePropertyFiles = theStrategy.getNarrativePropertyFiles();
        CustomThymeleafNarrativeGenerator generator = new CustomThymeleafNarrativeGenerator(narrativePropertyFiles);
        generator.setFhirPathEvaluationContext(new IFhirPathEvaluationContext(){

            public IBase resolveReference(@Nonnull IIdType theReference, @Nullable IBase theContext) {
                return theGlobalResourceCollection.getResourceById(theReference);
            }
        });
        return generator;
    }

    private static class ResourceInclusionCollection {
        private final List<IBaseResource> myResources = new ArrayList<IBaseResource>();
        private final Map<String, IBaseResource> myIdToResource = new HashMap<String, IBaseResource>();
        private final BiMap<String, String> myOriginalIdToNewId = HashBiMap.create();

        private ResourceInclusionCollection() {
        }

        public List<IBaseResource> getResources() {
            return this.myResources;
        }

        public void addResourceIfNotAlreadyPresent(IBaseResource theResource, String theOriginalResourceId) {
            assert (theOriginalResourceId.matches("([A-Z][a-z]([A-Za-z]+)/[a-zA-Z0-9._-]+)|(urn:uuid:[0-9a-z-]+)")) : "Not an unqualified versionless ID: " + theOriginalResourceId;
            String resourceId = theResource.getIdElement().toUnqualifiedVersionless().getValue();
            if (this.myIdToResource.containsKey(resourceId)) {
                return;
            }
            this.myResources.add(theResource);
            this.myIdToResource.put(resourceId, theResource);
            this.myOriginalIdToNewId.put((Object)theOriginalResourceId, (Object)resourceId);
        }

        public String getIdSubstitution(String theExistingReference) {
            return (String)this.myOriginalIdToNewId.get((Object)theExistingReference);
        }

        public IBaseResource getResourceById(IIdType theReference) {
            return this.getResourceById(theReference.toUnqualifiedVersionless().getValue());
        }

        public boolean hasResourceWithReplacementId(String theReplacementId) {
            return this.myOriginalIdToNewId.containsValue((Object)theReplacementId);
        }

        public IBaseResource getResourceById(String theReference) {
            return this.myIdToResource.get(theReference);
        }

        @Nullable
        public IBaseResource getResourceByOriginalId(String theOriginalResourceId) {
            String newResourceId = (String)this.myOriginalIdToNewId.get((Object)theOriginalResourceId);
            if (newResourceId != null) {
                return this.myIdToResource.get(newResourceId);
            }
            return null;
        }

        public boolean isEmpty() {
            return this.myResources.isEmpty();
        }
    }
}

