/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.ips.jpa;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.ips.api.ISectionResourceSupplier;
import ca.uhn.fhir.jpa.ips.api.IpsContext;
import ca.uhn.fhir.jpa.ips.api.IpsSectionContext;
import ca.uhn.fhir.jpa.ips.jpa.IJpaSectionSearchStrategy;
import ca.uhn.fhir.jpa.ips.jpa.JpaSectionSearchStrategyCollection;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ReferenceParam;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.thymeleaf.util.Validate;

public class JpaSectionResourceSupplier
implements ISectionResourceSupplier {
    public static final int CHUNK_SIZE = 10;
    private final JpaSectionSearchStrategyCollection mySectionSearchStrategyCollection;
    private final DaoRegistry myDaoRegistry;
    private final FhirContext myFhirContext;

    public JpaSectionResourceSupplier(@Nonnull JpaSectionSearchStrategyCollection theSectionSearchStrategyCollection, @Nonnull DaoRegistry theDaoRegistry, @Nonnull FhirContext theFhirContext) {
        Validate.notNull((Object)theSectionSearchStrategyCollection, (String)"theSectionSearchStrategyCollection must not be null");
        Validate.notNull((Object)theDaoRegistry, (String)"theDaoRegistry must not be null");
        Validate.notNull((Object)theFhirContext, (String)"theFhirContext must not be null");
        this.mySectionSearchStrategyCollection = theSectionSearchStrategyCollection;
        this.myDaoRegistry = theDaoRegistry;
        this.myFhirContext = theFhirContext;
    }

    @Override
    @Nullable
    public <T extends IBaseResource> List<ISectionResourceSupplier.ResourceEntry> fetchResourcesForSection(IpsContext theIpsContext, IpsSectionContext<T> theIpsSectionContext, RequestDetails theRequestDetails) {
        int endIndex;
        List resources;
        IJpaSectionSearchStrategy<T> searchStrategy = this.mySectionSearchStrategyCollection.getSearchStrategy(theIpsSectionContext.getResourceType());
        SearchParameterMap searchParameterMap = new SearchParameterMap();
        String subjectSp = this.determinePatientCompartmentSearchParameterName(theIpsSectionContext.getResourceType());
        searchParameterMap.add(subjectSp, (IQueryParameterType)new ReferenceParam(theIpsContext.getSubjectId()));
        searchStrategy.massageResourceSearch(theIpsSectionContext, searchParameterMap);
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theIpsSectionContext.getResourceType());
        IBundleProvider searchResult = dao.search(searchParameterMap, theRequestDetails);
        ArrayList<ISectionResourceSupplier.ResourceEntry> retVal = null;
        int startIndex = 0;
        while (!(resources = searchResult.getResources(startIndex, endIndex = startIndex + 10)).isEmpty()) {
            for (IBaseResource next : resources) {
                if (next.getClass().isAssignableFrom(theIpsSectionContext.getResourceType()) && !searchStrategy.shouldInclude(theIpsSectionContext, next)) continue;
                if (retVal == null) {
                    retVal = new ArrayList<ISectionResourceSupplier.ResourceEntry>();
                }
                ISectionResourceSupplier.InclusionTypeEnum inclusionType = ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.get(next) == BundleEntrySearchModeEnum.INCLUDE ? ISectionResourceSupplier.InclusionTypeEnum.SECONDARY_RESOURCE : ISectionResourceSupplier.InclusionTypeEnum.PRIMARY_RESOURCE;
                retVal.add(new ISectionResourceSupplier.ResourceEntry(next, inclusionType));
            }
            startIndex += 10;
        }
        return retVal;
    }

    private String determinePatientCompartmentSearchParameterName(Class<? extends IBaseResource> theResourceType) {
        RuntimeResourceDefinition resourceDef = this.myFhirContext.getResourceDefinition(theResourceType);
        Set searchParams = resourceDef.getSearchParamsForCompartmentName("Patient").stream().map(RuntimeSearchParam::getName).collect(Collectors.toSet());
        if (searchParams.contains("patient")) {
            return "patient";
        }
        if (searchParams.contains("subject")) {
            return "subject";
        }
        if (searchParams.contains("beneficiary")) {
            return "subject";
        }
        return (String)searchParams.iterator().next();
    }
}

