/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.ips.jpa.section;

import ca.uhn.fhir.jpa.ips.api.IpsSectionContext;
import ca.uhn.fhir.jpa.ips.jpa.JpaSectionSearchStrategy;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import jakarta.annotation.Nonnull;
import org.hl7.fhir.r4.model.Observation;

public class PregnancyJpaSectionSearchStrategy
extends JpaSectionSearchStrategy<Observation> {
    public static final String LOINC_CODE_PREGNANCY_STATUS = "82810-3";
    public static final String LOINC_CODE_NUMBER_BIRTHS_LIVE = "11636-8";
    public static final String LOINC_CODE_NUMBER_BIRTHS_PRETERM = "11637-6";
    public static final String LOINC_CODE_NUMBER_BIRTHS_STILL_LIVING = "11638-4";
    public static final String LOINC_CODE_NUMBER_BIRTHS_TERM = "11639-2";
    public static final String LOINC_CODE_NUMBER_BIRTHS_TOTAL = "11640-0";
    public static final String LOINC_CODE_NUMBER_ABORTIONS = "11612-9";
    public static final String LOINC_CODE_NUMBER_ABORTIONS_INDUCED = "11613-7";
    public static final String LOINC_CODE_NUMBER_ABORTIONS_SPONTANEOUS = "11614-5";
    public static final String LOINC_CODE_NUMBER_ECTOPIC_PREGNANCY = "33065-4";

    @Override
    public void massageResourceSearch(@Nonnull IpsSectionContext<Observation> theIpsSectionContext, @Nonnull SearchParameterMap theSearchParameterMap) {
        theSearchParameterMap.add("code", (IQueryParameterOr)new TokenOrListParam().addOr(new TokenParam("http://loinc.org", LOINC_CODE_PREGNANCY_STATUS)).addOr(new TokenParam("http://loinc.org", LOINC_CODE_NUMBER_BIRTHS_LIVE)).addOr(new TokenParam("http://loinc.org", LOINC_CODE_NUMBER_BIRTHS_PRETERM)).addOr(new TokenParam("http://loinc.org", LOINC_CODE_NUMBER_BIRTHS_STILL_LIVING)).addOr(new TokenParam("http://loinc.org", LOINC_CODE_NUMBER_BIRTHS_TERM)).addOr(new TokenParam("http://loinc.org", LOINC_CODE_NUMBER_BIRTHS_TOTAL)).addOr(new TokenParam("http://loinc.org", LOINC_CODE_NUMBER_ABORTIONS)).addOr(new TokenParam("http://loinc.org", LOINC_CODE_NUMBER_ABORTIONS_INDUCED)).addOr(new TokenParam("http://loinc.org", LOINC_CODE_NUMBER_ABORTIONS_SPONTANEOUS)).addOr(new TokenParam("http://loinc.org", LOINC_CODE_NUMBER_ECTOPIC_PREGNANCY)));
    }

    @Override
    public boolean shouldInclude(@Nonnull IpsSectionContext<Observation> theIpsSectionContext, @Nonnull Observation theCandidate) {
        return theCandidate.getStatus() != Observation.ObservationStatus.PRELIMINARY;
    }
}

