/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.ips.provider;

import ca.uhn.fhir.jpa.ips.generator.IIpsGeneratorSvc;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.ValidateUtil;
import jakarta.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.thymeleaf.util.Validate;

public class IpsOperationProvider {
    private final IIpsGeneratorSvc myIpsGeneratorSvc;

    public IpsOperationProvider(@Nonnull IIpsGeneratorSvc theIpsGeneratorSvc) {
        Validate.notNull((Object)theIpsGeneratorSvc, (String)"theIpsGeneratorSvc must not be null");
        this.myIpsGeneratorSvc = theIpsGeneratorSvc;
    }

    @Operation(name="$summary", idempotent=true, bundleType=BundleTypeEnum.DOCUMENT, typeName="Patient", canonicalUrl="http://hl7.org/fhir/uv/ips/OperationDefinition/summary")
    public IBaseBundle patientInstanceSummary(@IdParam IIdType thePatientId, @OperationParam(name="profile", min=0, typeName="uri") IPrimitiveType<String> theProfile, RequestDetails theRequestDetails) {
        String profile = theProfile != null ? theProfile.getValueAsString() : null;
        return this.myIpsGeneratorSvc.generateIps(theRequestDetails, thePatientId, profile);
    }

    @Operation(name="$summary", idempotent=true, bundleType=BundleTypeEnum.DOCUMENT, typeName="Patient", canonicalUrl="http://hl7.org/fhir/uv/ips/OperationDefinition/summary")
    public IBaseBundle patientTypeSummary(@OperationParam(name="profile", min=0, typeName="uri") IPrimitiveType<String> theProfile, @Description(shortDefinition="When the logical id of the patient is not used, servers MAY choose to support patient selection based on provided identifier") @OperationParam(name="identifier", min=1, max=1, typeName="Identifier") IBase thePatientIdentifier, RequestDetails theRequestDetails) {
        String profile = theProfile != null ? theProfile.getValueAsString() : null;
        ValidateUtil.isTrueOrThrowInvalidRequest((thePatientIdentifier != null ? 1 : 0) != 0, (String)"No ID or identifier supplied", (Object[])new Object[0]);
        FhirTerser terser = theRequestDetails.getFhirContext().newTerser();
        String system = terser.getSinglePrimitiveValueOrNull(thePatientIdentifier, "system");
        String value = terser.getSinglePrimitiveValueOrNull(thePatientIdentifier, "value");
        return this.myIpsGeneratorSvc.generateIps(theRequestDetails, new TokenParam(system, value), profile);
    }
}

