/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.ips.strategy;

import ca.uhn.fhir.jpa.ips.api.IIpsGenerationStrategy;
import ca.uhn.fhir.jpa.ips.api.ISectionResourceSupplier;
import ca.uhn.fhir.jpa.ips.api.IpsContext;
import ca.uhn.fhir.jpa.ips.api.Section;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Organization;
import org.thymeleaf.util.Validate;

public abstract class BaseIpsGenerationStrategy
implements IIpsGenerationStrategy {
    public static final String DEFAULT_IPS_NARRATIVES_PROPERTIES = "classpath:ca/uhn/fhir/jpa/ips/narrative/ips-narratives.properties";
    private final List<Section> mySections = new ArrayList<Section>();
    private final Map<Section, ISectionResourceSupplier> mySectionToResourceSupplier = new HashMap<Section, ISectionResourceSupplier>();

    @Override
    public String getBundleProfile() {
        return "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips";
    }

    @Override
    @Nonnull
    public final List<Section> getSections() {
        return Collections.unmodifiableList(this.mySections);
    }

    @Override
    @Nonnull
    public ISectionResourceSupplier getSectionResourceSupplier(@Nonnull Section theSection) {
        return this.mySectionToResourceSupplier.get(theSection);
    }

    public void addSection(Section theSection, ISectionResourceSupplier theSectionResourceSupplier) {
        Validate.notNull((Object)theSection, (String)"theSection must not be null");
        Validate.notNull((Object)theSectionResourceSupplier, (String)"theSectionResourceSupplier must not be null");
        Validate.isTrue((!this.mySectionToResourceSupplier.containsKey(theSection) ? 1 : 0) != 0, (String)"A section with the given profile already exists");
        this.mySections.add(theSection);
        this.mySectionToResourceSupplier.put(theSection, theSectionResourceSupplier);
    }

    @Override
    public List<String> getNarrativePropertyFiles() {
        return Lists.newArrayList((Object[])new String[]{DEFAULT_IPS_NARRATIVES_PROPERTIES});
    }

    @Override
    public IBaseResource createAuthor() {
        Organization organization = new Organization();
        organization.setName("eHealthLab - University of Cyprus").addAddress(new Address().addLine("1 University Avenue").setCity("Nicosia").setPostalCode("2109").setCountry("CY")).setId((IIdType)IdType.newRandomUuid());
        return organization;
    }

    @Override
    public String createTitle(IpsContext theContext) {
        return "Patient Summary as of " + DateTimeFormatter.ofPattern("MM/dd/yyyy").format(LocalDate.now());
    }

    @Override
    public String createConfidentiality(IpsContext theIpsContext) {
        return Composition.DocumentConfidentiality.N.toCode();
    }

    @Override
    public IIdType massageResourceId(@Nullable IpsContext theIpsContext, @Nonnull IBaseResource theResource) {
        return null;
    }
}

