/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchOutcome;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.api.paging.MdmPageRequest;
import ca.uhn.fhir.mdm.dao.IMdmLinkDao;
import ca.uhn.fhir.mdm.dao.MdmLinkFactory;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class MdmLinkDaoSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private IMdmLinkDao myMdmLinkDao;
    @Autowired
    private MdmLinkFactory myMdmLinkFactory;
    @Autowired
    private IIdHelperService myIdHelperService;
    @Autowired
    private FhirContext myFhirContext;

    @Transactional
    public IMdmLink createOrUpdateLinkEntity(IAnyResource theGoldenResource, IAnyResource theSourceResource, MdmMatchOutcome theMatchOutcome, MdmLinkSourceEnum theLinkSource, @Nullable MdmTransactionContext theMdmTransactionContext) {
        IMdmLink mdmLink = this.getOrCreateMdmLinkByGoldenResourceAndSourceResource(theGoldenResource, theSourceResource);
        mdmLink.setLinkSource(theLinkSource);
        mdmLink.setMatchResult(theMatchOutcome.getMatchResultEnum());
        mdmLink.setEidMatch(Boolean.valueOf(theMatchOutcome.isEidMatch() | mdmLink.isEidMatchPresent()));
        mdmLink.setHadToCreateNewGoldenResource(Boolean.valueOf(theMatchOutcome.isCreatedNewResource() | mdmLink.getHadToCreateNewGoldenResource()));
        mdmLink.setMdmSourceType(this.myFhirContext.getResourceType((IBaseResource)theSourceResource));
        if (mdmLink.getScore() != null) {
            mdmLink.setScore(Double.valueOf(Math.max(theMatchOutcome.score, mdmLink.getScore())));
        } else {
            mdmLink.setScore(theMatchOutcome.score);
        }
        RequestPartitionId partitionId = (RequestPartitionId)theSourceResource.getUserData(Constants.RESOURCE_PARTITION_ID);
        if (partitionId != null && partitionId.getFirstPartitionIdOrNull() != null) {
            mdmLink.setPartitionId(new PartitionablePartitionId(partitionId.getFirstPartitionIdOrNull(), partitionId.getPartitionDate()));
        }
        String message = String.format("Creating %s link from %s to Golden Resource %s.", mdmLink.getMatchResult(), theSourceResource.getIdElement().toUnqualifiedVersionless(), theGoldenResource.getIdElement().toUnqualifiedVersionless());
        theMdmTransactionContext.addTransactionLogMessage(message);
        ourLog.debug(message);
        this.save(mdmLink);
        return mdmLink;
    }

    @Nonnull
    public IMdmLink getOrCreateMdmLinkByGoldenResourceAndSourceResource(IAnyResource theGoldenResource, IAnyResource theSourceResource) {
        ResourcePersistentId sourceResourcePid;
        ResourcePersistentId goldenResourcePid = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), (IBaseResource)theGoldenResource);
        Optional<? extends IMdmLink> oExisting = this.getLinkByGoldenResourcePidAndSourceResourcePid(goldenResourcePid, sourceResourcePid = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), (IBaseResource)theSourceResource));
        if (oExisting.isPresent()) {
            return oExisting.get();
        }
        IMdmLink newLink = this.myMdmLinkFactory.newMdmLink();
        newLink.setGoldenResourcePersistenceId(goldenResourcePid);
        newLink.setSourcePersistenceId(sourceResourcePid);
        return newLink;
    }

    @Deprecated
    public Optional<? extends IMdmLink> getLinkByGoldenResourcePidAndSourceResourcePid(Long theGoldenResourcePid, Long theSourceResourcePid) {
        return this.getLinkByGoldenResourcePidAndSourceResourcePid(new ResourcePersistentId((Object)theGoldenResourcePid), new ResourcePersistentId((Object)theSourceResourcePid));
    }

    public Optional<? extends IMdmLink> getLinkByGoldenResourcePidAndSourceResourcePid(ResourcePersistentId theGoldenResourcePid, ResourcePersistentId theSourceResourcePid) {
        if (theSourceResourcePid == null || theGoldenResourcePid == null) {
            return Optional.empty();
        }
        IMdmLink link = this.myMdmLinkFactory.newMdmLink();
        link.setSourcePersistenceId(theSourceResourcePid);
        link.setGoldenResourcePersistenceId(theGoldenResourcePid);
        Example example = Example.of((Object)link);
        return this.myMdmLinkDao.findOne(example);
    }

    public List<? extends IMdmLink> getMdmLinksBySourcePidAndMatchResult(ResourcePersistentId theSourcePid, MdmMatchResultEnum theMatchResult) {
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLink();
        exampleLink.setSourcePersistenceId(theSourcePid);
        exampleLink.setMatchResult(theMatchResult);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findAll(example);
    }

    @Deprecated
    @Transactional
    public Optional<? extends IMdmLink> getMatchedLinkForSourcePid(ResourcePersistentId theSourcePid) {
        return this.myMdmLinkDao.findBySourcePidAndMatchResult(theSourcePid, MdmMatchResultEnum.MATCH);
    }

    public Optional<? extends IMdmLink> getMatchedLinkForSource(IBaseResource theSourceResource) {
        return this.getMdmLinkWithMatchResult(theSourceResource, MdmMatchResultEnum.MATCH);
    }

    public Optional<? extends IMdmLink> getPossibleMatchedLinkForSource(IBaseResource theSourceResource) {
        return this.getMdmLinkWithMatchResult(theSourceResource, MdmMatchResultEnum.POSSIBLE_MATCH);
    }

    @Nonnull
    private Optional<? extends IMdmLink> getMdmLinkWithMatchResult(IBaseResource theSourceResource, MdmMatchResultEnum theMatchResult) {
        ResourcePersistentId pid = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), theSourceResource);
        if (pid == null) {
            return Optional.empty();
        }
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLink();
        exampleLink.setSourcePersistenceId(pid);
        exampleLink.setMatchResult(theMatchResult);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findOne(example);
    }

    public Optional<? extends IMdmLink> getMdmLinksByGoldenResourcePidSourcePidAndMatchResult(Long theGoldenResourcePid, Long theSourcePid, MdmMatchResultEnum theMatchResult) {
        return this.getMdmLinksByGoldenResourcePidSourcePidAndMatchResult(new ResourcePersistentId((Object)theGoldenResourcePid), new ResourcePersistentId((Object)theSourcePid), theMatchResult);
    }

    public Optional<? extends IMdmLink> getMdmLinksByGoldenResourcePidSourcePidAndMatchResult(ResourcePersistentId theGoldenResourcePid, ResourcePersistentId theSourcePid, MdmMatchResultEnum theMatchResult) {
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLink();
        exampleLink.setGoldenResourcePersistenceId(theGoldenResourcePid);
        exampleLink.setSourcePersistenceId(theSourcePid);
        exampleLink.setMatchResult(theMatchResult);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findOne(example);
    }

    public List<? extends IMdmLink> getPossibleDuplicates() {
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLink();
        exampleLink.setMatchResult(MdmMatchResultEnum.POSSIBLE_DUPLICATE);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findAll(example);
    }

    @Transactional
    public Optional<? extends IMdmLink> findMdmLinkBySource(IBaseResource theSourceResource) {
        ResourcePersistentId pid = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), theSourceResource);
        if (pid == null) {
            return Optional.empty();
        }
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLink();
        exampleLink.setSourcePersistenceId(pid);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findOne(example);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void deleteLink(IMdmLink theMdmLink) {
        this.myMdmLinkDao.validateMdmLink(theMdmLink);
        this.myMdmLinkDao.delete(theMdmLink);
    }

    @Transactional
    public List<? extends IMdmLink> findMdmLinksByGoldenResource(IBaseResource theGoldenResource) {
        ResourcePersistentId pid = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), theGoldenResource);
        if (pid == null) {
            return Collections.emptyList();
        }
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLink();
        exampleLink.setGoldenResourcePersistenceId(pid);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findAll(example);
    }

    public IMdmLink save(IMdmLink theMdmLink) {
        IMdmLink mdmLink = this.myMdmLinkDao.validateMdmLink(theMdmLink);
        if (mdmLink.getCreated() == null) {
            mdmLink.setCreated(new Date());
        }
        mdmLink.setUpdated(new Date());
        return this.myMdmLinkDao.save(mdmLink);
    }

    public Page<? extends IMdmLink> executeTypedQuery(IIdType theGoldenResourceId, IIdType theSourceId, MdmMatchResultEnum theMatchResult, MdmLinkSourceEnum theLinkSource, MdmPageRequest thePageRequest, List<Integer> thePartitionId) {
        return this.myMdmLinkDao.search(theGoldenResourceId, theSourceId, theMatchResult, theLinkSource, thePageRequest, thePartitionId);
    }

    @Transactional
    public List<? extends IMdmLink> findMdmLinksBySourceResource(IBaseResource theSourceResource) {
        ResourcePersistentId pid = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), theSourceResource);
        if (pid == null) {
            return Collections.emptyList();
        }
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLink();
        exampleLink.setSourcePersistenceId(pid);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findAll(example);
    }

    public List<? extends IMdmLink> findMdmMatchLinksByGoldenResource(IBaseResource theGoldenResource) {
        ResourcePersistentId pid = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), theGoldenResource);
        if (pid == null) {
            return Collections.emptyList();
        }
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLink();
        exampleLink.setGoldenResourcePersistenceId(pid);
        exampleLink.setMatchResult(MdmMatchResultEnum.MATCH);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findAll(example);
    }

    public IMdmLink newMdmLink() {
        return this.myMdmLinkFactory.newMdmLink();
    }

    public Optional<? extends IMdmLink> getMatchedOrPossibleMatchedLinkForSource(IAnyResource theResource) {
        Optional<? extends IMdmLink> retval = this.getMatchedLinkForSource((IBaseResource)theResource);
        if (!retval.isPresent()) {
            retval = this.getPossibleMatchedLinkForSource((IBaseResource)theResource);
        }
        return retval;
    }

    public Optional<? extends IMdmLink> getLinkByGoldenResourceAndSourceResource(@Nullable IAnyResource theGoldenResource, @Nullable IAnyResource theSourceResource) {
        if (theGoldenResource == null || theSourceResource == null) {
            return Optional.empty();
        }
        return this.getLinkByGoldenResourcePidAndSourceResourcePid(this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), (IBaseResource)theGoldenResource), this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), (IBaseResource)theSourceResource));
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteLinksWithAnyReferenceToPids(List<ResourcePersistentId> theGoldenResourcePids) {
        this.myMdmLinkDao.deleteLinksWithAnyReferenceToPids(theGoldenResourcePids);
    }
}

