/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.mdm.dao.MdmLinkDaoSvc;
import ca.uhn.fhir.jpa.mdm.svc.MdmResourceDaoSvc;
import ca.uhn.fhir.jpa.mdm.util.MdmPartitionHelper;
import ca.uhn.fhir.mdm.api.IGoldenResourceMergerSvc;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.IMdmLinkSvc;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.util.GoldenResourceHelper;
import ca.uhn.fhir.mdm.util.MdmResourceUtil;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoldenResourceMergerSvcImpl
implements IGoldenResourceMergerSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    GoldenResourceHelper myGoldenResourceHelper;
    @Autowired
    MdmLinkDaoSvc myMdmLinkDaoSvc;
    @Autowired
    IMdmLinkSvc myMdmLinkSvc;
    @Autowired
    IIdHelperService myIdHelperService;
    @Autowired
    MdmResourceDaoSvc myMdmResourceDaoSvc;
    @Autowired
    MdmPartitionHelper myMdmPartitionHelper;

    @Transactional
    public IAnyResource mergeGoldenResources(IAnyResource theFromGoldenResource, IAnyResource theMergedResource, IAnyResource theToGoldenResource, MdmTransactionContext theMdmTransactionContext) {
        String resourceType = theMdmTransactionContext.getResourceType();
        if (theMergedResource != null) {
            if (this.myGoldenResourceHelper.hasIdentifier((IBaseResource)theMergedResource)) {
                throw new IllegalArgumentException(Msg.code((int)751) + "Manually merged resource can not contain identifiers");
            }
            this.myGoldenResourceHelper.mergeIndentifierFields((IBaseResource)theFromGoldenResource, (IBaseResource)theMergedResource, theMdmTransactionContext);
            this.myGoldenResourceHelper.mergeIndentifierFields((IBaseResource)theToGoldenResource, (IBaseResource)theMergedResource, theMdmTransactionContext);
            theMergedResource.setId(theToGoldenResource.getId());
            theToGoldenResource = (IAnyResource)this.myMdmResourceDaoSvc.upsertGoldenResource(theMergedResource, resourceType).getResource();
        } else {
            this.myGoldenResourceHelper.mergeIndentifierFields((IBaseResource)theFromGoldenResource, (IBaseResource)theToGoldenResource, theMdmTransactionContext);
            this.myGoldenResourceHelper.mergeNonIdentiferFields((IBaseResource)theFromGoldenResource, (IBaseResource)theToGoldenResource, theMdmTransactionContext);
            this.myMdmResourceDaoSvc.upsertGoldenResource(theToGoldenResource, resourceType);
        }
        this.myMdmPartitionHelper.validateResourcesInSamePartition(theFromGoldenResource, theToGoldenResource);
        this.mergeGoldenResourceLinks(theFromGoldenResource, theToGoldenResource, theFromGoldenResource.getIdElement(), theMdmTransactionContext);
        this.addMergeLink(theToGoldenResource, theFromGoldenResource, resourceType);
        this.myMdmResourceDaoSvc.removeGoldenResourceTag(theFromGoldenResource, resourceType);
        MdmResourceUtil.setGoldenResourceRedirected((IBaseResource)theFromGoldenResource);
        this.myMdmResourceDaoSvc.upsertGoldenResource(theFromGoldenResource, resourceType);
        this.log(theMdmTransactionContext, "Merged " + theFromGoldenResource.getIdElement().toVersionless() + " into " + theToGoldenResource.getIdElement().toVersionless());
        return theToGoldenResource;
    }

    private void addMergeLink(IAnyResource theGoldenResource, IAnyResource theTargetResource, String theResourceType) {
        IMdmLink mdmLink = this.myMdmLinkDaoSvc.getOrCreateMdmLinkByGoldenResourceAndSourceResource(theGoldenResource, theTargetResource);
        mdmLink.setMdmSourceType(theResourceType).setMatchResult(MdmMatchResultEnum.REDIRECT).setLinkSource(MdmLinkSourceEnum.MANUAL);
        this.myMdmLinkDaoSvc.save(mdmLink);
    }

    private void mergeGoldenResourceLinks(IAnyResource theFromResource, IAnyResource theToResource, IIdType theToResourcePid, MdmTransactionContext theMdmTransactionContext) {
        List<? extends IMdmLink> fromLinks = this.myMdmLinkDaoSvc.findMdmLinksByGoldenResource((IBaseResource)theFromResource);
        List<? extends IMdmLink> toLinks = this.myMdmLinkDaoSvc.findMdmLinksByGoldenResource((IBaseResource)theToResource);
        ArrayList<IMdmLink> toDelete = new ArrayList<IMdmLink>();
        ResourcePersistentId goldenResourcePid = this.myIdHelperService.resolveResourcePersistentIds((RequestPartitionId)theToResource.getUserData(Constants.RESOURCE_PARTITION_ID), theToResource.getIdElement().getResourceType(), theToResource.getIdElement().getIdPart());
        for (IMdmLink iMdmLink : fromLinks) {
            Optional<? extends IMdmLink> optionalToLink = this.findFirstLinkWithMatchingSource(toLinks, iMdmLink);
            if (optionalToLink.isPresent()) {
                IMdmLink toLink = optionalToLink.get();
                if (iMdmLink.isManual()) {
                    switch (toLink.getLinkSource()) {
                        case AUTO: {
                            this.log(theMdmTransactionContext, String.format("MANUAL overrides AUT0.  Deleting link %s", toLink.toString()));
                            this.myMdmLinkDaoSvc.deleteLink(toLink);
                            break;
                        }
                        case MANUAL: {
                            if (iMdmLink.getMatchResult() == toLink.getMatchResult()) break;
                            throw new InvalidRequestException(Msg.code((int)752) + "A MANUAL " + iMdmLink.getMatchResult() + " link may not be merged into a MANUAL " + toLink.getMatchResult() + " link for the same target");
                        }
                    }
                } else {
                    toDelete.add(iMdmLink);
                    continue;
                }
            }
            iMdmLink.setGoldenResourcePersistenceId(goldenResourcePid);
            ourLog.trace("Saving link {}", (Object)iMdmLink);
            this.myMdmLinkDaoSvc.save(iMdmLink);
        }
        toDelete.forEach(link -> this.myMdmLinkDaoSvc.deleteLink((IMdmLink)link));
    }

    private Optional<? extends IMdmLink> findFirstLinkWithMatchingSource(List<? extends IMdmLink> theMdmLinks, IMdmLink theLinkWithSourceToMatch) {
        return theMdmLinks.stream().filter(mdmLink -> mdmLink.getSourcePersistenceId().equals((Object)theLinkWithSourceToMatch.getSourcePersistenceId())).findFirst();
    }

    private void log(MdmTransactionContext theMdmTransactionContext, String theMessage) {
        theMdmTransactionContext.addTransactionLogMessage(theMessage);
        ourLog.debug(theMessage);
    }
}

