/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.jpa.mdm.svc.MdmEidUpdateService;
import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateList;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MatchedGoldenResourceCandidate;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MdmGoldenResourceFindingSvc;
import ca.uhn.fhir.mdm.api.IMdmLinkSvc;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchOutcome;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.util.GoldenResourceHelper;
import ca.uhn.fhir.mdm.util.MdmResourceUtil;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.ArrayList;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MdmMatchLinkSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private IMdmLinkSvc myMdmLinkSvc;
    @Autowired
    private MdmGoldenResourceFindingSvc myMdmGoldenResourceFindingSvc;
    @Autowired
    private GoldenResourceHelper myGoldenResourceHelper;
    @Autowired
    private MdmEidUpdateService myEidUpdateService;

    @Transactional
    public MdmTransactionContext updateMdmLinksForMdmSource(IAnyResource theResource, MdmTransactionContext theMdmTransactionContext) {
        if (MdmResourceUtil.isMdmAllowed((IBaseResource)theResource)) {
            return this.doMdmUpdate(theResource, theMdmTransactionContext);
        }
        return null;
    }

    private MdmTransactionContext doMdmUpdate(IAnyResource theResource, MdmTransactionContext theMdmTransactionContext) {
        CandidateList candidateList = this.myMdmGoldenResourceFindingSvc.findGoldenResourceCandidates(theResource);
        if (candidateList.isEmpty()) {
            this.handleMdmWithNoCandidates(theResource, theMdmTransactionContext);
        } else if (candidateList.exactlyOneMatch()) {
            this.handleMdmWithSingleCandidate(theResource, candidateList.getOnlyMatch(), theMdmTransactionContext);
        } else {
            this.handleMdmWithMultipleCandidates(theResource, candidateList, theMdmTransactionContext);
        }
        return theMdmTransactionContext;
    }

    private void handleMdmWithMultipleCandidates(IAnyResource theResource, CandidateList theCandidateList, MdmTransactionContext theMdmTransactionContext) {
        MatchedGoldenResourceCandidate firstMatch = theCandidateList.getFirstMatch();
        ResourcePersistentId sampleGoldenResourcePid = firstMatch.getCandidateGoldenResourcePid();
        boolean allSameGoldenResource = theCandidateList.stream().allMatch(candidate -> candidate.getCandidateGoldenResourcePid().equals((Object)sampleGoldenResourcePid));
        if (allSameGoldenResource) {
            this.log(theMdmTransactionContext, "MDM received multiple match candidates, but they are all linked to the same Golden Resource.");
            this.handleMdmWithSingleCandidate(theResource, firstMatch, theMdmTransactionContext);
        } else {
            this.log(theMdmTransactionContext, "MDM received multiple match candidates, that were linked to different Golden Resources. Setting POSSIBLE_DUPLICATES and POSSIBLE_MATCHES.");
            ArrayList<IAnyResource> goldenResources = new ArrayList<IAnyResource>();
            for (MatchedGoldenResourceCandidate matchedGoldenResourceCandidate : theCandidateList.getCandidates()) {
                IAnyResource goldenResource = this.myMdmGoldenResourceFindingSvc.getGoldenResourceFromMatchedGoldenResourceCandidate(matchedGoldenResourceCandidate, theMdmTransactionContext.getResourceType());
                MdmMatchOutcome outcome = MdmMatchOutcome.POSSIBLE_MATCH;
                outcome.setEidMatch(theCandidateList.isEidMatch());
                this.myMdmLinkSvc.updateLink(goldenResource, theResource, outcome, MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
                goldenResources.add(goldenResource);
            }
            IAnyResource firstGoldenResource = (IAnyResource)goldenResources.get(0);
            goldenResources.subList(1, goldenResources.size()).forEach(possibleDuplicateGoldenResource -> {
                MdmMatchOutcome outcome = MdmMatchOutcome.POSSIBLE_DUPLICATE;
                outcome.setEidMatch(theCandidateList.isEidMatch());
                this.myMdmLinkSvc.updateLink(firstGoldenResource, possibleDuplicateGoldenResource, outcome, MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
            });
        }
    }

    private void handleMdmWithNoCandidates(IAnyResource theResource, MdmTransactionContext theMdmTransactionContext) {
        this.log(theMdmTransactionContext, String.format("There were no matched candidates for MDM, creating a new %s Golden Resource.", theResource.getIdElement().getResourceType()));
        IAnyResource newGoldenResource = this.myGoldenResourceHelper.createGoldenResourceFromMdmSourceResource(theResource, theMdmTransactionContext);
        this.myMdmLinkSvc.updateLink(newGoldenResource, theResource, MdmMatchOutcome.NEW_GOLDEN_RESOURCE_MATCH, MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
    }

    private void handleMdmCreate(IAnyResource theTargetResource, MatchedGoldenResourceCandidate theGoldenResourceCandidate, MdmTransactionContext theMdmTransactionContext) {
        IAnyResource goldenResource = this.myMdmGoldenResourceFindingSvc.getGoldenResourceFromMatchedGoldenResourceCandidate(theGoldenResourceCandidate, theMdmTransactionContext.getResourceType());
        if (this.myGoldenResourceHelper.isPotentialDuplicate(goldenResource, theTargetResource)) {
            this.log(theMdmTransactionContext, "Duplicate detected based on the fact that both resources have different external EIDs.");
            IAnyResource newGoldenResource = this.myGoldenResourceHelper.createGoldenResourceFromMdmSourceResource(theTargetResource, theMdmTransactionContext);
            this.myMdmLinkSvc.updateLink(newGoldenResource, theTargetResource, MdmMatchOutcome.NEW_GOLDEN_RESOURCE_MATCH, MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
            this.myMdmLinkSvc.updateLink(newGoldenResource, goldenResource, MdmMatchOutcome.POSSIBLE_DUPLICATE, MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
        } else {
            this.log(theMdmTransactionContext, "MDM has narrowed down to one candidate for matching.");
            if (theGoldenResourceCandidate.isMatch()) {
                this.myGoldenResourceHelper.handleExternalEidAddition(goldenResource, theTargetResource, theMdmTransactionContext);
                this.myEidUpdateService.applySurvivorshipRulesAndSaveGoldenResource(theTargetResource, goldenResource, theMdmTransactionContext);
            }
            this.myMdmLinkSvc.updateLink(goldenResource, theTargetResource, theGoldenResourceCandidate.getMatchResult(), MdmLinkSourceEnum.AUTO, theMdmTransactionContext);
        }
    }

    private void handleMdmWithSingleCandidate(IAnyResource theResource, MatchedGoldenResourceCandidate theGoldenResourceCandidate, MdmTransactionContext theMdmTransactionContext) {
        if (theMdmTransactionContext.getRestOperation().equals((Object)MdmTransactionContext.OperationType.UPDATE_RESOURCE)) {
            this.log(theMdmTransactionContext, "MDM has narrowed down to one candidate for matching.");
            this.myEidUpdateService.handleMdmUpdate(theResource, theGoldenResourceCandidate, theMdmTransactionContext);
        } else {
            this.handleMdmCreate(theResource, theGoldenResourceCandidate, theMdmTransactionContext);
        }
    }

    private void log(MdmTransactionContext theMdmTransactionContext, String theMessage) {
        theMdmTransactionContext.addTransactionLogMessage(theMessage);
        ourLog.debug(theMessage);
    }
}

