/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.mdm.svc.IMdmModelConverterSvc;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.MdmLinkJson;
import org.springframework.beans.factory.annotation.Autowired;

public class MdmModelConverterSvcImpl
implements IMdmModelConverterSvc {
    @Autowired
    IIdHelperService myIdHelperService;

    @Override
    public MdmLinkJson toJson(IMdmLink theLink) {
        MdmLinkJson retVal = new MdmLinkJson();
        String sourceId = this.myIdHelperService.resourceIdFromPidOrThrowException(theLink.getSourcePersistenceId(), theLink.getMdmSourceType()).toVersionless().getValue();
        retVal.setSourceId(sourceId);
        String goldenResourceId = this.myIdHelperService.resourceIdFromPidOrThrowException(theLink.getGoldenResourcePersistenceId(), theLink.getMdmSourceType()).toVersionless().getValue();
        retVal.setGoldenResourceId(goldenResourceId);
        retVal.setCreated(theLink.getCreated());
        retVal.setEidMatch(theLink.getEidMatch());
        retVal.setLinkSource(theLink.getLinkSource());
        retVal.setMatchResult(theLink.getMatchResult());
        retVal.setLinkCreatedNewResource(theLink.getHadToCreateNewGoldenResource());
        retVal.setScore(theLink.getScore());
        retVal.setUpdated(theLink.getUpdated());
        retVal.setVector(theLink.getVector());
        retVal.setVersion(theLink.getVersion());
        retVal.setRuleCount(theLink.getRuleCount());
        return retVal;
    }
}

