/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc.candidate;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateSearcher;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MdmCandidateSearchCriteriaBuilderSvc;
import ca.uhn.fhir.jpa.mdm.svc.candidate.TooManyCandidatesException;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.rules.json.MdmFilterSearchParamJson;
import ca.uhn.fhir.mdm.rules.json.MdmResourceSearchParamJson;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MdmCandidateSearchSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private IMdmSettings myMdmSettings;
    @Autowired
    private IIdHelperService myIdHelperService;
    @Autowired
    private MdmCandidateSearchCriteriaBuilderSvc myMdmCandidateSearchCriteriaBuilderSvc;
    @Autowired
    private CandidateSearcher myCandidateSearcher;

    @Transactional
    public Collection<IAnyResource> findCandidates(String theResourceType, IAnyResource theResource, RequestPartitionId theRequestPartitionId) {
        HashMap<ResourcePersistentId, IAnyResource> matchedPidsToResources = new HashMap<ResourcePersistentId, IAnyResource>();
        List filterSearchParams = this.myMdmSettings.getMdmRules().getCandidateFilterSearchParams();
        List<String> filterCriteria = this.buildFilterQuery(filterSearchParams, theResourceType);
        List candidateSearchParams = this.myMdmSettings.getMdmRules().getCandidateSearchParams();
        if (candidateSearchParams.isEmpty()) {
            this.searchForIdsAndAddToMap(theResourceType, theResource, matchedPidsToResources, filterCriteria, null, theRequestPartitionId);
        } else {
            for (MdmResourceSearchParamJson resourceSearchParam : candidateSearchParams) {
                if (!this.isSearchParamForResource(theResourceType, resourceSearchParam)) continue;
                this.searchForIdsAndAddToMap(theResourceType, theResource, matchedPidsToResources, filterCriteria, resourceSearchParam, theRequestPartitionId);
            }
        }
        if (theResource.getIdElement().getIdPart() != null && matchedPidsToResources.remove(this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), (IBaseResource)theResource)) != null) {
            ourLog.debug("Removing incoming resource {} from list of candidates.", (Object)theResource.getIdElement().toUnqualifiedVersionless());
        }
        ourLog.info("Candidate search found {} matching resources for {}", (Object)matchedPidsToResources.size(), (Object)CandidateSearcher.idOrType(theResource, theResourceType));
        return matchedPidsToResources.values();
    }

    private boolean isSearchParamForResource(String theResourceType, MdmResourceSearchParamJson resourceSearchParam) {
        String resourceType = resourceSearchParam.getResourceType();
        return resourceType.equals(theResourceType) || resourceType.equalsIgnoreCase("*");
    }

    private void searchForIdsAndAddToMap(String theResourceType, IAnyResource theResource, Map<ResourcePersistentId, IAnyResource> theMatchedPidsToResources, List<String> theFilterCriteria, MdmResourceSearchParamJson resourceSearchParam, RequestPartitionId theRequestPartitionId) {
        Optional<String> oResourceCriteria = this.myMdmCandidateSearchCriteriaBuilderSvc.buildResourceQueryString(theResourceType, theResource, theFilterCriteria, resourceSearchParam);
        if (!oResourceCriteria.isPresent()) {
            return;
        }
        String resourceCriteria = oResourceCriteria.get();
        ourLog.debug("Searching for {} candidates with {}", (Object)theResourceType, (Object)resourceCriteria);
        Optional<IBundleProvider> bundleProvider = this.myCandidateSearcher.search(theResourceType, resourceCriteria, theRequestPartitionId);
        if (!bundleProvider.isPresent()) {
            throw new TooManyCandidatesException(Msg.code((int)762) + "More than " + this.myMdmSettings.getCandidateSearchLimit() + " candidate matches found for " + resourceCriteria + ".  Aborting mdm matching.");
        }
        List resources = bundleProvider.get().getAllResources();
        int initialSize = theMatchedPidsToResources.size();
        resources.forEach(resource -> theMatchedPidsToResources.put(this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), resource), (IAnyResource)resource));
        int newSize = theMatchedPidsToResources.size();
        if (ourLog.isDebugEnabled()) {
            ourLog.debug("Candidate search added {} {}s", (Object)(newSize - initialSize), (Object)theResourceType);
        }
    }

    private List<String> buildFilterQuery(List<MdmFilterSearchParamJson> theFilterSearchParams, String theResourceType) {
        return Collections.unmodifiableList(theFilterSearchParams.stream().filter(spFilterJson -> this.paramIsOnCorrectType(theResourceType, (MdmFilterSearchParamJson)spFilterJson)).map(this::convertToQueryString).collect(Collectors.toList()));
    }

    private boolean paramIsOnCorrectType(String theResourceType, MdmFilterSearchParamJson spFilterJson) {
        return spFilterJson.getResourceType().equals(theResourceType) || spFilterJson.getResourceType().equalsIgnoreCase("*");
    }

    private String convertToQueryString(MdmFilterSearchParamJson theSpFilterJson) {
        String qualifier = theSpFilterJson.getTokenParamModifierAsString();
        return theSpFilterJson.getSearchParam() + qualifier + "=" + theSpFilterJson.getFixedValue();
    }
}

