/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.config;

import ca.uhn.fhir.jpa.mdm.config.MdmSubscriptionLoader;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.provider.MdmProviderLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
public class MdmLoader {
    private static final Logger ourLog = LoggerFactory.getLogger(MdmLoader.class);
    @Autowired
    IMdmSettings myMdmSettings;
    @Autowired
    MdmProviderLoader myMdmProviderLoader;
    @Autowired
    MdmSubscriptionLoader myMdmSubscriptionLoader;

    @EventListener(classes={ContextRefreshedEvent.class})
    @Order(value=310)
    public void updateSubscriptions() {
        if (!this.myMdmSettings.isEnabled()) {
            return;
        }
        this.myMdmProviderLoader.loadProvider();
        ourLog.info("MDM provider registered");
        this.myMdmSubscriptionLoader.daoUpdateMdmSubscriptions();
        ourLog.info("MDM subscriptions updated");
    }
}

