/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.config;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.subscription.channel.api.ChannelProducerSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelSettings;
import ca.uhn.fhir.jpa.subscription.channel.subscription.IChannelNamer;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionLoader;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.Subscription;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.Type;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmSubscriptionLoader {
    public static final String MDM_SUBSCIPRION_ID_PREFIX = "mdm-";
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    public FhirContext myFhirContext;
    @Autowired
    public DaoRegistry myDaoRegistry;
    @Autowired
    IChannelNamer myChannelNamer;
    @Autowired
    private SubscriptionLoader mySubscriptionLoader;
    @Autowired
    private IMdmSettings myMdmSettings;
    private IFhirResourceDao<IBaseResource> mySubscriptionDao;

    public synchronized void daoUpdateMdmSubscriptions() {
        List subscriptions;
        List mdmResourceTypes = this.myMdmSettings.getMdmRules().getMdmTypes();
        switch (this.myFhirContext.getVersion().getVersion()) {
            case DSTU3: {
                subscriptions = mdmResourceTypes.stream().map(resourceType -> this.buildMdmSubscriptionDstu3(MDM_SUBSCIPRION_ID_PREFIX + resourceType, resourceType + "?")).collect(Collectors.toList());
                break;
            }
            case R4: {
                subscriptions = mdmResourceTypes.stream().map(resourceType -> this.buildMdmSubscriptionR4(MDM_SUBSCIPRION_ID_PREFIX + resourceType, resourceType + "?")).collect(Collectors.toList());
                break;
            }
            default: {
                throw new ConfigurationException(Msg.code((int)736) + "MDM not supported for FHIR version " + this.myFhirContext.getVersion().getVersion());
            }
        }
        this.mySubscriptionDao = this.myDaoRegistry.getResourceDao("Subscription");
        for (IBaseResource subscription : subscriptions) {
            this.updateIfNotPresent(subscription);
        }
        if (subscriptions != null && subscriptions.size() > 0) {
            this.mySubscriptionLoader.syncSubscriptions();
        }
    }

    synchronized void updateIfNotPresent(IBaseResource theSubscription) {
        try {
            this.mySubscriptionDao.read(theSubscription.getIdElement(), (RequestDetails)SystemRequestDetails.forAllPartitions());
        }
        catch (ResourceGoneException | ResourceNotFoundException e) {
            ourLog.info("Creating subscription " + theSubscription.getIdElement());
            this.mySubscriptionDao.update(theSubscription, (RequestDetails)SystemRequestDetails.forAllPartitions());
        }
    }

    private org.hl7.fhir.dstu3.model.Subscription buildMdmSubscriptionDstu3(String theId, String theCriteria) {
        org.hl7.fhir.dstu3.model.Subscription retval = new org.hl7.fhir.dstu3.model.Subscription();
        retval.setId(theId);
        retval.setReason("MDM");
        retval.setStatus(Subscription.SubscriptionStatus.REQUESTED);
        retval.setCriteria(theCriteria);
        retval.getMeta().addTag().setSystem("https://hapifhir.org/NamingSystem/managing-mdm-system").setCode("HAPI-MDM");
        retval.addExtension().setUrl("https://smilecdr.com/fhir/ns/StructureDefinition/subscription-cross-partition").setValue((org.hl7.fhir.dstu3.model.Type)new org.hl7.fhir.dstu3.model.BooleanType().setValue((Object)true));
        Subscription.SubscriptionChannelComponent channel = retval.getChannel();
        channel.setType(Subscription.SubscriptionChannelType.MESSAGE);
        channel.setEndpoint("channel:" + this.myChannelNamer.getChannelName("empi", (IChannelSettings)new ChannelProducerSettings()));
        channel.setPayload("application/json");
        return retval;
    }

    private Subscription buildMdmSubscriptionR4(String theId, String theCriteria) {
        Subscription retval = new Subscription();
        retval.setId(theId);
        retval.setReason("MDM");
        retval.setStatus(Subscription.SubscriptionStatus.REQUESTED);
        retval.setCriteria(theCriteria);
        retval.getMeta().addTag().setSystem("https://hapifhir.org/NamingSystem/managing-mdm-system").setCode("HAPI-MDM");
        retval.addExtension().setUrl("https://smilecdr.com/fhir/ns/StructureDefinition/subscription-cross-partition").setValue((Type)new BooleanType().setValue((Object)true));
        Subscription.SubscriptionChannelComponent channel = retval.getChannel();
        channel.setType(Subscription.SubscriptionChannelType.MESSAGE);
        channel.setEndpoint("channel:" + this.myChannelNamer.getChannelName("empi", (IChannelSettings)new ChannelProducerSettings()));
        channel.setPayload("application/json");
        return retval;
    }
}

