/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.pid.HomogeneousResourcePidList;
import ca.uhn.fhir.jpa.api.pid.IResourcePidList;
import ca.uhn.fhir.jpa.api.svc.IGoldenResourceSearchSvc;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.util.DateRangeUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class GoldenResourceSearchSvcImpl
implements IGoldenResourceSearchSvc {
    @Autowired
    private MatchUrlService myMatchUrlService;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private FhirContext myFhirContext;

    @Transactional
    public IResourcePidList fetchGoldenResourceIdsPage(Date theStart, Date theEnd, @Nonnull Integer thePageSize, @Nullable RequestPartitionId theRequestPartitionId, @Nonnull String theResourceType) {
        return this.fetchResourceIdsPageWithResourceType(theStart, theEnd, thePageSize, theResourceType, theRequestPartitionId);
    }

    private IResourcePidList fetchResourceIdsPageWithResourceType(Date theStart, Date theEnd, int thePageSize, String theResourceType, RequestPartitionId theRequestPartitionId) {
        RuntimeResourceDefinition def = this.myFhirContext.getResourceDefinition(theResourceType);
        SearchParameterMap searchParamMap = this.myMatchUrlService.translateMatchUrl(theResourceType, def, new MatchUrlService.Flag[0]);
        searchParamMap.setSort(new SortSpec("_lastUpdated", SortOrderEnum.ASC));
        DateRangeParam chunkDateRange = DateRangeUtil.narrowDateRange((DateRangeParam)searchParamMap.getLastUpdated(), (Date)theStart, (Date)theEnd);
        searchParamMap.setLastUpdated(chunkDateRange);
        searchParamMap.setCount(Integer.valueOf(thePageSize));
        searchParamMap.add("_tag", (IQueryParameterType)new TokenParam("http://hapifhir.io/fhir/NamingSystem/mdm-record-status", "GOLDEN_RECORD"));
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResourceType);
        SystemRequestDetails request = new SystemRequestDetails();
        request.setRequestPartitionId(theRequestPartitionId);
        List ids = dao.searchForIds(searchParamMap, (RequestDetails)request);
        Date lastDate = null;
        if (ids.size() > 0) {
            lastDate = dao.readByPid((IResourcePersistentId)ids.get(ids.size() - 1)).getMeta().getLastUpdated();
        }
        return new HomogeneousResourcePidList(theResourceType, (Collection)ids, lastDate);
    }
}

