/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.mdm.dao.MdmLinkDaoSvc;
import ca.uhn.fhir.jpa.mdm.util.MdmPartitionHelper;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.mdm.api.IMdmLinkCreateSvc;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.util.MdmResourceUtil;
import ca.uhn.fhir.mdm.util.MessageHelper;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class MdmLinkCreateSvcImpl
implements IMdmLinkCreateSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    FhirContext myFhirContext;
    @Autowired
    IIdHelperService myIdHelperService;
    @Autowired
    MdmLinkDaoSvc myMdmLinkDaoSvc;
    @Autowired
    IMdmSettings myMdmSettings;
    @Autowired
    MessageHelper myMessageHelper;
    @Autowired
    MdmPartitionHelper myMdmPartitionHelper;

    @Transactional
    public IAnyResource createLink(IAnyResource theGoldenResource, IAnyResource theSourceResource, MdmMatchResultEnum theMatchResult, MdmTransactionContext theMdmContext) {
        String sourceType = this.myFhirContext.getResourceType((IBaseResource)theSourceResource);
        this.validateCreateLinkRequest(theGoldenResource, theSourceResource, sourceType);
        IResourcePersistentId goldenResourceId = this.myIdHelperService.getPidOrThrowException(theGoldenResource);
        IResourcePersistentId targetId = this.myIdHelperService.getPidOrThrowException(theSourceResource);
        this.myMdmPartitionHelper.validateResourcesInSamePartition(theGoldenResource, theSourceResource);
        Optional optionalMdmLink = this.myMdmLinkDaoSvc.getLinkByGoldenResourcePidAndSourceResourcePid(goldenResourceId, targetId);
        if (optionalMdmLink.isPresent()) {
            throw new InvalidRequestException(Msg.code((int)753) + this.myMessageHelper.getMessageForPresentLink(theGoldenResource, theSourceResource));
        }
        List mdmLinks = this.myMdmLinkDaoSvc.getMdmLinksBySourcePidAndMatchResult(targetId, MdmMatchResultEnum.MATCH);
        if (mdmLinks.size() > 0 && theMatchResult == MdmMatchResultEnum.MATCH) {
            throw new InvalidRequestException(Msg.code((int)754) + this.myMessageHelper.getMessageForMultipleGoldenRecords(theSourceResource));
        }
        Object mdmLink = this.myMdmLinkDaoSvc.getOrCreateMdmLinkByGoldenResourceAndSourceResource(theGoldenResource, theSourceResource);
        mdmLink.setLinkSource(MdmLinkSourceEnum.MANUAL);
        mdmLink.setMdmSourceType(sourceType);
        if (theMatchResult == null) {
            mdmLink.setMatchResult(MdmMatchResultEnum.MATCH);
        } else {
            mdmLink.setMatchResult(theMatchResult);
        }
        RequestPartitionId goldenResourcePartitionId = (RequestPartitionId)theGoldenResource.getUserData(Constants.RESOURCE_PARTITION_ID);
        if (goldenResourcePartitionId != null && goldenResourcePartitionId.hasPartitionIds() && goldenResourcePartitionId.getFirstPartitionIdOrNull() != null && (mdmLink.getPartitionId() == null || mdmLink.getPartitionId().getPartitionId() == null)) {
            mdmLink.setPartitionId(new PartitionablePartitionId(goldenResourcePartitionId.getFirstPartitionIdOrNull(), goldenResourcePartitionId.getPartitionDate()));
        }
        ourLog.info("Manually creating a " + theGoldenResource.getIdElement().toVersionless() + " to " + theSourceResource.getIdElement().toVersionless() + " mdm link.");
        this.myMdmLinkDaoSvc.save(mdmLink);
        return theGoldenResource;
    }

    private void validateCreateLinkRequest(IAnyResource theGoldenRecord, IAnyResource theSourceResource, String theSourceType) {
        String goldenRecordType = this.myFhirContext.getResourceType((IBaseResource)theGoldenRecord);
        if (!this.myMdmSettings.isSupportedMdmType(goldenRecordType)) {
            throw new InvalidRequestException(Msg.code((int)755) + this.myMessageHelper.getMessageForUnsupportedFirstArgumentTypeInUpdate(goldenRecordType));
        }
        if (!this.myMdmSettings.isSupportedMdmType(theSourceType)) {
            throw new InvalidRequestException(Msg.code((int)756) + this.myMessageHelper.getMessageForUnsupportedSecondArgumentTypeInUpdate(theSourceType));
        }
        if (!Objects.equals(goldenRecordType, theSourceType)) {
            throw new InvalidRequestException(Msg.code((int)757) + this.myMessageHelper.getMessageForArgumentTypeMismatchInUpdate(goldenRecordType, theSourceType));
        }
        if (!MdmResourceUtil.isMdmManaged((IBaseResource)theGoldenRecord)) {
            throw new InvalidRequestException(Msg.code((int)758) + this.myMessageHelper.getMessageForUnmanagedResource());
        }
        if (!MdmResourceUtil.isMdmAllowed((IBaseResource)theSourceResource)) {
            throw new InvalidRequestException(Msg.code((int)759) + this.myMessageHelper.getMessageForUnsupportedSourceResource());
        }
    }
}

