/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.mdm.dao.MdmLinkDaoSvc;
import ca.uhn.fhir.jpa.mdm.svc.MdmMatchLinkSvc;
import ca.uhn.fhir.jpa.mdm.svc.MdmResourceDaoSvc;
import ca.uhn.fhir.jpa.mdm.util.MdmPartitionHelper;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.IMdmLinkUpdaterSvc;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.IMdmSurvivorshipService;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.util.MdmResourceUtil;
import ca.uhn.fhir.mdm.util.MessageHelper;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class MdmLinkUpdaterSvcImpl
implements IMdmLinkUpdaterSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    FhirContext myFhirContext;
    @Autowired
    IIdHelperService myIdHelperService;
    @Autowired
    MdmLinkDaoSvc myMdmLinkDaoSvc;
    @Autowired
    MdmResourceDaoSvc myMdmResourceDaoSvc;
    @Autowired
    MdmMatchLinkSvc myMdmMatchLinkSvc;
    @Autowired
    IMdmSettings myMdmSettings;
    @Autowired
    MessageHelper myMessageHelper;
    @Autowired
    IMdmSurvivorshipService myMdmSurvivorshipService;
    @Autowired
    MdmPartitionHelper myMdmPartitionHelper;

    @Transactional
    public IAnyResource updateLink(IAnyResource theGoldenResource, IAnyResource theSourceResource, MdmMatchResultEnum theMatchResult, MdmTransactionContext theMdmContext) {
        String sourceType = this.myFhirContext.getResourceType((IBaseResource)theSourceResource);
        this.validateUpdateLinkRequest(theGoldenResource, theSourceResource, theMatchResult, sourceType);
        IResourcePersistentId goldenResourceId = this.myIdHelperService.getPidOrThrowException(theGoldenResource);
        IResourcePersistentId sourceResourceId = this.myIdHelperService.getPidOrThrowException(theSourceResource);
        this.myMdmPartitionHelper.validateResourcesInSamePartition(theGoldenResource, theSourceResource);
        Optional optionalMdmLink = this.myMdmLinkDaoSvc.getLinkByGoldenResourcePidAndSourceResourcePid(goldenResourceId, sourceResourceId);
        if (optionalMdmLink.isEmpty()) {
            throw new InvalidRequestException(Msg.code((int)738) + this.myMessageHelper.getMessageForNoLink(theGoldenResource, theSourceResource));
        }
        IMdmLink mdmLink = (IMdmLink)optionalMdmLink.get();
        this.validateNoMatchPresentWhenAcceptingPossibleMatch(theSourceResource, goldenResourceId, theMatchResult);
        if (mdmLink.getMatchResult() == theMatchResult) {
            ourLog.warn("MDM Link for " + theGoldenResource.getIdElement().toVersionless() + ", " + theSourceResource.getIdElement().toVersionless() + " already has value " + theMatchResult + ".  Nothing to do.");
            return theGoldenResource;
        }
        ourLog.info("Manually updating MDM Link for " + theGoldenResource.getIdElement().toVersionless() + ", " + theSourceResource.getIdElement().toVersionless() + " from " + mdmLink.getMatchResult() + " to " + theMatchResult + ".");
        mdmLink.setMatchResult(theMatchResult);
        mdmLink.setLinkSource(MdmLinkSourceEnum.MANUAL);
        RequestPartitionId goldenResourcePartitionId = (RequestPartitionId)theGoldenResource.getUserData(Constants.RESOURCE_PARTITION_ID);
        if (goldenResourcePartitionId != null && goldenResourcePartitionId.hasPartitionIds() && goldenResourcePartitionId.getFirstPartitionIdOrNull() != null && (mdmLink.getPartitionId() == null || mdmLink.getPartitionId().getPartitionId() == null)) {
            mdmLink.setPartitionId(new PartitionablePartitionId(goldenResourcePartitionId.getFirstPartitionIdOrNull(), goldenResourcePartitionId.getPartitionDate()));
        }
        this.myMdmLinkDaoSvc.save(mdmLink);
        if (theMatchResult == MdmMatchResultEnum.MATCH) {
            this.myMdmSurvivorshipService.applySurvivorshipRulesToGoldenResource((IBase)theSourceResource, (IBase)theGoldenResource, theMdmContext);
        }
        this.myMdmResourceDaoSvc.upsertGoldenResource(theGoldenResource, theMdmContext.getResourceType());
        if (theMatchResult == MdmMatchResultEnum.NO_MATCH) {
            this.myMdmMatchLinkSvc.updateMdmLinksForMdmSource(theSourceResource, theMdmContext);
        }
        return theGoldenResource;
    }

    private void validateNoMatchPresentWhenAcceptingPossibleMatch(IAnyResource theSourceResource, IResourcePersistentId theGoldenResourceId, MdmMatchResultEnum theMatchResult) {
        if (theMatchResult != MdmMatchResultEnum.MATCH) {
            return;
        }
        IResourcePersistentId sourceResourceId = this.myIdHelperService.getPidOrThrowException(theSourceResource);
        List mdmLinks = this.myMdmLinkDaoSvc.getMdmLinksBySourcePidAndMatchResult(sourceResourceId, MdmMatchResultEnum.MATCH);
        for (IMdmLink mdmLink : mdmLinks) {
            if (mdmLink.getGoldenResourcePersistenceId() == theGoldenResourceId) continue;
            IAnyResource existingGolden = this.myMdmResourceDaoSvc.readGoldenResourceByPid(mdmLink.getGoldenResourcePersistenceId(), mdmLink.getMdmSourceType());
            throw new InvalidRequestException(Msg.code((int)2218) + this.myMessageHelper.getMessageForAlreadyAcceptedLink(existingGolden, theSourceResource));
        }
    }

    private void validateUpdateLinkRequest(IAnyResource theGoldenRecord, IAnyResource theSourceResource, MdmMatchResultEnum theMatchResult, String theSourceType) {
        String goldenRecordType = this.myFhirContext.getResourceType((IBaseResource)theGoldenRecord);
        if (theMatchResult != MdmMatchResultEnum.NO_MATCH && theMatchResult != MdmMatchResultEnum.MATCH) {
            throw new InvalidRequestException(Msg.code((int)739) + this.myMessageHelper.getMessageForUnsupportedMatchResult());
        }
        if (!this.myMdmSettings.isSupportedMdmType(goldenRecordType)) {
            throw new InvalidRequestException(Msg.code((int)740) + this.myMessageHelper.getMessageForUnsupportedFirstArgumentTypeInUpdate(goldenRecordType));
        }
        if (!this.myMdmSettings.isSupportedMdmType(theSourceType)) {
            throw new InvalidRequestException(Msg.code((int)741) + this.myMessageHelper.getMessageForUnsupportedSecondArgumentTypeInUpdate(theSourceType));
        }
        if (!Objects.equals(goldenRecordType, theSourceType)) {
            throw new InvalidRequestException(Msg.code((int)742) + this.myMessageHelper.getMessageForArgumentTypeMismatchInUpdate(goldenRecordType, theSourceType));
        }
        if (!MdmResourceUtil.isMdmManaged((IBaseResource)theGoldenRecord)) {
            throw new InvalidRequestException(Msg.code((int)743) + this.myMessageHelper.getMessageForUnmanagedResource());
        }
        if (!MdmResourceUtil.isMdmAllowed((IBaseResource)theSourceResource)) {
            throw new InvalidRequestException(Msg.code((int)744) + this.myMessageHelper.getMessageForUnsupportedSourceResource());
        }
    }

    @Transactional
    public void notDuplicateGoldenResource(IAnyResource theGoldenResource, IAnyResource theTargetGoldenResource, MdmTransactionContext theMdmContext) {
        this.validateNotDuplicateGoldenResourceRequest(theGoldenResource, theTargetGoldenResource);
        IResourcePersistentId goldenResourceId = this.myIdHelperService.getPidOrThrowException(theGoldenResource);
        IResourcePersistentId targetId = this.myIdHelperService.getPidOrThrowException(theTargetGoldenResource);
        Optional oMdmLink = this.myMdmLinkDaoSvc.getLinkByGoldenResourcePidAndSourceResourcePid(goldenResourceId, targetId);
        if (oMdmLink.isEmpty()) {
            throw new InvalidRequestException(Msg.code((int)745) + "No link exists between " + theGoldenResource.getIdElement().toVersionless() + " and " + theTargetGoldenResource.getIdElement().toVersionless());
        }
        IMdmLink mdmLink = (IMdmLink)oMdmLink.get();
        if (!mdmLink.isPossibleDuplicate()) {
            throw new InvalidRequestException(Msg.code((int)746) + theGoldenResource.getIdElement().toVersionless() + " and " + theTargetGoldenResource.getIdElement().toVersionless() + " are not linked as POSSIBLE_DUPLICATE.");
        }
        mdmLink.setMatchResult(MdmMatchResultEnum.NO_MATCH);
        mdmLink.setLinkSource(MdmLinkSourceEnum.MANUAL);
        this.myMdmLinkDaoSvc.save(mdmLink);
    }

    private void validateNotDuplicateGoldenResourceRequest(IAnyResource theGoldenResource, IAnyResource theTarget) {
        String targetType;
        String goldenResourceType = this.myFhirContext.getResourceType((IBaseResource)theGoldenResource);
        if (!goldenResourceType.equalsIgnoreCase(targetType = this.myFhirContext.getResourceType((IBaseResource)theTarget))) {
            throw new InvalidRequestException(Msg.code((int)747) + "First argument to $mdm-update-link must be the same resource type as the second argument.  Was " + goldenResourceType + "/" + targetType);
        }
        if (!MdmResourceUtil.isMdmManaged((IBaseResource)theGoldenResource) || !MdmResourceUtil.isMdmManaged((IBaseResource)theTarget)) {
            throw new InvalidRequestException(Msg.code((int)748) + "Only MDM Managed Golden Resources may be updated via this operation.  The resource provided is not tagged as managed by HAPI-MDM");
        }
    }
}

