/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc.candidate;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.mdm.dao.MdmLinkDaoSvc;
import ca.uhn.fhir.jpa.mdm.svc.candidate.BaseCandidateFinder;
import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateStrategyEnum;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MatchedGoldenResourceCandidate;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.IMdmMatchFinderSvc;
import ca.uhn.fhir.mdm.api.MatchedTarget;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FindCandidateByExampleSvc<P extends IResourcePersistentId>
extends BaseCandidateFinder {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    IIdHelperService<P> myIdHelperService;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private MdmLinkDaoSvc<P, IMdmLink<P>> myMdmLinkDaoSvc;
    @Autowired
    private IMdmMatchFinderSvc myMdmMatchFinderSvc;

    @Override
    protected List<MatchedGoldenResourceCandidate> findMatchGoldenResourceCandidates(IAnyResource theTarget) {
        ArrayList<MatchedGoldenResourceCandidate> retval = new ArrayList<MatchedGoldenResourceCandidate>();
        List<P> goldenResourcePidsToExclude = this.getNoMatchGoldenResourcePids((IBaseResource)theTarget);
        List matchedCandidates = this.myMdmMatchFinderSvc.getMatchedTargets(this.myFhirContext.getResourceType((IBaseResource)theTarget), theTarget, (RequestPartitionId)theTarget.getUserData(Constants.RESOURCE_PARTITION_ID));
        matchedCandidates = matchedCandidates.stream().filter(mc -> mc.isMatch() || mc.isPossibleMatch()).collect(Collectors.toList());
        ArrayList<String> skippedLogMessages = new ArrayList<String>();
        ArrayList<String> matchedLogMessages = new ArrayList<String>();
        for (MatchedTarget match : matchedCandidates) {
            Optional<IMdmLink<P>> optionalMdmLink = this.myMdmLinkDaoSvc.getMatchedLinkForSourcePid(this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), (IBaseResource)match.getTarget()));
            if (!optionalMdmLink.isPresent()) {
                if (!ourLog.isDebugEnabled()) continue;
                skippedLogMessages.add(String.format("%s does not link to a Golden Resource (it may be a Golden Resource itself).  Removing candidate.", match.getTarget().getIdElement().toUnqualifiedVersionless()));
                continue;
            }
            IMdmLink<P> matchMdmLink = optionalMdmLink.get();
            if (goldenResourcePidsToExclude.contains(matchMdmLink.getGoldenResourcePersistenceId())) {
                skippedLogMessages.add(String.format("Skipping MDM on candidate Golden Resource with PID %s due to manual NO_MATCH", matchMdmLink.getGoldenResourcePersistenceId().toString()));
                continue;
            }
            MatchedGoldenResourceCandidate candidate = new MatchedGoldenResourceCandidate(matchMdmLink.getGoldenResourcePersistenceId(), match.getMatchResult());
            if (ourLog.isDebugEnabled()) {
                matchedLogMessages.add(String.format("Navigating from matched resource %s to its Golden Resource %s", match.getTarget().getIdElement().toUnqualifiedVersionless(), matchMdmLink.getGoldenResourcePersistenceId().toString()));
            }
            retval.add(candidate);
        }
        if (ourLog.isDebugEnabled()) {
            for (String logMessage : skippedLogMessages) {
                ourLog.debug(logMessage);
            }
            for (String logMessage : matchedLogMessages) {
                ourLog.debug(logMessage);
            }
        }
        return retval;
    }

    private List<P> getNoMatchGoldenResourcePids(IBaseResource theBaseResource) {
        IResourcePersistentId targetPid = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), theBaseResource);
        return this.myMdmLinkDaoSvc.getMdmLinksBySourcePidAndMatchResult(targetPid, MdmMatchResultEnum.NO_MATCH).stream().map(IMdmLink::getGoldenResourcePersistenceId).collect(Collectors.toList());
    }

    @Override
    protected CandidateStrategyEnum getStrategy() {
        return CandidateStrategyEnum.SCORE;
    }
}

