/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.MdmHistorySearchParameters;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmLinkWithRevision;
import ca.uhn.fhir.mdm.api.MdmMatchOutcome;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.api.MdmQuerySearchParameters;
import ca.uhn.fhir.mdm.dao.IMdmLinkDao;
import ca.uhn.fhir.mdm.dao.MdmLinkFactory;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.history.Revisions;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class MdmLinkDaoSvc<P extends IResourcePersistentId, M extends IMdmLink<P>> {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private IMdmLinkDao<P, M> myMdmLinkDao;
    @Autowired
    private MdmLinkFactory<M> myMdmLinkFactory;
    @Autowired
    private IIdHelperService<P> myIdHelperService;
    @Autowired
    private FhirContext myFhirContext;

    @Transactional
    public M createOrUpdateLinkEntity(IAnyResource theGoldenResource, IAnyResource theSourceResource, MdmMatchOutcome theMatchOutcome, MdmLinkSourceEnum theLinkSource, @Nullable MdmTransactionContext theMdmTransactionContext) {
        M mdmLink = this.getOrCreateMdmLinkByGoldenResourceAndSourceResource(theGoldenResource, theSourceResource);
        mdmLink.setLinkSource(theLinkSource);
        mdmLink.setMatchResult(theMatchOutcome.getMatchResultEnum());
        mdmLink.setEidMatch(Boolean.valueOf(theMatchOutcome.isEidMatch() | mdmLink.isEidMatchPresent()));
        mdmLink.setHadToCreateNewGoldenResource(Boolean.valueOf(theMatchOutcome.isCreatedNewResource() | mdmLink.getHadToCreateNewGoldenResource()));
        mdmLink.setMdmSourceType(this.myFhirContext.getResourceType((IBaseResource)theSourceResource));
        this.setScoreProperties(theMatchOutcome, mdmLink);
        RequestPartitionId partitionId = (RequestPartitionId)theSourceResource.getUserData(Constants.RESOURCE_PARTITION_ID);
        if (partitionId != null && partitionId.getFirstPartitionIdOrNull() != null) {
            mdmLink.setPartitionId(new PartitionablePartitionId(partitionId.getFirstPartitionIdOrNull(), partitionId.getPartitionDate()));
        }
        String message = String.format("Creating %s link from %s to Golden Resource %s.", mdmLink.getMatchResult(), theSourceResource.getIdElement().toUnqualifiedVersionless(), theGoldenResource.getIdElement().toUnqualifiedVersionless());
        theMdmTransactionContext.addTransactionLogMessage(message);
        ourLog.debug(message);
        this.save(mdmLink);
        return mdmLink;
    }

    private void setScoreProperties(MdmMatchOutcome theMatchOutcome, M mdmLink) {
        if (theMatchOutcome.getScore() != null) {
            mdmLink.setScore(Double.valueOf(mdmLink.getScore() != null ? Math.max(theMatchOutcome.getNormalizedScore(), mdmLink.getScore()) : theMatchOutcome.getNormalizedScore()));
        }
        if (theMatchOutcome.getVector() != null) {
            mdmLink.setVector(Long.valueOf(mdmLink.getVector() != null ? Math.max(theMatchOutcome.getVector(), mdmLink.getVector()) : theMatchOutcome.getVector()));
        }
        mdmLink.setRuleCount(Long.valueOf(mdmLink.getRuleCount() != null ? Math.max((long)theMatchOutcome.getMdmRuleCount(), mdmLink.getRuleCount()) : (long)theMatchOutcome.getMdmRuleCount()));
    }

    @Nonnull
    public M getOrCreateMdmLinkByGoldenResourceAndSourceResource(IAnyResource theGoldenResource, IAnyResource theSourceResource) {
        IResourcePersistentId sourceResourcePid;
        IResourcePersistentId goldenResourcePid = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), (IBaseResource)theGoldenResource);
        Optional<M> oExisting = this.getLinkByGoldenResourcePidAndSourceResourcePid(goldenResourcePid, sourceResourcePid = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), (IBaseResource)theSourceResource));
        if (oExisting.isPresent()) {
            return (M)((IMdmLink)oExisting.get());
        }
        IMdmLink newLink = this.myMdmLinkFactory.newMdmLink();
        newLink.setGoldenResourcePersistenceId(goldenResourcePid);
        newLink.setSourcePersistenceId(sourceResourcePid);
        return (M)newLink;
    }

    @Deprecated
    public Optional<M> getLinkByGoldenResourcePidAndSourceResourcePid(Long theGoldenResourcePid, Long theSourceResourcePid) {
        return this.getLinkByGoldenResourcePidAndSourceResourcePid(this.myIdHelperService.newPid((Object)theGoldenResourcePid), this.myIdHelperService.newPid((Object)theSourceResourcePid));
    }

    public Optional<M> getLinkByGoldenResourcePidAndSourceResourcePid(P theGoldenResourcePid, P theSourceResourcePid) {
        if (theSourceResourcePid == null || theGoldenResourcePid == null) {
            return Optional.empty();
        }
        IMdmLink link = this.myMdmLinkFactory.newMdmLinkVersionless();
        link.setSourcePersistenceId(theSourceResourcePid);
        link.setGoldenResourcePersistenceId(theGoldenResourcePid);
        Example example = Example.of((Object)link);
        return this.myMdmLinkDao.findOne(example);
    }

    public List<M> getMdmLinksBySourcePidAndMatchResult(P theSourcePid, MdmMatchResultEnum theMatchResult) {
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLinkVersionless();
        exampleLink.setSourcePersistenceId(theSourcePid);
        exampleLink.setMatchResult(theMatchResult);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findAll(example);
    }

    @Deprecated
    @Transactional
    public Optional<M> getMatchedLinkForSourcePid(P theSourcePid) {
        return this.myMdmLinkDao.findBySourcePidAndMatchResult(theSourcePid, MdmMatchResultEnum.MATCH);
    }

    public Optional<M> getMatchedLinkForSource(IBaseResource theSourceResource) {
        return this.getMdmLinkWithMatchResult(theSourceResource, MdmMatchResultEnum.MATCH);
    }

    public Optional<M> getPossibleMatchedLinkForSource(IBaseResource theSourceResource) {
        return this.getMdmLinkWithMatchResult(theSourceResource, MdmMatchResultEnum.POSSIBLE_MATCH);
    }

    @Nonnull
    private Optional<M> getMdmLinkWithMatchResult(IBaseResource theSourceResource, MdmMatchResultEnum theMatchResult) {
        IResourcePersistentId pid = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), theSourceResource);
        if (pid == null) {
            return Optional.empty();
        }
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLinkVersionless();
        exampleLink.setSourcePersistenceId(pid);
        exampleLink.setMatchResult(theMatchResult);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findOne(example);
    }

    public Optional<M> getMdmLinksByGoldenResourcePidSourcePidAndMatchResult(Long theGoldenResourcePid, Long theSourcePid, MdmMatchResultEnum theMatchResult) {
        return this.getMdmLinksByGoldenResourcePidSourcePidAndMatchResult(this.myIdHelperService.newPid((Object)theGoldenResourcePid), this.myIdHelperService.newPid((Object)theSourcePid), theMatchResult);
    }

    public Optional<M> getMdmLinksByGoldenResourcePidSourcePidAndMatchResult(P theGoldenResourcePid, P theSourcePid, MdmMatchResultEnum theMatchResult) {
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLinkVersionless();
        exampleLink.setGoldenResourcePersistenceId(theGoldenResourcePid);
        exampleLink.setSourcePersistenceId(theSourcePid);
        exampleLink.setMatchResult(theMatchResult);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findOne(example);
    }

    public List<M> getPossibleDuplicates() {
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLinkVersionless();
        exampleLink.setMatchResult(MdmMatchResultEnum.POSSIBLE_DUPLICATE);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findAll(example);
    }

    @Transactional
    public Optional<M> findMdmLinkBySource(IBaseResource theSourceResource) {
        IResourcePersistentId pid = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), theSourceResource);
        if (pid == null) {
            return Optional.empty();
        }
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLinkVersionless();
        exampleLink.setSourcePersistenceId(pid);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findOne(example);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void deleteLink(M theMdmLink) {
        this.myMdmLinkDao.validateMdmLink(theMdmLink);
        this.myMdmLinkDao.delete(theMdmLink);
    }

    @Transactional
    public List<M> findMdmLinksByGoldenResource(IBaseResource theGoldenResource) {
        IResourcePersistentId pid = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), theGoldenResource);
        if (pid == null) {
            return Collections.emptyList();
        }
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLinkVersionless();
        exampleLink.setGoldenResourcePersistenceId(pid);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findAll(example);
    }

    public M save(M theMdmLink) {
        IMdmLink mdmLink = this.myMdmLinkDao.validateMdmLink(theMdmLink);
        if (mdmLink.getCreated() == null) {
            mdmLink.setCreated(new Date());
        }
        mdmLink.setUpdated(new Date());
        return (M)this.myMdmLinkDao.save(mdmLink);
    }

    public Page<M> executeTypedQuery(MdmQuerySearchParameters theMdmQuerySearchParameters) {
        return this.myMdmLinkDao.search(theMdmQuerySearchParameters);
    }

    @Transactional
    public List<M> findMdmLinksBySourceResource(IBaseResource theSourceResource) {
        IResourcePersistentId pid = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), theSourceResource);
        if (pid == null) {
            return Collections.emptyList();
        }
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLinkVersionless();
        exampleLink.setSourcePersistenceId(pid);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findAll(example);
    }

    public List<M> findMdmMatchLinksByGoldenResource(IBaseResource theGoldenResource) {
        IResourcePersistentId pid = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), theGoldenResource);
        if (pid == null) {
            return Collections.emptyList();
        }
        IMdmLink exampleLink = this.myMdmLinkFactory.newMdmLinkVersionless();
        exampleLink.setGoldenResourcePersistenceId(pid);
        exampleLink.setMatchResult(MdmMatchResultEnum.MATCH);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findAll(example);
    }

    public IMdmLink newMdmLink() {
        return this.myMdmLinkFactory.newMdmLink();
    }

    public Optional<M> getMatchedOrPossibleMatchedLinkForSource(IAnyResource theResource) {
        Optional<M> retval = this.getMatchedLinkForSource((IBaseResource)theResource);
        if (!retval.isPresent()) {
            retval = this.getPossibleMatchedLinkForSource((IBaseResource)theResource);
        }
        return retval;
    }

    public Optional<M> getLinkByGoldenResourceAndSourceResource(@Nullable IAnyResource theGoldenResource, @Nullable IAnyResource theSourceResource) {
        if (theGoldenResource == null || theSourceResource == null) {
            return Optional.empty();
        }
        return this.getLinkByGoldenResourcePidAndSourceResourcePid(this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), (IBaseResource)theGoldenResource), this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), (IBaseResource)theSourceResource));
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteLinksWithAnyReferenceToPids(List<P> theGoldenResourcePids) {
        this.myMdmLinkDao.deleteLinksWithAnyReferenceToPids(theGoldenResourcePids);
    }

    @Deprecated(since="6.5.7", forRemoval=true)
    public Revisions<Long, M> findMdmLinkHistory(M mdmLink) {
        return this.myMdmLinkDao.findHistory(mdmLink.getId());
    }

    @Transactional
    public List<MdmLinkWithRevision<M>> findMdmLinkHistory(MdmHistorySearchParameters theMdmHistorySearchParameters) {
        return this.myMdmLinkDao.getHistoryForIds(theMdmHistorySearchParameters);
    }
}

