/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fhirpath.FhirPathExecutionException;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.mdm.blocklist.json.BlockListJson;
import ca.uhn.fhir.mdm.blocklist.json.BlockListRuleJson;
import ca.uhn.fhir.mdm.blocklist.json.BlockedFieldJson;
import ca.uhn.fhir.mdm.blocklist.svc.IBlockListRuleProvider;
import ca.uhn.fhir.mdm.blocklist.svc.IBlockRuleEvaluationSvc;
import ca.uhn.fhir.util.FhirTypeUtil;
import java.util.List;
import javax.annotation.Nullable;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockRuleEvaluationSvcImpl
implements IBlockRuleEvaluationSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(BlockRuleEvaluationSvcImpl.class);
    private final IFhirPath myFhirPath;
    private final IBlockListRuleProvider myBlockListRuleProvider;

    public BlockRuleEvaluationSvcImpl(FhirContext theContext, @Nullable IBlockListRuleProvider theIBlockListRuleProvider) {
        this.myFhirPath = theContext.newFhirPath();
        this.myBlockListRuleProvider = theIBlockListRuleProvider;
    }

    private boolean hasBlockList() {
        return this.myBlockListRuleProvider != null && this.myBlockListRuleProvider.getBlocklistRules() != null;
    }

    public boolean isMdmMatchingBlocked(IAnyResource theResource) {
        if (this.hasBlockList()) {
            return this.isMdmMatchingBlockedInternal(theResource);
        }
        return false;
    }

    private boolean isMdmMatchingBlockedInternal(IAnyResource theResource) {
        BlockListJson blockListJson = this.myBlockListRuleProvider.getBlocklistRules();
        String resourceType = theResource.fhirType();
        return blockListJson.getBlockListItemJsonList().stream().filter(r -> r.getResourceType().equals(resourceType)).anyMatch(rule -> this.isMdmBlockedForFhirPath(theResource, (BlockListRuleJson)rule));
    }

    private boolean isMdmBlockedForFhirPath(IAnyResource theResource, BlockListRuleJson theRule) {
        List blockedFields = theRule.getBlockedFields();
        for (BlockedFieldJson field : blockedFields) {
            List results;
            String path = field.getFhirPath();
            String blockedValue = field.getBlockedValue();
            try {
                results = this.myFhirPath.evaluate((IBase)theResource, path, IBase.class);
            }
            catch (FhirPathExecutionException ex) {
                ourLog.warn("FhirPath evaluation failed with an exception. No blocking will be applied and mdm matching will continue as before.", (Throwable)ex);
                return false;
            }
            if (results.size() != 1) {
                ourLog.trace("Too many values at field {}", (Object)path);
                return false;
            }
            IBase first = (IBase)results.get(0);
            if (FhirTypeUtil.isPrimitiveType((String)first.fhirType())) {
                IPrimitiveType primitiveType = (IPrimitiveType)first;
                if (primitiveType.getValueAsString().equalsIgnoreCase(blockedValue)) continue;
                ourLog.trace("Value at path {} does not match - mdm will not block.", (Object)path);
                return false;
            }
            ourLog.warn("FhirPath {} yields a non-primitive value; blocking is only supported on primitive field types.", (Object)path);
            return false;
        }
        return true;
    }
}

