/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.mdm.dao.MdmLinkDaoSvc;
import ca.uhn.fhir.jpa.mdm.svc.MdmResourceDaoSvc;
import ca.uhn.fhir.mdm.api.IGoldenResourceMergerSvc;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.IMdmLinkSvc;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchOutcome;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.util.GoldenResourceHelper;
import ca.uhn.fhir.mdm.util.MdmPartitionHelper;
import ca.uhn.fhir.mdm.util.MdmResourceUtil;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoldenResourceMergerSvcImpl
implements IGoldenResourceMergerSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    GoldenResourceHelper myGoldenResourceHelper;
    @Autowired
    MdmLinkDaoSvc myMdmLinkDaoSvc;
    @Autowired
    IMdmLinkSvc myMdmLinkSvc;
    @Autowired
    IIdHelperService myIdHelperService;
    @Autowired
    MdmResourceDaoSvc myMdmResourceDaoSvc;
    @Autowired
    MdmPartitionHelper myMdmPartitionHelper;

    @Transactional
    public IAnyResource mergeGoldenResources(IAnyResource theFromGoldenResource, IAnyResource theMergedResource, IAnyResource theToGoldenResource, MdmTransactionContext theMdmTransactionContext) {
        String resourceType = theMdmTransactionContext.getResourceType();
        if (theMergedResource != null) {
            if (this.myGoldenResourceHelper.hasIdentifier((IBaseResource)theMergedResource)) {
                throw new IllegalArgumentException(Msg.code((int)751) + "Manually merged resource can not contain identifiers");
            }
            this.myGoldenResourceHelper.mergeIndentifierFields((IBaseResource)theFromGoldenResource, (IBaseResource)theMergedResource, theMdmTransactionContext);
            this.myGoldenResourceHelper.mergeIndentifierFields((IBaseResource)theToGoldenResource, (IBaseResource)theMergedResource, theMdmTransactionContext);
            theMergedResource.setId(theToGoldenResource.getId());
            theToGoldenResource = (IAnyResource)this.myMdmResourceDaoSvc.upsertGoldenResource(theMergedResource, resourceType).getResource();
        } else {
            this.myGoldenResourceHelper.mergeIndentifierFields((IBaseResource)theFromGoldenResource, (IBaseResource)theToGoldenResource, theMdmTransactionContext);
            this.myGoldenResourceHelper.mergeNonIdentiferFields((IBaseResource)theFromGoldenResource, (IBaseResource)theToGoldenResource, theMdmTransactionContext);
            this.myMdmResourceDaoSvc.upsertGoldenResource(theToGoldenResource, resourceType);
        }
        this.myMdmPartitionHelper.validateMdmResourcesPartitionMatches(theFromGoldenResource, theToGoldenResource);
        this.mergeGoldenResourceLinks(theFromGoldenResource, theToGoldenResource, theFromGoldenResource.getIdElement(), theMdmTransactionContext);
        this.addMergeLink(theToGoldenResource, theFromGoldenResource, resourceType, theMdmTransactionContext);
        this.myMdmResourceDaoSvc.removeGoldenResourceTag(theFromGoldenResource, resourceType);
        MdmResourceUtil.setGoldenResourceRedirected((IBaseResource)theFromGoldenResource);
        this.myMdmResourceDaoSvc.upsertGoldenResource(theFromGoldenResource, resourceType);
        this.log(theMdmTransactionContext, "Merged " + theFromGoldenResource.getIdElement().toVersionless() + " into " + theToGoldenResource.getIdElement().toVersionless());
        return theToGoldenResource;
    }

    private void addMergeLink(IAnyResource theGoldenResource, IAnyResource theTargetResource, String theResourceType, MdmTransactionContext theMdmTransactionContext) {
        this.myMdmLinkSvc.deleteLink(theGoldenResource, theTargetResource, theMdmTransactionContext);
        this.myMdmLinkDaoSvc.createOrUpdateLinkEntity(theTargetResource, theGoldenResource, new MdmMatchOutcome(null, null).setMatchResultEnum(MdmMatchResultEnum.REDIRECT), MdmLinkSourceEnum.MANUAL, theMdmTransactionContext);
    }

    private RequestPartitionId getPartitionIdForResource(IAnyResource theResource) {
        RequestPartitionId partitionId = (RequestPartitionId)theResource.getUserData(Constants.RESOURCE_PARTITION_ID);
        if (partitionId == null) {
            partitionId = RequestPartitionId.allPartitions();
        }
        return partitionId;
    }

    private void mergeGoldenResourceLinks(IAnyResource theFromResource, IAnyResource theToResource, IIdType theToResourcePid, MdmTransactionContext theMdmTransactionContext) {
        List fromLinks = this.myMdmLinkDaoSvc.findMdmLinksByGoldenResource((IBaseResource)theFromResource);
        List toLinks = this.myMdmLinkDaoSvc.findMdmLinksByGoldenResource((IBaseResource)theToResource);
        ArrayList<IMdmLink> toDelete = new ArrayList<IMdmLink>();
        IResourcePersistentId goldenResourcePid = this.myIdHelperService.resolveResourcePersistentIds(this.getPartitionIdForResource(theToResource), theToResource.getIdElement().getResourceType(), theToResource.getIdElement().getIdPart());
        for (IMdmLink fromLink : fromLinks) {
            Optional<? extends IMdmLink> optionalToLink = this.findFirstLinkWithMatchingSource(toLinks, fromLink);
            if (optionalToLink.isPresent()) {
                IMdmLink toLink = optionalToLink.get();
                if (fromLink.isManual()) {
                    switch (toLink.getLinkSource()) {
                        case AUTO: {
                            this.log(theMdmTransactionContext, String.format("MANUAL overrides AUT0.  Deleting link %s", toLink.toString()));
                            this.myMdmLinkDaoSvc.deleteLink(toLink);
                            break;
                        }
                        case MANUAL: {
                            if (fromLink.getMatchResult() == toLink.getMatchResult()) break;
                            throw new InvalidRequestException(Msg.code((int)752) + "A MANUAL " + fromLink.getMatchResult() + " link may not be merged into a MANUAL " + toLink.getMatchResult() + " link for the same target");
                        }
                    }
                } else {
                    toDelete.add(fromLink);
                    continue;
                }
            }
            if (fromLink.getSourcePersistenceId().equals(goldenResourcePid)) {
                this.myMdmLinkDaoSvc.deleteLink(fromLink);
                continue;
            }
            fromLink.setGoldenResourcePersistenceId(goldenResourcePid);
            ourLog.trace("Saving link {}", (Object)fromLink);
            this.myMdmLinkDaoSvc.save(fromLink);
        }
        toDelete.forEach(link -> this.myMdmLinkDaoSvc.deleteLink(link));
    }

    private Optional<? extends IMdmLink> findFirstLinkWithMatchingSource(List<? extends IMdmLink> theMdmLinks, IMdmLink theLinkWithSourceToMatch) {
        return theMdmLinks.stream().filter(mdmLink -> mdmLink.getSourcePersistenceId().equals(theLinkWithSourceToMatch.getSourcePersistenceId())).findFirst();
    }

    private void log(MdmTransactionContext theMdmTransactionContext, String theMessage) {
        theMdmTransactionContext.addTransactionLogMessage(theMessage);
        ourLog.debug(theMessage);
    }
}

