/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.batch2.api.IJobCoordinator;
import ca.uhn.fhir.batch2.model.JobInstanceStartRequest;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.batch.models.Batch2JobStartResponse;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.mdm.api.IGoldenResourceMergerSvc;
import ca.uhn.fhir.mdm.api.IMdmControllerSvc;
import ca.uhn.fhir.mdm.api.IMdmLinkCreateSvc;
import ca.uhn.fhir.mdm.api.IMdmLinkQuerySvc;
import ca.uhn.fhir.mdm.api.IMdmLinkUpdaterSvc;
import ca.uhn.fhir.mdm.api.MdmHistorySearchParameters;
import ca.uhn.fhir.mdm.api.MdmLinkJson;
import ca.uhn.fhir.mdm.api.MdmLinkWithRevisionJson;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.api.MdmQuerySearchParameters;
import ca.uhn.fhir.mdm.api.paging.MdmPageRequest;
import ca.uhn.fhir.mdm.batch2.clear.MdmClearJobParameters;
import ca.uhn.fhir.mdm.batch2.submit.MdmSubmitAppCtx;
import ca.uhn.fhir.mdm.batch2.submit.MdmSubmitJobParameters;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.provider.MdmControllerHelper;
import ca.uhn.fhir.mdm.provider.MdmControllerUtil;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ParametersUtil;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class MdmControllerSvcImpl
implements IMdmControllerSvc {
    @Autowired
    FhirContext myFhirContext;
    @Autowired
    MdmControllerHelper myMdmControllerHelper;
    @Autowired
    IGoldenResourceMergerSvc myGoldenResourceMergerSvc;
    @Autowired
    IMdmLinkQuerySvc myMdmLinkQuerySvc;
    @Autowired
    IMdmLinkUpdaterSvc myIMdmLinkUpdaterSvc;
    @Autowired
    IMdmLinkCreateSvc myIMdmLinkCreateSvc;
    @Autowired
    IRequestPartitionHelperSvc myRequestPartitionHelperSvc;
    @Autowired
    IJobCoordinator myJobCoordinator;

    public IAnyResource mergeGoldenResources(String theFromGoldenResourceId, String theToGoldenResourceId, IAnyResource theManuallyMergedGoldenResource, MdmTransactionContext theMdmTransactionContext) {
        IAnyResource fromGoldenResource = this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("fromGoldenResourceId", theFromGoldenResourceId);
        IAnyResource toGoldenResource = this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("toGoldenResourceId", theToGoldenResourceId);
        this.myMdmControllerHelper.validateMergeResources(fromGoldenResource, toGoldenResource);
        this.myMdmControllerHelper.validateSameVersion(fromGoldenResource, theFromGoldenResourceId);
        this.myMdmControllerHelper.validateSameVersion(toGoldenResource, theToGoldenResourceId);
        return this.myGoldenResourceMergerSvc.mergeGoldenResources(fromGoldenResource, theManuallyMergedGoldenResource, toGoldenResource, theMdmTransactionContext);
    }

    @Deprecated
    public Page<MdmLinkJson> queryLinks(@Nullable String theGoldenResourceId, @Nullable String theSourceResourceId, @Nullable String theMatchResult, @Nullable String theLinkSource, MdmTransactionContext theMdmTransactionContext, MdmPageRequest thePageRequest) {
        MdmQuerySearchParameters mdmQuerySearchParameters = new MdmQuerySearchParameters(thePageRequest).setGoldenResourceId(theGoldenResourceId).setSourceId(theSourceResourceId).setMatchResult(theMatchResult).setLinkSource(theLinkSource);
        return this.queryLinksFromPartitionList(mdmQuerySearchParameters, theMdmTransactionContext);
    }

    @Deprecated
    public Page<MdmLinkJson> queryLinks(@Nullable String theGoldenResourceId, @Nullable String theSourceResourceId, @Nullable String theMatchResult, @Nullable String theLinkSource, MdmTransactionContext theMdmTransactionContext, MdmPageRequest thePageRequest, @Nullable RequestDetails theRequestDetails) {
        MdmQuerySearchParameters mdmQuerySearchParameters = new MdmQuerySearchParameters(thePageRequest).setGoldenResourceId(theGoldenResourceId).setSourceId(theSourceResourceId).setMatchResult(theMatchResult).setLinkSource(theLinkSource);
        return this.queryLinks(mdmQuerySearchParameters, theMdmTransactionContext, theRequestDetails);
    }

    public Page<MdmLinkJson> queryLinks(MdmQuerySearchParameters theMdmQuerySearchParameters, MdmTransactionContext theMdmTransactionContext, RequestDetails theRequestDetails) {
        RequestPartitionId theReadPartitionId = this.myRequestPartitionHelperSvc.determineReadPartitionForRequest(theRequestDetails, null);
        if (theReadPartitionId.hasPartitionIds()) {
            theMdmQuerySearchParameters.setPartitionIds(theReadPartitionId.getPartitionIds());
        }
        Page<MdmLinkJson> resultPage = this.queryLinksFromPartitionList(theMdmQuerySearchParameters, theMdmTransactionContext);
        this.validateMdmQueryPermissions(theReadPartitionId, resultPage.getContent(), theRequestDetails);
        return resultPage;
    }

    public List<MdmLinkWithRevisionJson> queryLinkHistory(MdmHistorySearchParameters theMdmHistorySearchParameters, RequestDetails theRequestDetails) {
        return this.myMdmLinkQuerySvc.queryLinkHistory(theMdmHistorySearchParameters);
    }

    @Deprecated
    public Page<MdmLinkJson> queryLinksFromPartitionList(@Nullable String theGoldenResourceId, @Nullable String theSourceResourceId, @Nullable String theMatchResult, @Nullable String theLinkSource, MdmTransactionContext theMdmTransactionContext, MdmPageRequest thePageRequest, @Nullable List<Integer> thePartitionIds) {
        MdmQuerySearchParameters mdmQuerySearchParameters = new MdmQuerySearchParameters(thePageRequest).setGoldenResourceId(theGoldenResourceId).setSourceId(theSourceResourceId).setMatchResult(theMatchResult).setLinkSource(theLinkSource).setPartitionIds(thePartitionIds);
        return this.queryLinksFromPartitionList(mdmQuerySearchParameters, theMdmTransactionContext);
    }

    public Page<MdmLinkJson> queryLinksFromPartitionList(MdmQuerySearchParameters theMdmQuerySearchParameters, MdmTransactionContext theMdmTransactionContext) {
        return this.myMdmLinkQuerySvc.queryLinks(theMdmQuerySearchParameters, theMdmTransactionContext);
    }

    public Page<MdmLinkJson> getDuplicateGoldenResources(MdmTransactionContext theMdmTransactionContext, MdmPageRequest thePageRequest) {
        return this.myMdmLinkQuerySvc.getDuplicateGoldenResources(theMdmTransactionContext, thePageRequest, null, null);
    }

    public Page<MdmLinkJson> getDuplicateGoldenResources(MdmTransactionContext theMdmTransactionContext, MdmPageRequest thePageRequest, RequestDetails theRequestDetails, String theRequestResourceType) {
        RequestPartitionId readPartitionId = this.myRequestPartitionHelperSvc.determineReadPartitionForRequest(theRequestDetails, null);
        Page resultPage = readPartitionId.isAllPartitions() ? this.myMdmLinkQuerySvc.getDuplicateGoldenResources(theMdmTransactionContext, thePageRequest, null, theRequestResourceType) : this.myMdmLinkQuerySvc.getDuplicateGoldenResources(theMdmTransactionContext, thePageRequest, readPartitionId.getPartitionIds(), theRequestResourceType);
        this.validateMdmQueryPermissions(readPartitionId, resultPage.getContent(), theRequestDetails);
        return resultPage;
    }

    public IAnyResource updateLink(String theGoldenResourceId, String theSourceResourceId, String theMatchResult, MdmTransactionContext theMdmTransactionContext) {
        MdmMatchResultEnum matchResult = MdmControllerUtil.extractMatchResultOrNull((String)theMatchResult);
        IAnyResource goldenResource = this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("goldenResourceId", theGoldenResourceId);
        IAnyResource source = this.myMdmControllerHelper.getLatestSourceFromIdOrThrowException("resourceId", theSourceResourceId);
        this.myMdmControllerHelper.validateSameVersion(goldenResource, theGoldenResourceId);
        this.myMdmControllerHelper.validateSameVersion(source, theSourceResourceId);
        return this.myIMdmLinkUpdaterSvc.updateLink(goldenResource, source, matchResult, theMdmTransactionContext);
    }

    public IAnyResource createLink(String theGoldenResourceId, String theSourceResourceId, @Nullable String theMatchResult, MdmTransactionContext theMdmTransactionContext) {
        MdmMatchResultEnum matchResult = MdmControllerUtil.extractMatchResultOrNull((String)theMatchResult);
        IAnyResource goldenResource = this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("goldenResourceId", theGoldenResourceId);
        IAnyResource source = this.myMdmControllerHelper.getLatestSourceFromIdOrThrowException("resourceId", theSourceResourceId);
        this.myMdmControllerHelper.validateSameVersion(goldenResource, theGoldenResourceId);
        this.myMdmControllerHelper.validateSameVersion(source, theSourceResourceId);
        return this.myIMdmLinkCreateSvc.createLink(goldenResource, source, matchResult, theMdmTransactionContext);
    }

    public IBaseParameters submitMdmClearJob(@Nonnull List<String> theResourceNames, IPrimitiveType<BigDecimal> theBatchSize, ServletRequestDetails theRequestDetails) {
        MdmClearJobParameters params = new MdmClearJobParameters();
        params.setResourceNames(theResourceNames);
        if (theBatchSize != null && theBatchSize.getValue() != null && ((BigDecimal)theBatchSize.getValue()).longValue() > 0L) {
            params.setBatchSize(((BigDecimal)theBatchSize.getValue()).intValue());
        }
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forOperation(null, null, (String)"$mdm-clear");
        RequestPartitionId requestPartition = this.myRequestPartitionHelperSvc.determineReadPartitionForRequest((RequestDetails)theRequestDetails, details);
        params.setRequestPartitionId(requestPartition);
        JobInstanceStartRequest request = new JobInstanceStartRequest();
        request.setJobDefinitionId("MDM_CLEAR");
        request.setParameters((IModelJson)params);
        Batch2JobStartResponse response = this.myJobCoordinator.startInstance((RequestDetails)theRequestDetails, request);
        String id = response.getInstanceId();
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.myFhirContext);
        ParametersUtil.addParameterToParametersString((FhirContext)this.myFhirContext, (IBaseParameters)retVal, (String)"jobId", (String)id);
        return retVal;
    }

    public IBaseParameters submitMdmSubmitJob(List<String> theUrls, IPrimitiveType<BigDecimal> theBatchSize, ServletRequestDetails theRequestDetails) {
        MdmSubmitJobParameters params = new MdmSubmitJobParameters();
        if (theBatchSize != null && theBatchSize.getValue() != null && ((BigDecimal)theBatchSize.getValue()).longValue() > 0L) {
            params.setBatchSize(((BigDecimal)theBatchSize.getValue()).intValue());
        }
        params.setRequestPartitionId(RequestPartitionId.allPartitions());
        theUrls.forEach(arg_0 -> ((MdmSubmitJobParameters)params).addUrl(arg_0));
        JobInstanceStartRequest request = new JobInstanceStartRequest();
        request.setParameters((IModelJson)params);
        request.setJobDefinitionId(MdmSubmitAppCtx.MDM_SUBMIT_JOB);
        Batch2JobStartResponse batch2JobStartResponse = this.myJobCoordinator.startInstance((RequestDetails)theRequestDetails, request);
        String id = batch2JobStartResponse.getInstanceId();
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.myFhirContext);
        ParametersUtil.addParameterToParametersString((FhirContext)this.myFhirContext, (IBaseParameters)retVal, (String)"jobId", (String)id);
        return retVal;
    }

    public void notDuplicateGoldenResource(String theGoldenResourceId, String theTargetGoldenResourceId, MdmTransactionContext theMdmTransactionContext) {
        IAnyResource goldenResource = this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("goldenResourceId", theGoldenResourceId);
        IAnyResource target = this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("resourceId", theTargetGoldenResourceId);
        this.myIMdmLinkUpdaterSvc.notDuplicateGoldenResource(goldenResource, target, theMdmTransactionContext);
    }

    private void validateMdmQueryPermissions(RequestPartitionId theRequestPartitionId, List<MdmLinkJson> theMdmLinkJsonList, RequestDetails theRequestDetails) {
        HashSet<String> seenResourceTypes = new HashSet<String>();
        for (MdmLinkJson mdmLinkJson : theMdmLinkJsonList) {
            IdDt idDt = new IdDt(mdmLinkJson.getSourceId());
            if (seenResourceTypes.contains(idDt.getResourceType())) continue;
            this.myRequestPartitionHelperSvc.validateHasPartitionPermissions(theRequestDetails, idDt.getResourceType(), theRequestPartitionId);
            seenResourceTypes.add(idDt.getResourceType());
        }
    }
}

