/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.jpa.mdm.dao.MdmLinkDaoSvc;
import ca.uhn.fhir.jpa.mdm.svc.IMdmModelConverterSvc;
import ca.uhn.fhir.mdm.api.IMdmLinkQuerySvc;
import ca.uhn.fhir.mdm.api.MdmHistorySearchParameters;
import ca.uhn.fhir.mdm.api.MdmLinkJson;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmLinkWithRevisionJson;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.api.MdmQuerySearchParameters;
import ca.uhn.fhir.mdm.api.paging.MdmPageRequest;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;

public class MdmLinkQuerySvcImplSvc
implements IMdmLinkQuerySvc {
    private static final Logger ourLog = LoggerFactory.getLogger(MdmLinkQuerySvcImplSvc.class);
    @Autowired
    MdmLinkDaoSvc myMdmLinkDaoSvc;
    @Autowired
    IMdmModelConverterSvc myMdmModelConverterSvc;

    @Deprecated
    @Transactional
    public Page<MdmLinkJson> queryLinks(IIdType theGoldenResourceId, IIdType theSourceResourceId, MdmMatchResultEnum theMatchResult, MdmLinkSourceEnum theLinkSource, MdmTransactionContext theMdmContext, MdmPageRequest thePageRequest) {
        MdmQuerySearchParameters mdmQuerySearchParameters = new MdmQuerySearchParameters(thePageRequest).setGoldenResourceId(theGoldenResourceId).setSourceId(theSourceResourceId).setMatchResult(theMatchResult).setLinkSource(theLinkSource);
        return this.queryLinks(mdmQuerySearchParameters, theMdmContext);
    }

    @Deprecated
    @Transactional
    public Page<MdmLinkJson> queryLinks(IIdType theGoldenResourceId, IIdType theSourceResourceId, MdmMatchResultEnum theMatchResult, MdmLinkSourceEnum theLinkSource, MdmTransactionContext theMdmContext, MdmPageRequest thePageRequest, List<Integer> thePartitionIds) {
        MdmQuerySearchParameters mdmQuerySearchParameters = new MdmQuerySearchParameters(thePageRequest).setGoldenResourceId(theGoldenResourceId).setSourceId(theSourceResourceId).setMatchResult(theMatchResult).setLinkSource(theLinkSource).setPartitionIds(thePartitionIds);
        return this.queryLinks(mdmQuerySearchParameters, theMdmContext);
    }

    @Transactional
    public Page<MdmLinkJson> queryLinks(MdmQuerySearchParameters theMdmQuerySearchParameters, MdmTransactionContext theMdmContext) {
        Page mdmLinks = this.myMdmLinkDaoSvc.executeTypedQuery(theMdmQuerySearchParameters);
        return mdmLinks.map(this.myMdmModelConverterSvc::toJson);
    }

    @Transactional
    public Page<MdmLinkJson> getDuplicateGoldenResources(MdmTransactionContext theMdmContext, MdmPageRequest thePageRequest) {
        return this.getDuplicateGoldenResources(theMdmContext, thePageRequest, null, null);
    }

    @Transactional
    public Page<MdmLinkJson> getDuplicateGoldenResources(MdmTransactionContext theMdmContext, MdmPageRequest thePageRequest, List<Integer> thePartitionIds, String theRequestResourceType) {
        MdmQuerySearchParameters mdmQuerySearchParameters = new MdmQuerySearchParameters(thePageRequest).setMatchResult(MdmMatchResultEnum.POSSIBLE_DUPLICATE).setPartitionIds(thePartitionIds).setResourceType(theRequestResourceType);
        Page mdmLinkPage = this.myMdmLinkDaoSvc.executeTypedQuery(mdmQuerySearchParameters);
        return mdmLinkPage.map(this.myMdmModelConverterSvc::toJson);
    }

    public List<MdmLinkWithRevisionJson> queryLinkHistory(MdmHistorySearchParameters theMdmHistorySearchParameters) {
        List mdmLinkHistoryFromDao = this.myMdmLinkDaoSvc.findMdmLinkHistory(theMdmHistorySearchParameters);
        Comparator<MdmLinkWithRevisionJson> linkHistoryComparator = Comparator.comparing(l -> l.getMdmLink().getGoldenResourceId()).thenComparing(l -> l.getMdmLink().getSourceId()).thenComparing(Comparator.comparingLong(MdmLinkWithRevisionJson::getRevisionNumber).reversed());
        return mdmLinkHistoryFromDao.stream().map(this.myMdmModelConverterSvc::toJson).sorted(linkHistoryComparator).collect(Collectors.toUnmodifiableList());
    }
}

