/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateSearcher;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MdmCandidateSearchSvc;
import ca.uhn.fhir.mdm.api.IMdmMatchFinderSvc;
import ca.uhn.fhir.mdm.api.MatchedTarget;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.rules.svc.MdmResourceMatcherSvc;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MdmMatchFinderSvcImpl
implements IMdmMatchFinderSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private MdmCandidateSearchSvc myMdmCandidateSearchSvc;
    @Autowired
    private MdmResourceMatcherSvc myMdmResourceMatcherSvc;

    @Nonnull
    @Transactional
    public List<MatchedTarget> getMatchedTargets(String theResourceType, IAnyResource theResource, RequestPartitionId theRequestPartitionId) {
        Collection<IAnyResource> targetCandidates = this.myMdmCandidateSearchSvc.findCandidates(theResourceType, theResource, theRequestPartitionId);
        List<MatchedTarget> matches = targetCandidates.stream().map(candidate -> new MatchedTarget(candidate, this.myMdmResourceMatcherSvc.getMatchResult((IBaseResource)theResource, (IBaseResource)candidate))).collect(Collectors.toList());
        ourLog.trace("Found {} matched targets for {}.", (Object)matches.size(), (Object)CandidateSearcher.idOrType(theResource, theResourceType));
        return matches;
    }
}

