/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.svc.MdmSearchParamSvc;
import ca.uhn.fhir.mdm.util.MdmResourceUtil;
import java.util.List;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmResourceFilteringSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private IMdmSettings myMdmSettings;
    @Autowired
    MdmSearchParamSvc myMdmSearchParamSvc;
    @Autowired
    FhirContext myFhirContext;

    public boolean shouldBeProcessed(IAnyResource theResource) {
        if (MdmResourceUtil.isMdmManaged((IBaseResource)theResource)) {
            ourLog.trace("MDM Message handler is dropping [{}] as it is MDM-managed.", (Object)theResource.getId());
            return false;
        }
        String resourceType = this.myFhirContext.getResourceType((IBaseResource)theResource);
        List candidateSearchParams = this.myMdmSettings.getMdmRules().getCandidateSearchParams();
        if (candidateSearchParams.isEmpty()) {
            return true;
        }
        boolean containsValueForSomeSearchParam = candidateSearchParams.stream().filter(csp -> this.myMdmSearchParamSvc.searchParamTypeIsValidForResourceType(csp.getResourceType(), resourceType)).flatMap(csp -> csp.getSearchParams().stream()).map(searchParam -> this.myMdmSearchParamSvc.getValueFromResourceForSearchParam((IBaseResource)theResource, searchParam)).anyMatch(valueList -> !valueList.isEmpty());
        ourLog.trace("Is {} suitable for MDM processing? : {}", (Object)theResource.getId(), (Object)containsValueForSomeSearchParam);
        return containsValueForSomeSearchParam;
    }
}

