/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc.candidate;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.mdm.dao.MdmLinkDaoSvc;
import ca.uhn.fhir.jpa.mdm.svc.MdmResourceDaoSvc;
import ca.uhn.fhir.jpa.mdm.svc.candidate.BaseCandidateFinder;
import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateStrategyEnum;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MatchedGoldenResourceCandidate;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.MdmMatchOutcome;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.CanonicalEID;
import ca.uhn.fhir.mdm.util.EIDHelper;
import ca.uhn.fhir.mdm.util.MdmPartitionHelper;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FindCandidateByEidSvc
extends BaseCandidateFinder {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private EIDHelper myEIDHelper;
    @Autowired
    private MdmResourceDaoSvc myMdmResourceDaoSvc;
    @Autowired
    private MdmLinkDaoSvc myMdmLinkDaoSvc;
    @Autowired
    MdmPartitionHelper myMdmPartitionHelper;

    @Override
    protected List<MatchedGoldenResourceCandidate> findMatchGoldenResourceCandidates(IAnyResource theIncomingResource) {
        ArrayList<MatchedGoldenResourceCandidate> retval = new ArrayList<MatchedGoldenResourceCandidate>();
        List eidFromResource = this.myEIDHelper.getExternalEid((IBaseResource)theIncomingResource);
        if (!eidFromResource.isEmpty()) {
            for (CanonicalEID eid : eidFromResource) {
                IAnyResource foundGoldenResource;
                Optional<IAnyResource> oFoundGoldenResource = this.myMdmResourceDaoSvc.searchGoldenResourceByEID(eid.getValue(), theIncomingResource.getIdElement().getResourceType(), this.myMdmPartitionHelper.getRequestPartitionIdFromResourceForSearch(theIncomingResource));
                if (!oFoundGoldenResource.isPresent() || this.isNoMatch(foundGoldenResource = oFoundGoldenResource.get(), theIncomingResource)) continue;
                IResourcePersistentId pidOrNull = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), (IBaseResource)foundGoldenResource);
                MatchedGoldenResourceCandidate mpc = new MatchedGoldenResourceCandidate(pidOrNull, MdmMatchOutcome.EID_MATCH);
                ourLog.debug("Incoming Resource {} matched Golden Resource {} by EID {}", new Object[]{theIncomingResource.getIdElement().toUnqualifiedVersionless(), foundGoldenResource.getIdElement().toUnqualifiedVersionless(), eid});
                retval.add(mpc);
            }
        }
        return retval;
    }

    private boolean isNoMatch(IAnyResource theGoldenResource, IAnyResource theSourceResource) {
        Optional oLink = this.myMdmLinkDaoSvc.getLinkByGoldenResourceAndSourceResource(theGoldenResource, theSourceResource);
        if (oLink.isEmpty()) {
            return false;
        }
        IMdmLink link = (IMdmLink)oLink.get();
        return link.isNoMatch();
    }

    @Override
    protected CandidateStrategyEnum getStrategy() {
        return CandidateStrategyEnum.EID;
    }
}

