/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.broker;

import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.mdm.svc.IMdmModelConverterSvc;
import ca.uhn.fhir.jpa.mdm.svc.MdmMatchLinkSvc;
import ca.uhn.fhir.jpa.mdm.svc.MdmResourceFilteringSvc;
import ca.uhn.fhir.jpa.mdm.svc.candidate.TooManyCandidatesException;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicUtil;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.model.mdmevents.MdmLinkEvent;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.server.TransactionLogMessages;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import ca.uhn.fhir.rest.server.messaging.ResourceOperationMessage;
import jakarta.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.MessagingException;
import org.springframework.stereotype.Service;

@Service
public class MdmMessageListener
implements IMessageListener<ResourceModifiedMessage> {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private MdmMatchLinkSvc myMdmMatchLinkSvc;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private MdmResourceFilteringSvc myMdmResourceFilteringSvc;
    @Autowired
    private IMdmSettings myMdmSettings;
    @Autowired
    private IMdmModelConverterSvc myModelConverter;

    public void handleMessage(@Nonnull IMessage<ResourceModifiedMessage> theMessage) throws MessagingException {
        ourLog.trace("Handling resource modified message: {}", theMessage);
        ResourceModifiedMessage msg = (ResourceModifiedMessage)theMessage.getPayload();
        try {
            IBaseResource sourceResource = this.extractSourceResource(msg);
            boolean toProcess = this.myMdmResourceFilteringSvc.shouldBeProcessed((IAnyResource)sourceResource);
            if (toProcess) {
                this.matchMdmAndUpdateLinks(sourceResource, msg);
            }
        }
        catch (Exception e) {
            ourLog.error("Failed to handle MDM Matching Resource:", (Throwable)e);
            throw e;
        }
    }

    public Class<ResourceModifiedMessage> getPayloadType() {
        return ResourceModifiedMessage.class;
    }

    private IBaseResource extractSourceResource(ResourceModifiedMessage theResourceModifiedMessage) {
        IBaseResource sourceResource = theResourceModifiedMessage.getNewResource(this.myFhirContext);
        if (this.myFhirContext.getVersion().getVersion() == FhirVersionEnum.R5 && sourceResource instanceof IBaseBundle) {
            return SubscriptionTopicUtil.extractResourceFromBundle((FhirContext)this.myFhirContext, (IBaseBundle)((IBaseBundle)sourceResource));
        }
        return sourceResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void matchMdmAndUpdateLinks(IBaseResource theSourceResource, ResourceModifiedMessage theMsg) {
        String resourceType = theSourceResource.getIdElement().getResourceType();
        this.validateResourceType(resourceType);
        if (this.myInterceptorBroadcaster.hasHooks((IPointcut)Pointcut.MDM_BEFORE_PERSISTED_RESOURCE_CHECKED)) {
            HookParams params = new HookParams().add(IBaseResource.class, (Object)theSourceResource);
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.MDM_BEFORE_PERSISTED_RESOURCE_CHECKED, params);
        }
        theSourceResource.setUserData(Constants.RESOURCE_PARTITION_ID, (Object)theMsg.getPartitionId());
        MdmTransactionContext mdmContext = this.createMdmContext(theMsg, resourceType);
        try {
            switch (theMsg.getOperationType()) {
                case CREATE: {
                    this.handleCreateResource(theSourceResource, mdmContext);
                    return;
                }
                case UPDATE: 
                case MANUALLY_TRIGGERED: {
                    this.handleUpdateResource(theSourceResource, mdmContext);
                    return;
                }
                default: {
                    ourLog.trace("Not processing modified message for {}", (Object)theMsg.getOperationType());
                    return;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof TooManyCandidatesException) {
                ourLog.debug("Failed to handle MDM Matching for resource: {} since candidate matches exceeded the candidate search limit", (Object)theSourceResource.getIdElement());
            }
            this.log(mdmContext, "Failure during MDM processing: " + e.getMessage(), e);
            mdmContext.addTransactionLogMessage(e.getMessage());
            return;
        }
        finally {
            HookParams params = new HookParams().add(ResourceOperationMessage.class, (Object)this.getOutgoingMessage(theMsg)).add(TransactionLogMessages.class, (Object)mdmContext.getTransactionLogMessages()).add(MdmLinkEvent.class, (Object)this.buildLinkChangeEvent(mdmContext));
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.MDM_AFTER_PERSISTED_RESOURCE_CHECKED, params);
        }
    }

    private MdmTransactionContext createMdmContext(ResourceModifiedMessage theMsg, String theResourceType) {
        TransactionLogMessages transactionLogMessages = TransactionLogMessages.createFromTransactionGuid((String)theMsg.getTransactionId());
        return new MdmTransactionContext(transactionLogMessages, switch (theMsg.getOperationType()) {
            case BaseResourceMessage.OperationTypeEnum.CREATE -> MdmTransactionContext.OperationType.CREATE_RESOURCE;
            case BaseResourceMessage.OperationTypeEnum.UPDATE -> MdmTransactionContext.OperationType.UPDATE_RESOURCE;
            case BaseResourceMessage.OperationTypeEnum.MANUALLY_TRIGGERED -> MdmTransactionContext.OperationType.SUBMIT_RESOURCE_TO_MDM;
            default -> {
                ourLog.trace("Not creating an MdmTransactionContext for {}", (Object)theMsg.getOperationType());
                throw new InvalidRequestException(Msg.code((int)734) + "We can't handle non-update/create operations in MDM");
            }
        }, theResourceType);
    }

    private void validateResourceType(String theResourceType) {
        if (!this.myMdmSettings.isSupportedMdmType(theResourceType)) {
            throw new IllegalStateException(Msg.code((int)735) + "Unsupported resource type submitted to MDM matching queue: " + theResourceType);
        }
    }

    private void handleCreateResource(IBaseResource theResource, MdmTransactionContext theMdmTransactionContext) {
        this.myMdmMatchLinkSvc.updateMdmLinksForMdmSource((IAnyResource)theResource, theMdmTransactionContext);
    }

    private void handleUpdateResource(IBaseResource theResource, MdmTransactionContext theMdmTransactionContext) {
        this.myMdmMatchLinkSvc.updateMdmLinksForMdmSource((IAnyResource)theResource, theMdmTransactionContext);
    }

    private void log(MdmTransactionContext theMdmContext, String theMessage, Exception theException) {
        theMdmContext.addTransactionLogMessage(theMessage);
        ourLog.error(theMessage, (Throwable)theException);
    }

    private MdmLinkEvent buildLinkChangeEvent(MdmTransactionContext theMdmContext) {
        MdmLinkEvent linkChangeEvent = new MdmLinkEvent();
        theMdmContext.getMdmLinks().stream().forEach(l -> linkChangeEvent.addMdmLink(this.myModelConverter.toJson((IMdmLink)l)));
        return linkChangeEvent;
    }

    private ResourceOperationMessage getOutgoingMessage(ResourceModifiedMessage theMsg) {
        IBaseResource targetResource = theMsg.getResource(this.myFhirContext);
        ResourceOperationMessage outgoingMsg = new ResourceOperationMessage(this.myFhirContext, targetResource, theMsg.getOperationType());
        outgoingMsg.setTransactionId(theMsg.getTransactionId());
        return outgoingMsg;
    }
}

