/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.broker;

import ca.uhn.fhir.broker.api.ChannelConsumerSettings;
import ca.uhn.fhir.broker.api.IBrokerClient;
import ca.uhn.fhir.broker.api.IChannelConsumer;
import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.jpa.mdm.broker.MdmMessageListener;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.MdmModeEnum;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.util.IoUtils;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.PreDestroy;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MdmQueueConsumerLoader {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    private final IBrokerClient myBrokerClient;
    private final IMdmSettings myMdmSettings;
    private final MdmMessageListener myMdmMessageListener;
    protected IChannelConsumer<ResourceModifiedMessage> myMdmConsumer;

    public MdmQueueConsumerLoader(IBrokerClient theBrokerClient, IMdmSettings theMdmSettings, MdmMessageListener theMdmMessageListener) {
        this.myBrokerClient = theBrokerClient;
        this.myMdmSettings = theMdmSettings;
        this.myMdmMessageListener = theMdmMessageListener;
        if (this.myMdmSettings.getMode() == MdmModeEnum.MATCH_ONLY) {
            ourLog.info("MDM running in {} mode. MDM channel consumer disabled.", (Object)this.myMdmSettings.getMode());
            return;
        }
        this.startListeningToMdmChannel();
    }

    protected ChannelConsumerSettings getChannelConsumerSettings() {
        return new ChannelConsumerSettings();
    }

    private void startListeningToMdmChannel() {
        if (this.myMdmConsumer == null) {
            ChannelConsumerSettings config = this.getChannelConsumerSettings();
            config.setConcurrentConsumers(this.myMdmSettings.getConcurrentConsumers());
            this.myMdmConsumer = this.myBrokerClient.getOrCreateConsumer("empi", ResourceModifiedJsonMessage.class, (IMessageListener)this.myMdmMessageListener, config);
            if (this.myMdmConsumer == null) {
                ourLog.error("Unable to create receiver for {}", (Object)"empi");
            } else {
                ourLog.info("MDM Matching Consumer subscribed to Matching Channel {} with name {}", (Object)this.myMdmConsumer.getClass().getName(), (Object)this.myMdmConsumer.getChannelName());
            }
        }
    }

    @PreDestroy
    public void stop() throws Exception {
        IoUtils.closeQuietly(this.myMdmConsumer, (Logger)ourLog);
        ourLog.info("MDM Matching Consumer closed");
    }

    @VisibleForTesting
    public IChannelConsumer<ResourceModifiedMessage> getMdmChannelConsumerForUnitTest() {
        return this.myMdmConsumer;
    }
}

