/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.config;

import ca.uhn.fhir.broker.api.ChannelProducerSettings;
import ca.uhn.fhir.broker.api.IChannelNamer;
import ca.uhn.fhir.broker.api.IChannelSettings;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionLoader;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import ca.uhn.fhir.jpa.topic.ISubscriptionTopicLoader;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.Subscription;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmSubscriptionLoader {
    public static final String MDM_SUBSCRIPTION_ID_PREFIX = "mdm-";
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    public FhirContext myFhirContext;
    @Autowired
    public DaoRegistry myDaoRegistry;
    @Autowired
    IChannelNamer myChannelNamer;
    @Autowired
    private SubscriptionLoader mySubscriptionLoader;
    @Autowired
    private IMdmSettings myMdmSettings;
    @Autowired(required=false)
    private ISubscriptionTopicLoader mySubscriptionTopicLoader;
    private IFhirResourceDao<IBaseResource> mySubscriptionDao;

    public synchronized void daoUpdateMdmSubscriptions() {
        List mdmResourceTypes = this.myMdmSettings.getMdmRules().getMdmTypes();
        List<Object> subscriptions = switch (this.myFhirContext.getVersion().getVersion()) {
            case FhirVersionEnum.DSTU3 -> mdmResourceTypes.stream().map(resourceType -> this.buildMdmSubscriptionDstu3(MDM_SUBSCRIPTION_ID_PREFIX + resourceType, resourceType + "?")).collect(Collectors.toList());
            case FhirVersionEnum.R4 -> mdmResourceTypes.stream().map(resourceType -> this.buildMdmSubscriptionR4(MDM_SUBSCRIPTION_ID_PREFIX + resourceType, resourceType + "?")).collect(Collectors.toList());
            case FhirVersionEnum.R5 -> {
                SubscriptionTopic subscriptionTopic = this.buildMdmSubscriptionTopicR5(mdmResourceTypes);
                this.updateSubscriptionTopic(subscriptionTopic);
                this.mySubscriptionTopicLoader.requestRefresh();
                yield this.buildMdmSubscriptionR5(subscriptionTopic);
            }
            default -> throw new ConfigurationException(Msg.code((int)736) + "MDM not supported for FHIR version " + String.valueOf(this.myFhirContext.getVersion().getVersion()));
        };
        this.mySubscriptionDao = this.myDaoRegistry.getResourceDao("Subscription");
        for (IBaseResource iBaseResource : subscriptions) {
            this.updateIfNotPresent(iBaseResource);
        }
        if (!subscriptions.isEmpty()) {
            this.mySubscriptionLoader.requestRefresh();
        }
    }

    synchronized void updateIfNotPresent(IBaseResource theSubscription) {
        try {
            this.mySubscriptionDao.read(theSubscription.getIdElement(), (RequestDetails)SystemRequestDetails.forAllPartitions());
        }
        catch (ResourceGoneException | ResourceNotFoundException e) {
            ourLog.info("Creating subscription {}", (Object)theSubscription.getIdElement());
            this.mySubscriptionDao.update(theSubscription, (RequestDetails)SystemRequestDetails.forAllPartitions());
        }
    }

    synchronized void updateSubscriptionTopic(SubscriptionTopic theSubscriptionTopic) {
        IFhirResourceDao subscriptionTopicDao = this.myDaoRegistry.getResourceDao("SubscriptionTopic");
        subscriptionTopicDao.update((IBaseResource)theSubscriptionTopic, (RequestDetails)SystemRequestDetails.forAllPartitions());
    }

    protected ChannelProducerSettings getChannelProducerSettings() {
        return new ChannelProducerSettings();
    }

    private org.hl7.fhir.dstu3.model.Subscription buildMdmSubscriptionDstu3(String theId, String theCriteria) {
        org.hl7.fhir.dstu3.model.Subscription retval = new org.hl7.fhir.dstu3.model.Subscription();
        retval.setId(theId);
        retval.setReason("MDM");
        retval.setStatus(Subscription.SubscriptionStatus.REQUESTED);
        retval.setCriteria(theCriteria);
        retval.getMeta().addTag().setSystem("https://hapifhir.org/NamingSystem/managing-mdm-system").setCode("HAPI-MDM");
        retval.addExtension().setUrl("https://smilecdr.com/fhir/ns/StructureDefinition/subscription-cross-partition").setValue((org.hl7.fhir.dstu3.model.Type)new org.hl7.fhir.dstu3.model.BooleanType().setValue((Object)true));
        Subscription.SubscriptionChannelComponent channel = retval.getChannel();
        channel.setType(Subscription.SubscriptionChannelType.MESSAGE);
        channel.setEndpoint("channel:" + this.myChannelNamer.getChannelName("empi", (IChannelSettings)this.getChannelProducerSettings()));
        channel.setPayload("application/json");
        return retval;
    }

    private org.hl7.fhir.r4.model.Subscription buildMdmSubscriptionR4(String theId, String theCriteria) {
        org.hl7.fhir.r4.model.Subscription retval = new org.hl7.fhir.r4.model.Subscription();
        retval.setId(theId);
        retval.setReason("MDM");
        retval.setStatus(Subscription.SubscriptionStatus.REQUESTED);
        retval.setCriteria(theCriteria);
        retval.getMeta().addTag().setSystem("https://hapifhir.org/NamingSystem/managing-mdm-system").setCode("HAPI-MDM");
        retval.addExtension().setUrl("https://smilecdr.com/fhir/ns/StructureDefinition/subscription-cross-partition").setValue((Type)new BooleanType().setValue((Object)true));
        Subscription.SubscriptionChannelComponent channel = retval.getChannel();
        channel.setType(Subscription.SubscriptionChannelType.MESSAGE);
        channel.setEndpoint("channel:" + this.myChannelNamer.getChannelName("empi", (IChannelSettings)this.getChannelProducerSettings()));
        channel.setPayload("application/json");
        return retval;
    }

    private SubscriptionTopic buildMdmSubscriptionTopicR5(List<String> theMdmResourceTypes) {
        SubscriptionTopic subscriptionTopic = new SubscriptionTopic();
        subscriptionTopic.setId("mdm-subscription-topic");
        subscriptionTopic.getMeta().addTag().setSystem("https://hapifhir.org/NamingSystem/managing-mdm-system").setCode("HAPI-MDM");
        subscriptionTopic.setStatus(Enumerations.PublicationStatus.ACTIVE);
        subscriptionTopic.setUrl("http://hapifhir.io/fhir/r5/SubscriptionTopic/mdm");
        theMdmResourceTypes.forEach(resourceType -> MdmSubscriptionLoader.buildSubscriptionTopicResourceTriggerComponent(resourceType, subscriptionTopic));
        return subscriptionTopic;
    }

    private static void buildSubscriptionTopicResourceTriggerComponent(String theResourceType, SubscriptionTopic theSubscriptionTopic) {
        SubscriptionTopic.SubscriptionTopicResourceTriggerComponent triggerComponent = theSubscriptionTopic.addResourceTrigger();
        triggerComponent.setResource(theResourceType);
        triggerComponent.addSupportedInteraction(SubscriptionTopic.InteractionTrigger.CREATE);
        triggerComponent.addSupportedInteraction(SubscriptionTopic.InteractionTrigger.UPDATE);
    }

    private List<IBaseResource> buildMdmSubscriptionR5(SubscriptionTopic theSubscriptionTopic) {
        Subscription subscription = new Subscription();
        subscription.setId("mdm-subscription");
        subscription.setReason("MDM");
        subscription.setStatus(Enumerations.SubscriptionStatusCodes.REQUESTED);
        subscription.setTopic(theSubscriptionTopic.getUrl());
        subscription.getMeta().addTag().setSystem("https://hapifhir.org/NamingSystem/managing-mdm-system").setCode("HAPI-MDM");
        subscription.setChannelType(new Coding().setCode(CanonicalSubscriptionChannelType.MESSAGE.toCode()).setSystem(CanonicalSubscriptionChannelType.MESSAGE.getSystem()));
        subscription.setEndpoint("channel:" + this.myChannelNamer.getChannelName("empi", (IChannelSettings)this.getChannelProducerSettings()));
        subscription.setContentType("application/json");
        return Collections.singletonList(subscription);
    }
}

