/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.api.svc.ResolveIdentityMode;
import ca.uhn.fhir.jpa.mdm.dao.MdmLinkDaoSvc;
import ca.uhn.fhir.mdm.api.IGoldenResourceMergerSvc;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.IMdmLinkSvc;
import ca.uhn.fhir.mdm.api.IMdmResourceDaoSvc;
import ca.uhn.fhir.mdm.api.IMdmSurvivorshipService;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchOutcome;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmMergeGoldenResourcesParams;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.model.mdmevents.MdmEventResource;
import ca.uhn.fhir.mdm.model.mdmevents.MdmMergeEvent;
import ca.uhn.fhir.mdm.util.GoldenResourceHelper;
import ca.uhn.fhir.mdm.util.MdmPartitionHelper;
import ca.uhn.fhir.mdm.util.MdmResourceUtil;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoldenResourceMergerSvcImpl
implements IGoldenResourceMergerSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    GoldenResourceHelper myGoldenResourceHelper;
    @Autowired
    MdmLinkDaoSvc myMdmLinkDaoSvc;
    @Autowired
    IMdmLinkSvc myMdmLinkSvc;
    @Autowired
    IIdHelperService myIdHelperService;
    @Autowired
    IMdmResourceDaoSvc myMdmResourceDaoSvc;
    @Autowired
    MdmPartitionHelper myMdmPartitionHelper;
    @Autowired
    IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private IMdmSurvivorshipService myMdmSurvivorshipService;

    @Transactional
    public IAnyResource mergeGoldenResources(MdmMergeGoldenResourcesParams theParams) {
        MdmTransactionContext mdmTransactionContext = theParams.getMdmTransactionContext();
        IAnyResource mergedResource = theParams.getManuallyMergedResource();
        IAnyResource fromGoldenResource = theParams.getFromGoldenResource();
        IAnyResource toGoldenResource = theParams.getToGoldenResource();
        String resourceType = mdmTransactionContext.getResourceType();
        if (mergedResource != null) {
            if (this.myGoldenResourceHelper.hasIdentifier((IBaseResource)mergedResource)) {
                throw new IllegalArgumentException(Msg.code((int)751) + "Manually merged resource can not contain identifiers");
            }
            this.myGoldenResourceHelper.mergeIndentifierFields((IBaseResource)fromGoldenResource, (IBaseResource)mergedResource, mdmTransactionContext);
            this.myGoldenResourceHelper.mergeIndentifierFields((IBaseResource)toGoldenResource, (IBaseResource)mergedResource, mdmTransactionContext);
            mergedResource.setId(toGoldenResource.getId());
            toGoldenResource = (IAnyResource)this.myMdmResourceDaoSvc.upsertGoldenResource(mergedResource, resourceType).getResource();
        } else {
            this.myGoldenResourceHelper.mergeIndentifierFields((IBaseResource)fromGoldenResource, (IBaseResource)toGoldenResource, mdmTransactionContext);
            this.myMdmSurvivorshipService.applySurvivorshipRulesToGoldenResource((IBase)fromGoldenResource, (IBase)toGoldenResource, mdmTransactionContext);
            this.myMdmResourceDaoSvc.upsertGoldenResource(toGoldenResource, resourceType);
        }
        this.myMdmPartitionHelper.validateMdmResourcesPartitionMatches(fromGoldenResource, toGoldenResource);
        this.mergeGoldenResourceLinks(fromGoldenResource, toGoldenResource, fromGoldenResource.getIdElement(), mdmTransactionContext);
        this.addMergeLink(toGoldenResource, fromGoldenResource, resourceType, mdmTransactionContext);
        this.myMdmResourceDaoSvc.removeGoldenResourceTag(fromGoldenResource, resourceType);
        MdmResourceUtil.setGoldenResourceRedirected((IBaseResource)fromGoldenResource);
        this.myMdmResourceDaoSvc.upsertGoldenResource(fromGoldenResource, resourceType);
        this.log(mdmTransactionContext, "Merged " + String.valueOf(fromGoldenResource.getIdElement().toVersionless()) + " into " + String.valueOf(toGoldenResource.getIdElement().toVersionless()));
        this.invokeMdmMergeGoldenResourcesHook(theParams, fromGoldenResource, toGoldenResource);
        return toGoldenResource;
    }

    private void invokeMdmMergeGoldenResourcesHook(MdmMergeGoldenResourcesParams theParams, IAnyResource fromGoldenResource, IAnyResource toGoldenResource) {
        if (this.myInterceptorBroadcaster.hasHooks((IPointcut)Pointcut.MDM_POST_MERGE_GOLDEN_RESOURCES)) {
            MdmMergeEvent event = new MdmMergeEvent();
            MdmEventResource from = new MdmEventResource();
            from.setId(fromGoldenResource.getIdElement().toUnqualifiedVersionless().getValue());
            from.setResourceType(fromGoldenResource.fhirType());
            from.setIsGoldenResource(true);
            event.setFromResource(from);
            MdmEventResource to = new MdmEventResource();
            to.setId(toGoldenResource.getIdElement().toUnqualifiedVersionless().getValue());
            to.setResourceType(toGoldenResource.fhirType());
            to.setIsGoldenResource(true);
            event.setToResource(to);
            HookParams params = new HookParams();
            params.add(MdmMergeEvent.class, (Object)event);
            params.add(RequestDetails.class, (Object)theParams.getRequestDetails());
            params.add(MdmTransactionContext.class, (Object)theParams.getMdmTransactionContext());
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.MDM_POST_MERGE_GOLDEN_RESOURCES, params);
        }
    }

    private void addMergeLink(IAnyResource theGoldenResource, IAnyResource theTargetResource, String theResourceType, MdmTransactionContext theMdmTransactionContext) {
        this.myMdmLinkSvc.deleteLink(theGoldenResource, theTargetResource, theMdmTransactionContext);
        this.myMdmLinkDaoSvc.createOrUpdateLinkEntity(theTargetResource, theGoldenResource, new MdmMatchOutcome(null, null).setMatchResultEnum(MdmMatchResultEnum.REDIRECT), MdmLinkSourceEnum.MANUAL, theMdmTransactionContext);
    }

    private RequestPartitionId getPartitionIdForResource(IAnyResource theResource) {
        RequestPartitionId partitionId = (RequestPartitionId)theResource.getUserData(Constants.RESOURCE_PARTITION_ID);
        if (partitionId == null) {
            partitionId = RequestPartitionId.allPartitions();
        }
        return partitionId;
    }

    private void mergeGoldenResourceLinks(IAnyResource theFromResource, IAnyResource theToResource, IIdType theToResourcePid, MdmTransactionContext theMdmTransactionContext) {
        List fromLinks = this.myMdmLinkDaoSvc.findMdmLinksByGoldenResource((IBaseResource)theFromResource);
        List toLinks = this.myMdmLinkDaoSvc.findMdmLinksByGoldenResource((IBaseResource)theToResource);
        ArrayList<IMdmLink> toDelete = new ArrayList<IMdmLink>();
        IResourcePersistentId goldenResourcePid = this.myIdHelperService.resolveResourceIdentityPid(this.getPartitionIdForResource(theToResource), theToResource.getIdElement().getResourceType(), theToResource.getIdElement().getIdPart(), ResolveIdentityMode.includeDeleted().cacheOk());
        for (IMdmLink fromLink : fromLinks) {
            Optional<? extends IMdmLink> optionalToLink = this.findFirstLinkWithMatchingSource(toLinks, fromLink);
            if (optionalToLink.isPresent()) {
                IMdmLink toLink = optionalToLink.get();
                if (fromLink.isManual()) {
                    switch (toLink.getLinkSource()) {
                        case AUTO: {
                            this.log(theMdmTransactionContext, String.format("MANUAL overrides AUT0.  Deleting link %s", toLink.toString()));
                            this.myMdmLinkDaoSvc.deleteLink(toLink);
                            break;
                        }
                        case MANUAL: {
                            if (fromLink.getMatchResult() == toLink.getMatchResult()) break;
                            throw new InvalidRequestException(Msg.code((int)752) + "A MANUAL " + String.valueOf(fromLink.getMatchResult()) + " link may not be merged into a MANUAL " + String.valueOf(toLink.getMatchResult()) + " link for the same target");
                        }
                    }
                } else {
                    toDelete.add(fromLink);
                    continue;
                }
            }
            if (fromLink.getSourcePersistenceId().equals(goldenResourcePid)) {
                this.myMdmLinkDaoSvc.deleteLink(fromLink);
                continue;
            }
            fromLink.setGoldenResourcePersistenceId(goldenResourcePid);
            ourLog.trace("Saving link {}", (Object)fromLink);
            this.myMdmLinkDaoSvc.save(fromLink);
        }
        toDelete.forEach(link -> this.myMdmLinkDaoSvc.deleteLink(link));
    }

    private Optional<? extends IMdmLink> findFirstLinkWithMatchingSource(List<? extends IMdmLink> theMdmLinks, IMdmLink theLinkWithSourceToMatch) {
        return theMdmLinks.stream().filter(mdmLink -> mdmLink.getSourcePersistenceId().equals(theLinkWithSourceToMatch.getSourcePersistenceId())).findFirst();
    }

    private void log(MdmTransactionContext theMdmTransactionContext, String theMessage) {
        theMdmTransactionContext.addTransactionLogMessage(theMessage);
        ourLog.debug(theMessage);
    }
}

