/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.pid.IResourcePidStream;
import ca.uhn.fhir.jpa.api.pid.StreamTemplate;
import ca.uhn.fhir.jpa.api.pid.TypedResourcePid;
import ca.uhn.fhir.jpa.api.pid.TypedResourceStream;
import ca.uhn.fhir.jpa.api.svc.IGoldenResourceSearchSvc;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.util.DateRangeUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionOperations;

public class GoldenResourceSearchSvcImpl
implements IGoldenResourceSearchSvc {
    @Autowired
    private MatchUrlService myMatchUrlService;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private IHapiTransactionService myTransactionService;

    @Transactional
    public IResourcePidStream fetchGoldenResourceIdStream(Date theStart, Date theEnd, @Nullable RequestPartitionId theRequestPartitionId, @Nonnull String theResourceType) {
        IHapiTransactionService.IExecutionBuilder txSettings = this.myTransactionService.withSystemRequest().withRequestPartitionId(theRequestPartitionId);
        Supplier<Stream> streamSupplier = () -> this.fetchResourceIdsPageWithResourceType(theStart, theEnd, theResourceType, theRequestPartitionId);
        StreamTemplate streamTemplate = StreamTemplate.fromSupplier(streamSupplier).withTransactionAdvice((TransactionOperations)txSettings);
        return new TypedResourceStream(theRequestPartitionId, streamTemplate);
    }

    private Stream<TypedResourcePid> fetchResourceIdsPageWithResourceType(Date theStart, Date theEnd, String theResourceType, RequestPartitionId theRequestPartitionId) {
        RuntimeResourceDefinition def = this.myFhirContext.getResourceDefinition(theResourceType);
        SearchParameterMap searchParamMap = this.myMatchUrlService.translateMatchUrl(theResourceType, def, new MatchUrlService.Flag[0]);
        searchParamMap.setSort(new SortSpec("_lastUpdated", SortOrderEnum.ASC));
        DateRangeParam chunkDateRange = DateRangeUtil.narrowDateRange((DateRangeParam)searchParamMap.getLastUpdated(), (Date)theStart, (Date)theEnd);
        searchParamMap.setLastUpdated(chunkDateRange);
        TokenOrListParam goldenRecordStatusToken = new TokenOrListParam().add("http://hapifhir.io/fhir/NamingSystem/mdm-record-status", "REDIRECTED").add("http://hapifhir.io/fhir/NamingSystem/mdm-record-status", "GOLDEN_RECORD");
        searchParamMap.add("_tag", (IQueryParameterOr)goldenRecordStatusToken);
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResourceType);
        SystemRequestDetails request = new SystemRequestDetails().setRequestPartitionId(theRequestPartitionId);
        return dao.searchForIdStream(searchParamMap, (RequestDetails)request, null).map(pid -> new TypedResourcePid(theResourceType, pid));
    }
}

