/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.batch2.api.IJobCoordinator;
import ca.uhn.fhir.batch2.jobs.parameters.PartitionedUrl;
import ca.uhn.fhir.batch2.model.JobInstanceStartRequest;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.batch.models.Batch2JobStartResponse;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.mdm.api.IGoldenResourceMergerSvc;
import ca.uhn.fhir.mdm.api.IMdmControllerSvc;
import ca.uhn.fhir.mdm.api.IMdmLinkCreateSvc;
import ca.uhn.fhir.mdm.api.IMdmLinkQuerySvc;
import ca.uhn.fhir.mdm.api.IMdmLinkUpdaterSvc;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.api.paging.MdmPageRequest;
import ca.uhn.fhir.mdm.api.params.MdmHistorySearchParameters;
import ca.uhn.fhir.mdm.api.params.MdmQuerySearchParameters;
import ca.uhn.fhir.mdm.batch2.clear.MdmClearJobParameters;
import ca.uhn.fhir.mdm.batch2.submit.MdmSubmitAppCtx;
import ca.uhn.fhir.mdm.batch2.submit.MdmSubmitJobParameters;
import ca.uhn.fhir.mdm.model.MdmCreateOrUpdateParams;
import ca.uhn.fhir.mdm.model.MdmMergeGoldenResourcesParams;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.model.MdmUnduplicateGoldenResourceParams;
import ca.uhn.fhir.mdm.model.mdmevents.MdmClearEvent;
import ca.uhn.fhir.mdm.model.mdmevents.MdmLinkJson;
import ca.uhn.fhir.mdm.model.mdmevents.MdmLinkWithRevisionJson;
import ca.uhn.fhir.mdm.model.mdmevents.MdmSubmitEvent;
import ca.uhn.fhir.mdm.provider.MdmControllerHelper;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ParametersUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class MdmControllerSvcImpl
implements IMdmControllerSvc {
    @Autowired
    FhirContext myFhirContext;
    @Autowired
    MdmControllerHelper myMdmControllerHelper;
    @Autowired
    IGoldenResourceMergerSvc myGoldenResourceMergerSvc;
    @Autowired
    IMdmLinkQuerySvc myMdmLinkQuerySvc;
    @Autowired
    IMdmLinkUpdaterSvc myIMdmLinkUpdaterSvc;
    @Autowired
    IMdmLinkCreateSvc myIMdmLinkCreateSvc;
    @Autowired
    IRequestPartitionHelperSvc myRequestPartitionHelperSvc;
    @Autowired
    IJobCoordinator myJobCoordinator;
    @Autowired
    IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private HapiTransactionService myTxService;

    public IAnyResource mergeGoldenResources(MdmMergeGoldenResourcesParams theParams) {
        if (theParams.getFromGoldenResource() == null) {
            theParams.setFromGoldenResource(this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("fromGoldenResourceId", theParams.getFromGoldenResourceId()));
        }
        IAnyResource fromGoldenResource = theParams.getFromGoldenResource();
        if (theParams.getToGoldenResource() == null) {
            theParams.setToGoldenResource(this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("toGoldenResourceId", theParams.getToGoldenResourceId()));
        }
        IAnyResource toGoldenResource = theParams.getToGoldenResource();
        this.myMdmControllerHelper.validateMergeResources(fromGoldenResource, toGoldenResource);
        this.myMdmControllerHelper.validateSameVersion(fromGoldenResource, theParams.getFromGoldenResourceId());
        this.myMdmControllerHelper.validateSameVersion(toGoldenResource, theParams.getToGoldenResourceId());
        return this.myGoldenResourceMergerSvc.mergeGoldenResources(theParams);
    }

    public IAnyResource updateLink(String theGoldenResourceId, String theSourceResourceId, String theMatchResult, MdmTransactionContext theMdmTransactionContext) {
        MdmCreateOrUpdateParams params = new MdmCreateOrUpdateParams();
        params.setResourceId(theSourceResourceId);
        params.setGoldenResourceId(theGoldenResourceId);
        params.setMdmContext(theMdmTransactionContext);
        params.setMatchResult(MdmMatchResultEnum.valueOf((String)theMatchResult));
        return this.updateLink(params);
    }

    @Deprecated
    public Page<MdmLinkJson> queryLinks(@Nullable String theGoldenResourceId, @Nullable String theSourceResourceId, @Nullable String theMatchResult, @Nullable String theLinkSource, MdmTransactionContext theMdmTransactionContext, MdmPageRequest thePageRequest) {
        MdmQuerySearchParameters mdmQuerySearchParameters = new MdmQuerySearchParameters(thePageRequest).setGoldenResourceId(theGoldenResourceId).setSourceId(theSourceResourceId).setMatchResult(theMatchResult).setLinkSource(theLinkSource);
        return this.queryLinksFromPartitionList(mdmQuerySearchParameters, theMdmTransactionContext);
    }

    @Deprecated
    public Page<MdmLinkJson> queryLinks(@Nullable String theGoldenResourceId, @Nullable String theSourceResourceId, @Nullable String theMatchResult, @Nullable String theLinkSource, MdmTransactionContext theMdmTransactionContext, MdmPageRequest thePageRequest, @Nullable RequestDetails theRequestDetails) {
        MdmQuerySearchParameters mdmQuerySearchParameters = new MdmQuerySearchParameters(thePageRequest).setGoldenResourceId(theGoldenResourceId).setSourceId(theSourceResourceId).setMatchResult(theMatchResult).setLinkSource(theLinkSource);
        return this.queryLinks(mdmQuerySearchParameters, theMdmTransactionContext, theRequestDetails);
    }

    public Page<MdmLinkJson> queryLinks(MdmQuerySearchParameters theMdmQuerySearchParameters, MdmTransactionContext theMdmTransactionContext, RequestDetails theRequestDetails) {
        RequestPartitionId theReadPartitionId = this.myRequestPartitionHelperSvc.determineReadPartitionForRequestForServerOperation(theRequestDetails, "$mdm-query-links");
        if (theReadPartitionId.hasPartitionIds()) {
            theMdmQuerySearchParameters.setPartitionIds(theReadPartitionId.getPartitionIds());
        }
        Page<MdmLinkJson> resultPage = this.queryLinksFromPartitionList(theMdmQuerySearchParameters, theMdmTransactionContext);
        this.validateMdmQueryPermissions(theReadPartitionId, resultPage.getContent(), theRequestDetails);
        return resultPage;
    }

    public List<MdmLinkWithRevisionJson> queryLinkHistory(MdmHistorySearchParameters theMdmHistorySearchParameters, RequestDetails theRequestDetails) {
        return (List)this.myTxService.withRequest(theRequestDetails).execute(() -> this.myMdmLinkQuerySvc.queryLinkHistory(theMdmHistorySearchParameters));
    }

    @Deprecated
    public Page<MdmLinkJson> queryLinksFromPartitionList(@Nullable String theGoldenResourceId, @Nullable String theSourceResourceId, @Nullable String theMatchResult, @Nullable String theLinkSource, MdmTransactionContext theMdmTransactionContext, MdmPageRequest thePageRequest, @Nullable List<Integer> thePartitionIds) {
        MdmQuerySearchParameters mdmQuerySearchParameters = new MdmQuerySearchParameters(thePageRequest).setGoldenResourceId(theGoldenResourceId).setSourceId(theSourceResourceId).setMatchResult(theMatchResult).setLinkSource(theLinkSource).setPartitionIds(thePartitionIds);
        return this.queryLinksFromPartitionList(mdmQuerySearchParameters, theMdmTransactionContext);
    }

    public Page<MdmLinkJson> queryLinksFromPartitionList(MdmQuerySearchParameters theMdmQuerySearchParameters, MdmTransactionContext theMdmTransactionContext) {
        return this.myMdmLinkQuerySvc.queryLinks(theMdmQuerySearchParameters, theMdmTransactionContext);
    }

    public Page<MdmLinkJson> getDuplicateGoldenResources(MdmTransactionContext theMdmTransactionContext, MdmPageRequest thePageRequest) {
        return this.myMdmLinkQuerySvc.getDuplicateGoldenResources(theMdmTransactionContext, thePageRequest, null, null);
    }

    public Page<MdmLinkJson> getDuplicateGoldenResources(MdmTransactionContext theMdmTransactionContext, MdmPageRequest thePageRequest, RequestDetails theRequestDetails, String theRequestResourceType) {
        RequestPartitionId readPartitionId = this.myRequestPartitionHelperSvc.determineReadPartitionForRequestForServerOperation(theRequestDetails, "$mdm-duplicate-golden-resources");
        Page resultPage = readPartitionId.isAllPartitions() ? this.myMdmLinkQuerySvc.getDuplicateGoldenResources(theMdmTransactionContext, thePageRequest, null, theRequestResourceType) : this.myMdmLinkQuerySvc.getDuplicateGoldenResources(theMdmTransactionContext, thePageRequest, readPartitionId.getPartitionIds(), theRequestResourceType);
        this.validateMdmQueryPermissions(readPartitionId, resultPage.getContent(), theRequestDetails);
        return resultPage;
    }

    private void convertAndValidateParameters(MdmCreateOrUpdateParams theParams) {
        if (theParams.getGoldenResource() == null) {
            IAnyResource goldenResource = this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("goldenResourceId", theParams.getGoldenResourceId());
            theParams.setGoldenResource(goldenResource);
        }
        if (theParams.getSourceResource() == null) {
            IAnyResource source = this.myMdmControllerHelper.getLatestSourceFromIdOrThrowException("resourceId", theParams.getResourceId());
            theParams.setSourceResource(source);
        }
        this.myMdmControllerHelper.validateSameVersion(theParams.getGoldenResource(), theParams.getGoldenResourceId());
        this.myMdmControllerHelper.validateSameVersion(theParams.getSourceResource(), theParams.getResourceId());
    }

    public IAnyResource updateLink(MdmCreateOrUpdateParams theParams) {
        this.convertAndValidateParameters(theParams);
        return this.myIMdmLinkUpdaterSvc.updateLink(theParams);
    }

    public IAnyResource createLink(String theGoldenResourceId, String theSourceResourceId, @Nullable String theMatchResult, MdmTransactionContext theMdmTransactionContext) {
        MdmCreateOrUpdateParams params = new MdmCreateOrUpdateParams();
        params.setGoldenResourceId(theGoldenResourceId);
        params.setResourceId(theSourceResourceId);
        params.setMdmContext(theMdmTransactionContext);
        if (theMatchResult != null) {
            params.setMatchResult(MdmMatchResultEnum.valueOf((String)theMatchResult));
        }
        return this.createLink(params);
    }

    public IAnyResource createLink(MdmCreateOrUpdateParams theParams) {
        this.convertAndValidateParameters(theParams);
        return this.myIMdmLinkCreateSvc.createLink(theParams);
    }

    public IBaseParameters submitMdmClearJob(@Nonnull List<String> theResourceNames, IPrimitiveType<BigDecimal> theBatchSize, ServletRequestDetails theRequestDetails) {
        boolean hasBatchSize;
        MdmClearJobParameters params = new MdmClearJobParameters();
        params.setResourceNames(theResourceNames);
        boolean bl = hasBatchSize = theBatchSize != null && theBatchSize.getValue() != null && ((BigDecimal)theBatchSize.getValue()).longValue() > 0L;
        if (hasBatchSize) {
            params.setBatchSize(((BigDecimal)theBatchSize.getValue()).intValue());
        }
        RequestPartitionId requestPartition = this.myRequestPartitionHelperSvc.determineReadPartitionForRequestForServerOperation((RequestDetails)theRequestDetails, "$mdm-clear");
        params.setRequestPartitionId(requestPartition);
        JobInstanceStartRequest request = new JobInstanceStartRequest();
        request.setJobDefinitionId("MDM_CLEAR");
        request.setParameters((IModelJson)params);
        Batch2JobStartResponse response = this.myJobCoordinator.startInstance((RequestDetails)theRequestDetails, request);
        String id = response.getInstanceId();
        if (this.myInterceptorBroadcaster.hasHooks((IPointcut)Pointcut.MDM_CLEAR)) {
            MdmClearEvent event = new MdmClearEvent();
            event.setResourceTypes(theResourceNames);
            if (hasBatchSize) {
                event.setBatchSize(Long.valueOf(((BigDecimal)theBatchSize.getValue()).longValue()));
            }
            HookParams hookParams = new HookParams();
            hookParams.add(RequestDetails.class, (Object)theRequestDetails);
            hookParams.add(MdmClearEvent.class, (Object)event);
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.MDM_CLEAR, hookParams);
        }
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.myFhirContext);
        ParametersUtil.addParameterToParametersString((FhirContext)this.myFhirContext, (IBaseParameters)retVal, (String)"jobId", (String)id);
        return retVal;
    }

    public IBaseParameters submitMdmSubmitJob(List<String> theUrls, IPrimitiveType<BigDecimal> theBatchSize, ServletRequestDetails theRequestDetails) {
        boolean hasBatchSize;
        MdmSubmitJobParameters params = new MdmSubmitJobParameters();
        boolean bl = hasBatchSize = theBatchSize != null && theBatchSize.getValue() != null && ((BigDecimal)theBatchSize.getValue()).longValue() > 0L;
        if (hasBatchSize) {
            params.setBatchSize(((BigDecimal)theBatchSize.getValue()).intValue());
        }
        RequestPartitionId partitionId = RequestPartitionId.allPartitions();
        theUrls.forEach(url -> params.addPartitionedUrl(new PartitionedUrl().setUrl(url).setRequestPartitionId(partitionId)));
        JobInstanceStartRequest request = new JobInstanceStartRequest();
        request.setParameters((IModelJson)params);
        request.setJobDefinitionId(MdmSubmitAppCtx.MDM_SUBMIT_JOB);
        Batch2JobStartResponse batch2JobStartResponse = this.myJobCoordinator.startInstance((RequestDetails)theRequestDetails, request);
        String id = batch2JobStartResponse.getInstanceId();
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.myFhirContext);
        ParametersUtil.addParameterToParametersString((FhirContext)this.myFhirContext, (IBaseParameters)retVal, (String)"jobId", (String)id);
        if (this.myInterceptorBroadcaster.hasHooks((IPointcut)Pointcut.MDM_SUBMIT)) {
            MdmSubmitEvent event = new MdmSubmitEvent();
            event.setBatchJob(true);
            event.setUrls(theUrls);
            if (hasBatchSize) {
                event.setBatchSize(Long.valueOf(((BigDecimal)theBatchSize.getValue()).longValue()));
            }
            HookParams hookParams = new HookParams();
            hookParams.add(RequestDetails.class, (Object)theRequestDetails);
            hookParams.add(MdmSubmitEvent.class, (Object)event);
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.MDM_SUBMIT, hookParams);
        }
        return retVal;
    }

    public void notDuplicateGoldenResource(String theGoldenResourceId, String theTargetGoldenResourceId, MdmTransactionContext theMdmTransactionContext) {
        MdmUnduplicateGoldenResourceParams params = new MdmUnduplicateGoldenResourceParams();
        params.setTargetGoldenResourceId(theTargetGoldenResourceId);
        params.setGoldenResourceId(theGoldenResourceId);
        params.setMdmContext(theMdmTransactionContext);
        this.unduplicateGoldenResource(params);
    }

    public void unduplicateGoldenResource(MdmUnduplicateGoldenResourceParams theParams) {
        if (theParams.getGoldenResource() == null) {
            IAnyResource goldenResource = this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("goldenResourceId", theParams.getGoldenResourceId());
            theParams.setGoldenResource(goldenResource);
        }
        if (theParams.getTargetGoldenResource() == null) {
            IAnyResource target = this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("resourceId", theParams.getTargetGoldenResourceId());
            theParams.setTargetGoldenResource(target);
        }
        this.myIMdmLinkUpdaterSvc.unduplicateGoldenResource(theParams);
    }

    public IAnyResource mergeGoldenResources(String theFromGoldenResourceId, String theToGoldenResourceId, IAnyResource theManuallyMergedGoldenResource, MdmTransactionContext theMdmTransactionContext) {
        MdmMergeGoldenResourcesParams params = new MdmMergeGoldenResourcesParams();
        params.setToGoldenResourceId(theToGoldenResourceId);
        params.setFromGoldenResourceId(theFromGoldenResourceId);
        params.setToGoldenResourceId(theToGoldenResourceId);
        params.setManuallyMergedResource(theManuallyMergedGoldenResource);
        params.setMdmTransactionContext(theMdmTransactionContext);
        return this.mergeGoldenResources(params);
    }

    private void validateMdmQueryPermissions(RequestPartitionId theRequestPartitionId, List<MdmLinkJson> theMdmLinkJsonList, RequestDetails theRequestDetails) {
        HashSet<String> seenResourceTypes = new HashSet<String>();
        for (MdmLinkJson mdmLinkJson : theMdmLinkJsonList) {
            IdDt idDt = new IdDt(mdmLinkJson.getSourceId());
            if (seenResourceTypes.contains(idDt.getResourceType())) continue;
            this.myRequestPartitionHelperSvc.validateHasPartitionPermissions(theRequestDetails, idDt.getResourceType(), theRequestPartitionId);
            seenResourceTypes.add(idDt.getResourceType());
        }
    }
}

